/*
 * Decompiled with CFR 0.152.
 */
package ly.count.sdk.java.internal;

import ly.count.sdk.java.internal.CtxCore;
import ly.count.sdk.java.internal.IStorageForRequestQueue;
import ly.count.sdk.java.internal.Log;
import ly.count.sdk.java.internal.Networking;
import ly.count.sdk.java.internal.Request;
import ly.count.sdk.java.internal.SDKCore;
import ly.count.sdk.java.internal.Storage;
import ly.count.sdk.java.internal.Tasks;
import ly.count.sdk.java.internal.Transport;

public class DefaultNetworking
implements Networking {
    private Log L = null;
    private Transport transport;
    private Tasks tasks;
    private boolean shutdown;
    IStorageForRequestQueue storageForRequestQueue;

    @Override
    public void init(CtxCore ctx, IStorageForRequestQueue storageForRequestQueue) {
        this.L = ctx.getLogger();
        this.shutdown = false;
        this.transport = new Transport();
        this.transport.init(ctx.getConfig(), ctx.getLogger());
        this.tasks = new Tasks("network", this.L);
        this.storageForRequestQueue = storageForRequestQueue;
    }

    @Override
    public boolean isSending() {
        return this.tasks.isRunning();
    }

    @Override
    public boolean check(CtxCore ctx) {
        this.L.d("[Networking] [check] state: shutdown [" + this.shutdown + "], tasks running [" + this.tasks.isRunning() + "], net running [" + this.tasks.isRunning() + "], device id [" + ctx.getConfig().getDeviceId() + "]");
        if (!this.shutdown && !this.tasks.isRunning() && ctx.getConfig().getDeviceId() != null) {
            this.tasks.run(this.submit(ctx));
        }
        return this.tasks.isRunning();
    }

    protected Tasks.Task<Boolean> submit(final CtxCore ctx) {
        return new Tasks.Task<Boolean>(Tasks.ID_STRICT){

            @Override
            public Boolean call() throws Exception {
                final Request request = DefaultNetworking.this.storageForRequestQueue.getNextRequest();
                if (request == null) {
                    return false;
                }
                DefaultNetworking.this.L.d("[Networking] Preparing request: " + request);
                Boolean check = SDKCore.instance.isRequestReady(request);
                if (check == null) {
                    DefaultNetworking.this.L.d("[Networking] Request is not ready yet: " + request);
                    return false;
                }
                if (check.equals(Boolean.FALSE)) {
                    DefaultNetworking.this.L.d("[Networking] Request won't be ready, removing: " + request);
                    Storage.remove(ctx, request);
                    return true;
                }
                DefaultNetworking.this.tasks.run(DefaultNetworking.this.transport.send(request), new Tasks.Callback<Boolean>(){

                    @Override
                    public void call(Boolean result) throws Exception {
                        DefaultNetworking.this.L.d("[Networking] Request " + request.storageId() + " sent?: " + result);
                        if (result.booleanValue()) {
                            DefaultNetworking.this.storageForRequestQueue.removeRequest(request);
                            DefaultNetworking.this.check(ctx);
                        }
                    }
                });
                return true;
            }
        };
    }

    @Override
    public void stop(CtxCore ctx) {
        this.shutdown = true;
        this.tasks.shutdown();
    }
}

