/*
 * Decompiled with CFR 0.152.
 */
package ly.count.sdk.java.internal;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ly.count.sdk.java.internal.Log;
import ly.count.sdk.java.internal.Params;
import ly.count.sdk.java.internal.UniformTimeGenerator;
import ly.count.sdk.java.internal.UniqueTimeGenerator;

public class Device {
    public static Device dev = new Device();
    private String device;
    private String resolution;
    private String appVersion;
    private String manufacturer;
    private String cpu;
    private String openGL;
    private Float batteryLevel;
    private String orientation;
    private Boolean online;
    private Boolean muted;
    private Log L;
    private Map<String, String> metricOverride = new HashMap<String, String>();
    protected static final Double NS_IN_SECOND = 1.0E9;
    protected static final Double NS_IN_MS = 1000000.0;
    protected static final Double MS_IN_SECOND = 1000.0;
    protected static final Long BYTES_IN_MB = 0x100000L;
    protected TimeGenerator uniqueTimer = new UniqueTimeGenerator();
    protected TimeGenerator uniformTimer = new UniformTimeGenerator();

    protected Device() {
        dev = this;
    }

    public void setLog(Log L) {
        this.L = L;
    }

    public String getOS() {
        return System.getProperty("os.name");
    }

    public String getOSVersion() {
        return System.getProperty("os.version", "n/a");
    }

    public int getTimezoneOffset() {
        return TimeZone.getDefault().getOffset(new Date().getTime()) / 60000;
    }

    public String getLocale() {
        Locale locale = Locale.getDefault();
        return locale.getLanguage() + "_" + locale.getCountry();
    }

    public Params buildMetrics() {
        Params params = new Params();
        Params.Obj metricObj = params.obj("metrics").put("_device", this.getDevice()).put("_os", this.getOS()).put("_os_version", this.getOSVersion()).put("_resolution", this.getResolution()).put("_locale", this.getLocale()).put("_app_version", this.getAppVersion());
        if (this.metricOverride != null) {
            for (String k : this.metricOverride.keySet()) {
                String overrideValue;
                if (k == null || k.length() == 0 || (overrideValue = this.metricOverride.get(k)) == null) continue;
                metricObj.put(k, overrideValue);
            }
        }
        metricObj.add();
        return params;
    }

    public synchronized long uniqueTimestamp() {
        return this.uniqueTimer.timestamp();
    }

    public synchronized long uniformTimestamp() {
        return this.uniformTimer.timestamp();
    }

    public int currentDayOfWeek() {
        int day = Calendar.getInstance().get(7);
        switch (day) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 5;
            }
            case 7: {
                return 6;
            }
        }
        return 0;
    }

    public int currentHour() {
        return Calendar.getInstance().get(11);
    }

    public int getHourFromCalendar(Calendar calendar) {
        return calendar.get(11);
    }

    public long nsToMs(long ns) {
        return Math.round((double)ns / NS_IN_MS);
    }

    public long nsToSec(long ns) {
        return Math.round((double)ns / NS_IN_SECOND);
    }

    public long secToNs(long sec) {
        return Math.round((double)sec * NS_IN_SECOND);
    }

    public long secToMs(long sec) {
        return Math.round((double)sec * MS_IN_SECOND);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getRAMTotal() {
        RandomAccessFile reader = null;
        try {
            reader = new RandomAccessFile("/proc/meminfo", "r");
            String load = reader.readLine();
            Pattern p = Pattern.compile("(\\d+)");
            Matcher m = p.matcher(load);
            String value = "";
            while (m.find()) {
                value = m.group(1);
            }
            Long l = Long.parseLong(value) / 1024L;
            return l;
        }
        catch (NumberFormatException e) {
            if (this.L != null) {
                this.L.e("[DeviceCore] Cannot parse meminfo " + e.toString());
            }
            Long l = null;
            return l;
        }
        catch (IOException e) {
            if (this.L != null) {
                this.L.e("[DeviceCore] Cannot read meminfo " + e.toString());
            }
            Long l = null;
            return l;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public Long getRAMAvailable() {
        Long total = Runtime.getRuntime().totalMemory();
        Long availMem = Runtime.getRuntime().freeMemory();
        return (total - availMem) / BYTES_IN_MB;
    }

    public Long getDiskAvailable() {
        long total = 0L;
        long free = 0L;
        for (File f : File.listRoots()) {
            total += f.getTotalSpace();
            free += f.getUsableSpace();
        }
        return (total - free) / BYTES_IN_MB;
    }

    public Long getDiskTotal() {
        long total = 0L;
        for (File f : File.listRoots()) {
            total += f.getTotalSpace();
        }
        return total / BYTES_IN_MB;
    }

    public String getDevice() {
        return this.device;
    }

    public Device setDevice(String device) {
        this.device = device;
        return this;
    }

    public String getResolution() {
        return this.resolution;
    }

    public Device setResolution(String resolution) {
        this.resolution = resolution;
        return this;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public Device setAppVersion(String appVersion) {
        this.appVersion = appVersion;
        return this;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public Device setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
        return this;
    }

    public String getCpu() {
        return this.cpu;
    }

    public Device setCpu(String cpu) {
        this.cpu = cpu;
        return this;
    }

    public String getOpenGL() {
        return this.openGL;
    }

    public Device setOpenGL(String openGL) {
        this.openGL = openGL;
        return this;
    }

    public Float getBatteryLevel() {
        return this.batteryLevel;
    }

    public Device setBatteryLevel(Float batteryLevel) {
        this.batteryLevel = batteryLevel;
        return this;
    }

    public String getOrientation() {
        return this.orientation;
    }

    public Device setOrientation(String orientation) {
        this.orientation = orientation;
        return this;
    }

    public Boolean isOnline() {
        return this.online;
    }

    public Device setOnline(Boolean online) {
        this.online = online;
        return this;
    }

    public Boolean isMuted() {
        return this.muted;
    }

    public Device setMuted(Boolean muted) {
        this.muted = muted;
        return this;
    }

    public Device setMetricOverride(Map<String, String> givenMetricOverride) {
        this.metricOverride.putAll(givenMetricOverride);
        return this;
    }

    public static interface TimeGenerator {
        public long timestamp();
    }
}

