/*
 * Decompiled with CFR 0.152.
 */
package ly.count.sdk.java.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import ly.count.sdk.java.Event;
import ly.count.sdk.java.internal.Device;
import ly.count.sdk.java.internal.JSONable;
import ly.count.sdk.java.internal.Log;
import ly.count.sdk.java.internal.SDKCore;
import org.json.JSONException;
import org.json.JSONObject;

class EventImpl
implements Event,
JSONable {
    private final EventRecorder recorder;
    private final String key;
    private Map<String, String> segmentation;
    private int count;
    private Double sum;
    private Double duration;
    private long timestamp;
    private int hour;
    private int dow;
    Log L;
    private boolean invalid = false;
    private static final String SEGMENTATION_KEY = "segmentation";
    private static final String KEY_KEY = "key";
    private static final String COUNT_KEY = "count";
    private static final String SUM_KEY = "sum";
    private static final String DUR_KEY = "dur";
    private static final String TIMESTAMP_KEY = "timestamp";
    private static final String DAY_OF_WEEK = "dow";
    private static final String HOUR = "hour";

    EventImpl(EventRecorder recorder, String key, Log givenL) {
        this.L = givenL;
        if (recorder == null) {
            this.invalid = true;
            this.L.w("[EventImpl] recorder cannot be null for an event");
        }
        if (key == null || "".equals(key)) {
            this.invalid = true;
            this.L.w("[EventImpl] Event key cannot be null or empty");
        }
        this.recorder = recorder;
        this.key = key;
        this.count = 1;
        this.timestamp = Device.dev.uniqueTimestamp();
        this.hour = Device.dev.currentHour();
        this.dow = Device.dev.currentDayOfWeek();
    }

    @Override
    public void record() {
        if (SDKCore.instance != null && SDKCore.instance.config.isBackendModeEnabled()) {
            this.L.e("[EventImpl] record: Skipping event, backend mode is enabled!");
            return;
        }
        if (this.recorder != null && !this.invalid) {
            this.invalid = true;
            this.recorder.recordEvent(this);
            this.L.d("[EventImpl] record: " + this.toString());
        }
    }

    @Override
    public void endAndRecord() {
        if (SDKCore.instance != null && SDKCore.instance.config.isBackendModeEnabled()) {
            this.L.e("[EventImpl] endAndRecord: Skipping event, backend mode is enabled!");
            return;
        }
        this.setDuration((Device.dev.uniqueTimestamp() - this.timestamp) / 1000L);
        this.record();
    }

    @Override
    public Event addSegment(String key, String value) {
        this.L.d("[EventImpl] addSegment: key = " + key + " value = " + value);
        if (key == null || "".equals(key)) {
            this.invalid = true;
            this.L.e("[EventImpl] Segmentation key " + key + " for event " + this.key + " is empty");
            return this;
        }
        if (value == null || "".equals(value)) {
            this.invalid = true;
            this.L.e("[EventImpl] Segmentation value " + value + " (" + key + ") for event " + this.key + " is empty");
            return this;
        }
        if (this.segmentation == null) {
            this.segmentation = new HashMap<String, String>();
        }
        this.segmentation.put(key, value);
        return this;
    }

    @Override
    public Event addSegments(String ... segmentation) {
        this.L.d("[EventImpl] addSegment: segmentation = " + segmentation);
        if (segmentation == null || segmentation.length == 0) {
            this.invalid = true;
            this.L.e("[EventImpl] Segmentation varargs array is empty");
            return this;
        }
        if (segmentation.length % 2 != 0) {
            this.invalid = true;
            this.L.e("[EventImpl] Segmentation varargs array length is not even");
            return this;
        }
        for (int i = 0; i < segmentation.length; i += 2) {
            this.addSegment(segmentation[i], segmentation[i + 1]);
        }
        return this;
    }

    @Override
    public Event setSegmentation(Map<String, String> segmentation) {
        this.L.d("[EventImpl] setSegmentation: segmentation = " + segmentation);
        if (segmentation == null) {
            this.invalid = true;
            this.L.e("[EventImpl] Segmentation map is null");
            return this;
        }
        this.segmentation = new HashMap<String, String>();
        for (String k : segmentation.keySet()) {
            this.addSegment(k, segmentation.get(k));
        }
        return this;
    }

    @Override
    public Event setCount(int count) {
        this.L.d("[EventImpl] setCount: count = " + count);
        if (count <= 0) {
            this.invalid = true;
            this.L.e("[EventImpl] Event " + this.key + " count cannot be 0 or less");
            return this;
        }
        this.count = count;
        return this;
    }

    @Override
    public Event setSum(double sum) {
        this.L.d("[EventImpl] setSum: sum = " + sum);
        if (Double.isInfinite(sum) || Double.isNaN(sum)) {
            this.invalid = true;
            this.L.e("[EventImpl] NaN infinite value cannot be event '" + this.key + "' sum");
        } else {
            this.sum = sum;
        }
        return this;
    }

    @Override
    public Event setDuration(double duration) {
        this.L.d("[EventImpl] setDuration: duration = " + duration);
        if (Double.isInfinite(duration) || Double.isNaN(duration) || duration < 0.0) {
            this.invalid = true;
            this.L.e("[EventImpl] NaN, infinite or negative value cannot be event '" + this.key + "' duration");
        } else {
            this.duration = duration;
        }
        return this;
    }

    public int hashCode() {
        return (this.key + this.timestamp).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof EventImpl)) {
            return false;
        }
        EventImpl event = (EventImpl)obj;
        if (this.timestamp != event.timestamp) {
            return false;
        }
        if (this.key == null || event.key == null || !this.key.equals(event.key)) {
            return false;
        }
        if (this.count != event.count) {
            return false;
        }
        if (this.sum != null && !this.sum.equals(event.sum) || event.sum != null && !event.sum.equals(this.sum)) {
            return false;
        }
        if (this.duration != null && !this.duration.equals(event.duration) || event.duration != null && !event.duration.equals(this.duration)) {
            return false;
        }
        return (this.segmentation == null || this.segmentation.equals(event.segmentation)) && (event.segmentation == null || event.segmentation.equals(this.segmentation));
    }

    @Override
    public String toJSON(Log log) {
        JSONObject json = new JSONObject();
        try {
            json.put(KEY_KEY, (Object)this.key);
            json.put(COUNT_KEY, this.count);
            json.put(TIMESTAMP_KEY, this.timestamp);
            json.put(HOUR, this.hour);
            json.put(DAY_OF_WEEK, this.dow);
            if (this.segmentation != null) {
                json.put(SEGMENTATION_KEY, (Object)new JSONObject(this.segmentation));
            }
            if (this.sum != null) {
                json.put(SUM_KEY, (Object)this.sum);
            }
            if (this.duration != null) {
                json.put(DUR_KEY, (Object)this.duration);
            }
        }
        catch (JSONException e) {
            log.e("[EventImpl] Cannot serialize event to JSON " + (Object)((Object)e));
        }
        return json.toString();
    }

    static EventImpl fromJSON(String jsonString, EventRecorder recorder, final Log L) {
        try {
            JSONObject json = new JSONObject(jsonString);
            if (!json.has(KEY_KEY) || json.isNull(KEY_KEY)) {
                L.e("[EventImpl][fromJSON] Bad JSON for deserialization of event: " + jsonString);
                return null;
            }
            EventImpl event = new EventImpl(recorder == null ? new EventRecorder(){

                @Override
                public void recordEvent(Event event) {
                    L.e("[EventImpl] Shouldn't record serialized events");
                }
            } : recorder, json.getString(KEY_KEY), L);
            event.count = json.optInt(COUNT_KEY, 1);
            if (json.has(SUM_KEY) && !json.isNull(SUM_KEY)) {
                event.sum = json.optDouble(SUM_KEY, 0.0);
            }
            if (json.has(DUR_KEY) && !json.isNull(DUR_KEY)) {
                event.duration = json.optDouble(DUR_KEY, 0.0);
            }
            event.timestamp = json.optLong(TIMESTAMP_KEY);
            event.hour = json.optInt(HOUR);
            event.dow = json.optInt(DAY_OF_WEEK);
            if (!json.isNull(SEGMENTATION_KEY)) {
                JSONObject segm = json.getJSONObject(SEGMENTATION_KEY);
                HashMap<String, String> segmentation = new HashMap<String, String>(segm.length());
                Iterator nameItr = segm.keys();
                while (nameItr.hasNext()) {
                    String key = (String)nameItr.next();
                    if (segm.isNull(key)) continue;
                    segmentation.put(key, segm.getString(key));
                }
                event.segmentation = segmentation;
            }
            return event;
        }
        catch (JSONException e) {
            L.e("[EventImpl] Cannot deserialize event from JSON " + (Object)((Object)e));
            return null;
        }
    }

    long getTimestamp() {
        return this.timestamp;
    }

    public String getKey() {
        return this.key;
    }

    public int getCount() {
        return this.count;
    }

    public Double getSum() {
        return this.sum;
    }

    public Double getDuration() {
        return this.duration;
    }

    public String getSegment(String key) {
        return this.segmentation.get(key);
    }

    @Override
    public boolean isInvalid() {
        return this.invalid;
    }

    public String toString() {
        return this.toJSON(this.L);
    }

    public static interface EventRecorder {
        public void recordEvent(Event var1);
    }
}

