/*
 * Decompiled with CFR 0.152.
 */
package ly.count.sdk.java.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ly.count.sdk.java.Config;
import ly.count.sdk.java.internal.Log;
import ly.count.sdk.java.internal.Storable;
import ly.count.sdk.java.internal.Utils;

public final class InternalConfig
extends Config
implements Storable {
    private boolean limited = false;
    private boolean defaultNetworking = true;
    private List<Config.DID> dids = new ArrayList<Config.DID>();

    public InternalConfig(String url, String appKey) throws IllegalArgumentException {
        super(url, appKey);
        throw new IllegalStateException("InternalConfig(url, appKey) should not be used");
    }

    public InternalConfig() throws IllegalArgumentException {
        super("http://count.ly", "not a key");
    }

    public InternalConfig(Config config) throws IllegalArgumentException {
        super(config.getServerURL().toString(), config.getServerAppKey());
        this.setFrom(config);
    }

    public void setFrom(Config config) {
        List<Field> priva = Utils.reflectiveGetDeclaredFields(this.getClass(), false);
        List<Field> local = Utils.reflectiveGetDeclaredFields(this.getClass(), true);
        List<Field> remot = Utils.reflectiveGetDeclaredFields(config.getClass(), true);
        for (Field r : remot) {
            if (priva.contains(r)) continue;
            for (Field l : local) {
                if (!r.getName().equals(l.getName())) continue;
                try {
                    r.setAccessible(true);
                    if (l.isAccessible()) {
                        l.set(this, r.get(config));
                        continue;
                    }
                    l.setAccessible(true);
                    l.set(this, r.get(config));
                    l.setAccessible(false);
                }
                catch (IllegalAccessException | IllegalArgumentException iae) {
                    if (this.configLog == null) continue;
                    this.configLog.e("[InternalConfig] Cannot access field " + r.getName() + " " + iae);
                }
            }
        }
    }

    protected String getSDKNameInternal() {
        return this.sdkName;
    }

    public InternalConfig setLimited(boolean limited) {
        this.limited = limited;
        return this;
    }

    public boolean isLimited() {
        return this.limited;
    }

    @Override
    public Long storageId() {
        return 0L;
    }

    @Override
    public String storagePrefix() {
        return InternalConfig.getStoragePrefix();
    }

    public static String getStoragePrefix() {
        return "config";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] store(Log L) {
        ByteArrayOutputStream bytes = null;
        ObjectOutputStream stream = null;
        try {
            bytes = new ByteArrayOutputStream();
            stream = new ObjectOutputStream(bytes);
            stream.writeUTF(this.serverURL.toString());
            stream.writeUTF(this.serverAppKey);
            stream.writeInt(this.features);
            stream.writeUTF("Countly");
            stream.writeInt(this.loggingLevel.getLevel());
            stream.writeUTF(this.sdkName);
            stream.writeUTF(this.sdkVersion);
            stream.writeObject("name");
            stream.writeObject(this.applicationVersion);
            stream.writeBoolean(this.usePOST);
            stream.writeObject(this.salt);
            stream.writeInt(this.networkConnectionTimeout);
            stream.writeInt(this.networkReadTimeout);
            stream.writeInt(this.publicKeyPins == null ? 0 : this.publicKeyPins.size());
            if (this.publicKeyPins != null) {
                for (String key : this.publicKeyPins) {
                    stream.writeUTF(key);
                }
            }
            stream.writeInt(this.certificatePins == null ? 0 : this.certificatePins.size());
            if (this.certificatePins != null) {
                for (String key : this.certificatePins) {
                    stream.writeUTF(key);
                }
            }
            stream.writeInt(this.sendUpdateEachSeconds);
            stream.writeInt(this.eventsBufferSize);
            stream.writeInt(0);
            stream.writeBoolean(false);
            stream.writeInt(5);
            stream.writeObject(this.crashProcessorClass);
            stream.writeInt(this.moduleOverrides == null ? 0 : this.moduleOverrides.size());
            if (this.moduleOverrides != null && this.moduleOverrides.size() > 0) {
                for (Integer feature : this.moduleOverrides.keySet()) {
                    stream.writeInt(feature);
                    stream.writeUTF(((Class)this.moduleOverrides.get(feature)).getName());
                }
            }
            stream.writeInt(this.dids.size());
            for (Config.DID did : this.dids) {
                byte[] b = did.store(L);
                if (b == null) continue;
                stream.writeInt(b.length);
                stream.write(b);
            }
            stream.close();
            Object object = bytes.toByteArray();
            return object;
        }
        catch (IOException e) {
            if (L != null) {
                L.e("[InternalCore][Store] Cannot serialize config " + e);
            }
        }
        finally {
            block29: {
                block28: {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException e) {
                            if (L == null) break block28;
                            L.e("[InternalCore][Store] Cannot happen " + e);
                        }
                    }
                }
                if (bytes != null) {
                    try {
                        bytes.close();
                    }
                    catch (IOException e) {
                        if (L == null) break block29;
                        L.e("[InternalCore][Store] Cannot happen " + e);
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean restore(byte[] data, Log L) {
        ByteArrayInputStream bytes = null;
        ObjectInputStream stream = null;
        try {
            int i;
            block30: {
                bytes = new ByteArrayInputStream(data);
                stream = new ObjectInputStream(bytes);
                try {
                    Utils.reflectiveSetField(this, "serverURL", (Object)new URL(stream.readUTF()), L);
                    Utils.reflectiveSetField(this, "serverAppKey", (Object)stream.readUTF(), L);
                }
                catch (Exception e) {
                    if (L == null) break block30;
                    L.e("[InternalCore][Restore] Cannot happen " + e);
                }
            }
            this.features = stream.readInt();
            String throwawayCountlyLoggingTag = stream.readUTF();
            int l = stream.readInt();
            for (Config.LoggingLevel level : Config.LoggingLevel.values()) {
                if (level.getLevel() != l) continue;
                this.loggingLevel = level;
                break;
            }
            this.sdkName = stream.readUTF();
            this.sdkVersion = stream.readUTF();
            String throwawayApplicationName = (String)stream.readObject();
            this.applicationVersion = (String)stream.readObject();
            this.usePOST = stream.readBoolean();
            this.salt = (String)stream.readObject();
            this.networkConnectionTimeout = stream.readInt();
            this.networkReadTimeout = stream.readInt();
            l = stream.readInt();
            this.publicKeyPins = l == 0 ? null : new HashSet();
            for (i = 0; i < l; ++i) {
                this.publicKeyPins.add(stream.readUTF());
            }
            l = stream.readInt();
            this.certificatePins = l == 0 ? null : new HashSet();
            for (i = 0; i < l; ++i) {
                this.certificatePins.add(stream.readUTF());
            }
            this.sendUpdateEachSeconds = stream.readInt();
            this.eventsBufferSize = stream.readInt();
            int throwawaySessionCooldownPeriod = stream.readInt();
            boolean throwawayCountlyTestMode = stream.readBoolean();
            int throwawayCrashReportingANRCheckingPeriod = stream.readInt();
            this.crashProcessorClass = (String)stream.readObject();
            l = stream.readInt();
            if (l > 0) {
                this.moduleOverrides = new HashMap();
                while (l-- > 0) {
                    int f = stream.readInt();
                    String cls = stream.readUTF();
                    try {
                        this.moduleOverrides.put(f, Class.forName(cls));
                    }
                    catch (Throwable t) {
                        if (L == null) continue;
                        L.e("[InternalCore][Restore] Cannot get class " + cls + " for feature override " + f);
                    }
                }
            }
            this.dids.clear();
            l = stream.readInt();
            while (l-- > 0) {
                Config.DID did = new Config.DID(0, 0, null);
                byte[] b = new byte[stream.readInt()];
                stream.readFully(b);
                did.restore(b, this.configLog);
                this.dids.add(did);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException | ClassNotFoundException e) {
            if (L != null) {
                L.e("[InternalCore][Restore] Cannot deserialize config " + e);
            }
        }
        finally {
            block33: {
                block32: {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException e) {
                            if (L == null) break block32;
                            L.e("[InternalCore][Restore] Cannot happen " + e);
                        }
                    }
                }
                if (bytes != null) {
                    try {
                        bytes.close();
                    }
                    catch (IOException e) {
                        if (L == null) break block33;
                        L.e("[InternalCore][Restore] Cannot happen " + e);
                    }
                }
            }
        }
        return false;
    }

    public Config.DID getDeviceId() {
        return this.getDeviceId(0);
    }

    public Config.DID getDeviceId(int realm) {
        for (Config.DID DID2 : this.dids) {
            if (DID2.realm != realm) continue;
            return DID2;
        }
        return null;
    }

    public Config.DID setDeviceId(Config.DID id) {
        if (id == null && this.configLog != null) {
            this.configLog.e("DID cannot be null");
        }
        Config.DID old = null;
        for (Config.DID did : this.dids) {
            if (did.realm != id.realm) continue;
            old = did;
        }
        if (old != null) {
            this.dids.remove(old);
        }
        this.dids.add(id);
        return old;
    }

    public boolean removeDeviceId(Config.DID did) {
        return this.dids.remove(did);
    }

    public int getFeatures1() {
        return this.features;
    }

    public Set<Integer> getModuleOverrides() {
        return this.moduleOverrides == null ? new HashSet() : this.moduleOverrides.keySet();
    }

    public boolean isDefaultNetworking() {
        return this.defaultNetworking;
    }

    public void setDefaultNetworking(boolean defaultNetworking) {
        this.defaultNetworking = defaultNetworking;
    }

    public long getRatingWidgetTimeout() {
        return this.ratingWidgetTimeout;
    }

    public Integer getStarRatingSessionLimit() {
        return this.starRatingSessionLimit;
    }

    public String getStarRatingTextTitle() {
        return this.starRatingTextTitle;
    }

    public String getStarRatingTextMessage() {
        return this.starRatingTextMessage;
    }

    public String getStarRatingTextDismiss() {
        return this.starRatingTextDismiss;
    }

    public Boolean getAutomaticStarRatingShouldBeShown() {
        return this.automaticStarRatingShouldBeShown;
    }

    public Boolean getStarRatingDialogIsCancelable() {
        return this.starRatingIsDialogCancelable;
    }

    public Boolean getStarRatingDisabledForNewVersion() {
        return this.starRatingDisabledAutomaticForNewVersions;
    }

    public Boolean getRemoteConfigAutomaticUpdateEnabled() {
        return this.enableAutomaticRemoteConfig;
    }

    public Long getRemoteConfigUpdateTimeoutLength() {
        return this.remoteConfigUpdateRequestTimeout;
    }

    public Map<String, String> getMetricOverride() {
        return this.metricOverride;
    }
}

