/*
 * Decompiled with CFR 0.152.
 */
package ly.count.sdk.java.internal;

import ly.count.sdk.java.Config;
import ly.count.sdk.java.internal.LogCallback;

public class Log {
    private final LogCallback logListener;
    private final Config.LoggingLevel loggingLevel;

    public Log(Config.LoggingLevel loggingLevel, LogCallback logListener) {
        if (loggingLevel == null) {
            throw new NullPointerException("Logging level can't null.");
        }
        this.loggingLevel = loggingLevel;
        this.logListener = logListener;
    }

    public void d(String logMessage) {
        this.print("[DEBUG] [Countly]\t" + logMessage, Config.LoggingLevel.DEBUG);
        this.informListener(logMessage, Config.LoggingLevel.DEBUG);
    }

    public void i(String logMessage) {
        this.print("[INFO] [Countly]\t" + logMessage, Config.LoggingLevel.INFO);
        this.informListener(logMessage, Config.LoggingLevel.INFO);
    }

    public void w(String logMessage) {
        this.print("[WARN] [Countly]\t" + logMessage, Config.LoggingLevel.WARN);
        this.informListener(logMessage, Config.LoggingLevel.WARN);
    }

    public void e(String logMessage) {
        this.print("[ERROR] [Countly]\t" + logMessage, Config.LoggingLevel.ERROR);
        this.informListener(logMessage, Config.LoggingLevel.ERROR);
    }

    public void v(String logMessage) {
        this.print("[VERBOSE] [Countly]\t" + logMessage, Config.LoggingLevel.VERBOSE);
        this.informListener(logMessage, Config.LoggingLevel.VERBOSE);
    }

    private void print(String msg, Config.LoggingLevel level) {
        if (level != null && this.loggingLevel.prints(level)) {
            System.out.println(msg);
        }
    }

    private void informListener(String msg, Config.LoggingLevel level) {
        if (this.logListener != null) {
            this.logListener.LogHappened(msg, level);
        }
    }
}

