/*
 * Decompiled with CFR 0.152.
 */
package ly.count.sdk.java.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import ly.count.sdk.java.internal.CoreFeature;
import ly.count.sdk.java.internal.CtxCore;
import ly.count.sdk.java.internal.Device;
import ly.count.sdk.java.internal.InternalConfig;
import ly.count.sdk.java.internal.Log;
import ly.count.sdk.java.internal.ModuleBase;
import ly.count.sdk.java.internal.Request;
import ly.count.sdk.java.internal.SDKCore;
import org.json.JSONArray;
import org.json.JSONObject;

public class ModuleBackendMode
extends ModuleBase {
    protected InternalConfig internalConfig = null;
    protected CtxCore ctx = null;
    protected boolean disabledModule = false;
    protected int eventQSize = 0;
    protected final Map<String, JSONArray> eventQueues = new HashMap<String, JSONArray>();
    private ScheduledExecutorService executor = null;
    String[] userPredefinedKeys = new String[]{"name", "username", "email", "organization", "phone", "gender", "byear"};

    @Override
    public void init(InternalConfig config, Log logger) {
        super.init(config, logger);
        this.internalConfig = config;
        this.L.d("[BackendMode] init: config = " + config);
    }

    @Override
    public void onContextAcquired(CtxCore ctx) {
        this.ctx = ctx;
        this.L.d("[BackendMode] onContextAcquired: " + ctx.toString());
        if (ctx.getConfig().isBackendModeEnabled() && ctx.getConfig().getSendUpdateEachSeconds() > 0 && this.executor == null) {
            this.executor = Executors.newScheduledThreadPool(1);
            this.executor.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    ModuleBackendMode.this.addEventsToRequestQ();
                }
            }, ctx.getConfig().getSendUpdateEachSeconds(), ctx.getConfig().getSendUpdateEachSeconds(), TimeUnit.SECONDS);
        }
    }

    @Override
    public Integer getFeature() {
        return CoreFeature.BackendMode.getIndex();
    }

    @Override
    public Boolean onRequest(Request request) {
        return true;
    }

    @Override
    public void onRequestCompleted(Request request, String response, int responseCode) {
    }

    @Override
    public void stop(CtxCore ctx, boolean clear) {
        super.stop(ctx, clear);
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    public void disableModule() {
        this.disabledModule = true;
    }

    private void recordEventInternal(String deviceID, String key, int count, Double sum, Double dur, Map<String, Object> segmentation, Long timestamp) {
        this.L.d(String.format("recordEventInternal: deviceID = %s, key = %s,, count = %d, sum = %f, dur = %f, segmentation = %s, timestamp = %d", deviceID, key, count, sum, dur, segmentation, timestamp));
        if (timestamp == null || timestamp < 1L) {
            timestamp = Device.dev.uniqueTimestamp();
        }
        this.removeInvalidDataFromSegments(segmentation);
        JSONObject jsonObject = this.buildEventJSONObject(key, count, sum, dur, segmentation, timestamp);
        if (!this.eventQueues.containsKey(deviceID)) {
            this.eventQueues.put(deviceID, new JSONArray());
        }
        this.eventQueues.get(deviceID).put((Object)jsonObject);
        ++this.eventQSize;
        if (this.eventQSize >= this.internalConfig.getEventsBufferSize()) {
            this.addEventsToRequestQ();
        }
    }

    private void sessionBeginInternal(String deviceID, Map<String, String> metrics, Map<String, String> location, Long timestamp) {
        this.L.d(String.format("sessionBeginInternal: deviceID = %s, timestamp = %d", deviceID, timestamp));
        if (timestamp == null || timestamp < 1L) {
            timestamp = Device.dev.uniqueTimestamp();
        }
        Request request = new Request(new Object[0]);
        request.params.add("device_id", (Object)deviceID);
        request.params.add("begin_session", (Object)1);
        JSONObject metricsJson = new JSONObject(metrics);
        request.params.add("metrics", (Object)metricsJson);
        if (location != null) {
            for (Map.Entry<String, String> entry : location.entrySet()) {
                request.params.add(entry.getKey(), (Object)entry.getValue());
            }
        }
        this.addTimeInfoIntoRequest(request, timestamp);
        this.addRequestToRequestQ(request);
    }

    private void sessionUpdateInternal(String deviceID, Double duration, Long timestamp) {
        this.L.d(String.format("sessionUpdateInternal: deviceID = %s, duration = %f, timestamp = %d", deviceID, duration, timestamp));
        if (timestamp == null || timestamp < 1L) {
            timestamp = Device.dev.uniqueTimestamp();
        }
        Request request = new Request(new Object[0]);
        request.params.add("device_id", (Object)deviceID);
        request.params.add("session_duration", (Object)duration);
        this.addTimeInfoIntoRequest(request, timestamp);
        this.addRequestToRequestQ(request);
    }

    private void sessionEndInternal(String deviceID, double duration, Long timestamp) {
        this.L.d(String.format("sessionEndInternal: deviceID = %s, duration = %f, timestamp = %d", deviceID, duration, timestamp));
        if (timestamp == null || timestamp < 1L) {
            timestamp = Device.dev.uniqueTimestamp();
        }
        this.addEventsAgainstDeviceIdToRequestQ(deviceID);
        this.eventQueues.remove(deviceID);
        Request request = new Request(new Object[0]);
        request.params.add("device_id", (Object)deviceID);
        request.params.add("end_session", (Object)1);
        request.params.add("session_duration", (Object)duration);
        this.addTimeInfoIntoRequest(request, timestamp);
        this.addRequestToRequestQ(request);
    }

    public void recordExceptionInternal(String deviceID, String message, String stacktrace, Map<String, Object> segmentation, Map<String, String> crashDetails, Long timestamp) {
        this.L.d(String.format("recordExceptionInternal: deviceID = %s, message = %s, stacktrace = %s, segmentation = %s, timestamp = %d", deviceID, message, stacktrace, segmentation, timestamp));
        if (timestamp == null || timestamp < 1L) {
            timestamp = Device.dev.uniqueTimestamp();
        }
        this.removeInvalidDataFromSegments(segmentation);
        JSONObject crash = new JSONObject();
        crash.put("_error", (Object)stacktrace);
        crash.put("_custom", segmentation);
        crash.put("_name", (Object)message);
        if (crashDetails != null && !crashDetails.isEmpty()) {
            this.removeInvalidDataFromSegments(segmentation);
            for (Map.Entry<String, String> entry : crashDetails.entrySet()) {
                crash.put(entry.getKey(), (Object)entry.getValue());
            }
        }
        Request request = new Request(new Object[0]);
        request.params.add("device_id", (Object)deviceID);
        request.params.add("crash", (Object)crash);
        this.addTimeInfoIntoRequest(request, timestamp);
        this.addRequestToRequestQ(request);
    }

    private void recordUserPropertiesInternal(String deviceID, Map<String, Object> userProperties, Long timestamp) {
        this.L.d(String.format("recordUserPropertiesInternal: deviceID = %s, userProperties = %s, timestamp = %d", deviceID, userProperties, timestamp));
        if (timestamp == null || timestamp < 1L) {
            timestamp = Device.dev.uniqueTimestamp();
        }
        this.removeInvalidDataFromSegments(userProperties);
        HashMap<String, Object> userDetail = new HashMap<String, Object>();
        HashMap<String, Object> customDetail = new HashMap<String, Object>();
        for (Map.Entry<String, Object> item : userProperties.entrySet()) {
            String value;
            if (Arrays.stream(this.userPredefinedKeys).anyMatch(item.getKey()::equalsIgnoreCase)) {
                userDetail.put(item.getKey(), item.getValue());
                continue;
            }
            Object v = item.getValue();
            if (v instanceof String && !(value = (String)v).isEmpty() && value.charAt(0) == '{') {
                try {
                    v = new JSONObject(value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            customDetail.put(item.getKey(), v);
        }
        userDetail.put("custom", customDetail);
        Request request = new Request(new Object[0]);
        JSONObject properties = new JSONObject(userDetail);
        request.params.add("device_id", (Object)deviceID);
        request.params.add("user_details", (Object)properties);
        this.addTimeInfoIntoRequest(request, timestamp);
        this.addRequestToRequestQ(request);
    }

    void recordDirectRequestInternal(String deviceID, Map<String, String> requestData, Long timestamp) {
        this.L.d(String.format("recordDirectRequestInternal: deviceID = %s, requestJson = %s, timestamp = %d", deviceID, requestData, timestamp));
        if (timestamp == null || timestamp < 1L) {
            timestamp = Device.dev.uniqueTimestamp();
        }
        Request request = new Request(new Object[0]);
        request.params.add("device_id", (Object)deviceID);
        this.addTimeInfoIntoRequest(request, timestamp);
        requestData.remove("checksum");
        requestData.remove("checksum256");
        requestData.remove("sdk_name");
        requestData.remove("sdk_version");
        for (Map.Entry<String, String> item : requestData.entrySet()) {
            request.params.add(item.getKey(), (Object)item.getValue());
        }
        this.addRequestToRequestQ(request);
    }

    private JSONObject buildEventJSONObject(String key, int count, Double sum, Double dur, Map<String, Object> segmentation, Long timestamp) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timestamp);
        int hour = calendar.get(11);
        int dow = calendar.get(7) - 1;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("key", (Object)key);
        jsonObject.put("sum", (Object)sum);
        if (count > 0) {
            jsonObject.put("count", count);
        }
        if (dur != null) {
            jsonObject.put("dur", (Object)dur);
        }
        jsonObject.put("segmentation", segmentation);
        jsonObject.put("dow", dow);
        jsonObject.put("hour", hour);
        jsonObject.put("timestamp", (Object)timestamp);
        this.L.d(String.format("buildEventJSONObject: jsonObject = %s", jsonObject));
        return jsonObject;
    }

    private void addTimeInfoIntoRequest(Request request, Long timestamp) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timestamp);
        int hour = calendar.get(11);
        int dow = calendar.get(7) - 1;
        request.params.add("dow", (Object)dow);
        request.params.add("hour", (Object)hour);
        request.params.add("timestamp", (Object)timestamp);
        request.params.add("tz", (Object)Device.dev.getTimezoneOffset());
    }

    private synchronized void addEventsAgainstDeviceIdToRequestQ(String deviceID) {
        JSONArray events = this.eventQueues.get(deviceID);
        if (events == null || events.isEmpty()) {
            return;
        }
        this.eventQSize -= events.length();
        Request request = new Request(new Object[0]);
        request.params.add("device_id", (Object)deviceID);
        request.params.add("events", (Object)events);
        this.addTimeInfoIntoRequest(request, System.currentTimeMillis());
        request.own(ModuleBackendMode.class);
        this.addRequestToRequestQ(request);
    }

    private synchronized void addEventsToRequestQ() {
        this.L.d("[BackendMode] addEventsToRequestQ");
        for (String s : this.eventQueues.keySet()) {
            this.addEventsAgainstDeviceIdToRequestQ(s);
        }
        this.eventQSize = 0;
        this.eventQueues.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRequestToRequestQ(Request request) {
        Object object = SDKCore.instance.lockBRQStorage;
        synchronized (object) {
            this.L.d("[BackendMode] addRequestToRequestQ");
            if (this.internalConfig.getRequestQueueMaxSize() == SDKCore.instance.requestQueueMemory.size()) {
                this.L.d("[BackendMode] addRequestToRequestQ: In Memory request queue is full, dropping oldest request: " + request.params.toString());
                SDKCore.instance.requestQueueMemory.remove();
            }
            SDKCore.instance.requestQueueMemory.add(request);
            SDKCore.instance.networking.check(this.ctx);
        }
    }

    protected Map<String, Object> removeInvalidDataFromSegments(Map<String, Object> segments) {
        if (segments == null || segments.isEmpty()) {
            return segments;
        }
        boolean i = false;
        ArrayList<String> toRemove = new ArrayList<String>();
        for (Map.Entry<String, Object> item : segments.entrySet()) {
            Object type = item.getValue();
            boolean isValidDataType = type instanceof Boolean || type instanceof Integer || type instanceof Long || type instanceof String || type instanceof Double || type instanceof Float;
            if (isValidDataType) continue;
            toRemove.add(item.getKey());
            this.L.w("[BackendMode] RemoveSegmentInvalidDataTypes: In segmentation Data type '" + type + "' of item '" + item.getValue() + "' isn't valid.");
        }
        for (String k : toRemove) {
            segments.remove(k);
        }
        return segments;
    }

    public class BackendMode {
        public void recordView(String deviceID, String name, Map<String, Object> segmentation, Long timestamp) {
            ModuleBackendMode.this.L.i(String.format(":recordView: deviceID = %s, key = %s, segmentation = %s, timestamp = %d", deviceID, name, segmentation, timestamp));
            if (ModuleBackendMode.this.disabledModule) {
                return;
            }
            if (deviceID == null || deviceID.isEmpty()) {
                ModuleBackendMode.this.L.e("[BackendMode] recordView: DeviceID can not be null or empty.");
                return;
            }
            if (name == null || name.isEmpty()) {
                ModuleBackendMode.this.L.e("[BackendMode] recordView: Name can not be null or empty.");
                return;
            }
            if (segmentation == null) {
                segmentation = new HashMap<String, Object>();
            }
            segmentation.put("name", name);
            ModuleBackendMode.this.recordEventInternal(deviceID, "[CLY]_view", 1, null, null, segmentation, timestamp);
        }

        public void recordEvent(String deviceID, String key, int count, Double sum, Double dur, Map<String, Object> segmentation, Long timestamp) {
            ModuleBackendMode.this.L.i(String.format("recordEvent: deviceID = %s, key = %s, count = %d, sum = %f, dur = %f, segmentation = %s, timestamp = %d", deviceID, key, count, sum, dur, segmentation, timestamp));
            if (ModuleBackendMode.this.disabledModule) {
                return;
            }
            if (deviceID == null || deviceID.isEmpty()) {
                ModuleBackendMode.this.L.e("[BackendMode] recordEvent: DeviceID can not be null or empty.");
                return;
            }
            if (key == null || key.isEmpty()) {
                ModuleBackendMode.this.L.e("[BackendMode] recordEvent: Event key can not be null or empty.");
                return;
            }
            if (count < 1) {
                count = 1;
            }
            ModuleBackendMode.this.recordEventInternal(deviceID, key, count, sum, dur, segmentation, timestamp);
        }

        public void sessionBegin(String deviceID, Map<String, String> metrics, Map<String, String> location, Long timestamp) {
            ModuleBackendMode.this.L.i(String.format("sessionBegin: deviceID = %s, timestamp = %d", deviceID, timestamp));
            if (ModuleBackendMode.this.disabledModule) {
                return;
            }
            if (deviceID == null || deviceID.isEmpty()) {
                ModuleBackendMode.this.L.e("[BackendMode] sessionBegin: DeviceID can not be null or empty.");
                return;
            }
            ModuleBackendMode.this.sessionBeginInternal(deviceID, metrics, location, timestamp);
        }

        public void sessionUpdate(String deviceID, double duration, Long timestamp) {
            ModuleBackendMode.this.L.i(String.format("sessionUpdate: deviceID = %s, duration = %f, timestamp = %d", deviceID, duration, timestamp));
            if (ModuleBackendMode.this.disabledModule) {
                return;
            }
            if (deviceID == null || deviceID.isEmpty()) {
                ModuleBackendMode.this.L.e("[BackendMode] sessionUpdate: DeviceID can not be null or empty.");
                return;
            }
            if (duration < 0.0) {
                duration = 0.0;
            }
            ModuleBackendMode.this.sessionUpdateInternal(deviceID, duration, timestamp);
        }

        public void sessionEnd(String deviceID, double duration, Long timestamp) {
            ModuleBackendMode.this.L.i(String.format("sessionEnd: deviceID = %s, duration = %f, timestamp = %d", deviceID, duration, timestamp));
            if (ModuleBackendMode.this.disabledModule) {
                return;
            }
            if (deviceID == null || deviceID.isEmpty()) {
                ModuleBackendMode.this.L.e("[BackendMode] sessionEnd: DeviceID can not be null or empty.");
                return;
            }
            if (duration < 0.0) {
                duration = 0.0;
            }
            ModuleBackendMode.this.sessionEndInternal(deviceID, duration, timestamp);
        }

        public void recordException(String deviceID, Throwable throwable, Map<String, Object> segmentation, Map<String, String> crashDetails, Long timestamp) {
            ModuleBackendMode.this.L.i(String.format("recordException: deviceID = %s, throwable = %s, segmentation = %s, timestamp = %d", deviceID, throwable, segmentation, timestamp));
            if (ModuleBackendMode.this.disabledModule) {
                return;
            }
            if (deviceID == null || deviceID.isEmpty()) {
                ModuleBackendMode.this.L.e("[BackendMode] recordException: DeviceID can not be null or empty.");
                return;
            }
            if (throwable == null) {
                ModuleBackendMode.this.L.e("[BackendMode] recordException: throwable can not be null.");
                return;
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            ModuleBackendMode.this.recordExceptionInternal(deviceID, throwable.getMessage(), sw.toString(), segmentation, crashDetails, timestamp);
        }

        public void recordException(String deviceID, String message, String stacktrace, Map<String, Object> segmentation, Map<String, String> crashDetails, Long timestamp) {
            ModuleBackendMode.this.L.i(String.format("recordException: deviceID = %s, message = %s, stacktrace = %s, segmentation = %s, timestamp = %d", deviceID, message, stacktrace, segmentation, timestamp));
            if (ModuleBackendMode.this.disabledModule) {
                return;
            }
            if (deviceID == null || deviceID.isEmpty()) {
                ModuleBackendMode.this.L.e("[BackendMode] recordException: DeviceID can not be null or empty.");
                return;
            }
            if (message == null || message.isEmpty()) {
                ModuleBackendMode.this.L.e("[BackendMode] recordException: message can not be null or empty.");
                return;
            }
            if (stacktrace == null || stacktrace.isEmpty()) {
                ModuleBackendMode.this.L.e("[BackendMode] recordException: stacktrace can not be null.");
                return;
            }
            ModuleBackendMode.this.recordExceptionInternal(deviceID, message, stacktrace, segmentation, crashDetails, timestamp);
        }

        public void recordUserProperties(String deviceID, Map<String, Object> userProperties, Long timestamp) {
            ModuleBackendMode.this.L.i(String.format("recordUserProperties: deviceID = %s, userProperties = %s, timestamp = %d", deviceID, userProperties, timestamp));
            if (ModuleBackendMode.this.disabledModule) {
                return;
            }
            if (deviceID == null || deviceID.isEmpty()) {
                ModuleBackendMode.this.L.e("[BackendMode] recordUserProperties: DeviceID can not be null or empty.");
                return;
            }
            if (userProperties == null || userProperties.isEmpty()) {
                ModuleBackendMode.this.L.e("[BackendMode] recordUserProperties: userProperties can not be null or empty.");
                return;
            }
            ModuleBackendMode.this.recordUserPropertiesInternal(deviceID, userProperties, timestamp);
        }

        public void recordDirectRequest(String deviceID, Map<String, String> requestData, Long timestamp) {
            ModuleBackendMode.this.L.i(String.format("recordDirectRequest: deviceID = %s, requestData = %s, timestamp = %d", deviceID, requestData, timestamp));
            if (ModuleBackendMode.this.disabledModule) {
                return;
            }
            if (deviceID == null || deviceID.isEmpty()) {
                ModuleBackendMode.this.L.e("[BackendMode] recordDirectRequest: DeviceID can not be null or empty.");
                return;
            }
            if (requestData == null || requestData.isEmpty()) {
                ModuleBackendMode.this.L.e("[BackendMode] recordDirectRequest: requestData can not be null or empty.");
                return;
            }
            ModuleBackendMode.this.recordDirectRequestInternal(deviceID, requestData, timestamp);
        }

        public int getQueueSize() {
            boolean queueSize = false;
            int eSize = ModuleBackendMode.this.eventQueues.size();
            int rSize = SDKCore.instance.requestQueueMemory.size();
            return rSize + eSize;
        }

        protected ModuleBase getModule() {
            return ModuleBackendMode.this;
        }
    }
}

