/*
 * Decompiled with CFR 0.152.
 */
package ly.count.sdk.java.internal;

import java.util.Map;
import ly.count.sdk.java.Crash;
import ly.count.sdk.java.CrashProcessor;
import ly.count.sdk.java.internal.CoreFeature;
import ly.count.sdk.java.internal.CrashImpl;
import ly.count.sdk.java.internal.CtxCore;
import ly.count.sdk.java.internal.Device;
import ly.count.sdk.java.internal.InternalConfig;
import ly.count.sdk.java.internal.Log;
import ly.count.sdk.java.internal.ModuleBase;
import ly.count.sdk.java.internal.Params;
import ly.count.sdk.java.internal.SDKCore;
import ly.count.sdk.java.internal.Storage;

public class ModuleCrash
extends ModuleBase {
    protected long started = 0L;
    private boolean limited = false;
    private boolean crashed = false;
    protected InternalConfig config;
    private Thread.UncaughtExceptionHandler previousHandler = null;
    protected CrashProcessor crashProcessor = null;

    @Override
    public void init(InternalConfig config, Log logger) {
        super.init(config, logger);
        this.config = config;
        this.limited = config.isLimited();
        if (config.getCrashProcessorClass() != null) {
            try {
                Class<?> cls = Class.forName(config.getCrashProcessorClass());
                this.crashProcessor = (CrashProcessor)cls.getConstructors()[0].newInstance(new Object[0]);
            }
            catch (Throwable t) {
                this.L.e("[ModuleCrash] Cannot instantiate CrashProcessor" + t);
            }
        }
    }

    @Override
    public void stop(CtxCore ctx, boolean clear) {
        try {
            if (this.previousHandler != null) {
                Thread.setDefaultUncaughtExceptionHandler(this.previousHandler);
            }
            if (clear) {
                ctx.getSDK().sdkStorage.storablePurge(ctx, CrashImpl.getStoragePrefix());
            }
        }
        catch (Throwable t) {
            this.L.e("[ModuleCrash] Exception while stopping crash reporting" + t);
        }
    }

    @Override
    public void onContextAcquired(final CtxCore ctx) {
        if (!this.limited) {
            this.previousHandler = Thread.getDefaultUncaughtExceptionHandler();
            final Thread.UncaughtExceptionHandler handler = Thread.getDefaultUncaughtExceptionHandler();
            Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread thread, Throwable throwable) {
                    ModuleCrash.this.crashed = true;
                    if (ModuleCrash.this.isActive()) {
                        ModuleCrash.this.onCrash(ctx, throwable, true, null, null, new String[0]);
                    }
                    if (handler != null) {
                        handler.uncaughtException(thread, throwable);
                    }
                }
            });
            this.started = System.nanoTime();
        }
    }

    @Override
    public Integer getFeature() {
        return CoreFeature.CrashReporting.getIndex();
    }

    public CrashImpl onCrash(CtxCore ctx, Throwable t, boolean fatal, String name, Map<String, String> segments, String ... logs) {
        if (ctx.getConfig().isBackendModeEnabled()) {
            this.L.w("[ModuleCrash] onCrash: Skipping crash, backend mode is enabled!");
            return null;
        }
        if (t == null) {
            this.L.e("[ModuleCrash] Throwable cannot be null");
            return null;
        }
        return this.onCrash(ctx, ((CrashImpl)new CrashImpl(this.L).addThrowable(t).setFatal(fatal).setName(name).setSegments((Map)segments)).setLogs(logs));
    }

    public CrashImpl onCrash(CtxCore ctx, CrashImpl crash) {
        long running = this.started == 0L ? 0L : Device.dev.nsToMs(System.nanoTime() - this.started);
        crash.putMetrics(ctx, running);
        if (!crash.getData().has("_os")) {
            this.L.w("[ModuleCrash] onCrash, While recording an exception 'OS name' was either null or empty");
        }
        if (!crash.getData().has("_app_version")) {
            this.L.w("[ModuleCrash] onCrash, While recording an exception 'App version' was either null or empty");
        }
        this.L.i("[ModuleCrash] onCrash: " + crash.getJSON());
        if (this.crashProcessor != null) {
            try {
                Crash result = this.crashProcessor.process(crash);
                if (result == null) {
                    this.L.i("[ModuleCrash] Crash is set to be ignored by CrashProcessor#process(Crash) " + this.crashProcessor);
                    Storage.remove(ctx, crash);
                    return null;
                }
            }
            catch (Throwable t) {
                this.L.e("[ModuleCrash] Error when calling CrashProcessor#process(Crash)" + t);
            }
        }
        if (!Storage.push(ctx, crash)) {
            this.L.e("[ModuleCrash] Couldn't persist a crash, so dumping it here: " + crash.getJSON());
        } else {
            SDKCore.instance.onSignal(ctx, SDKCore.Signal.Crash.getIndex(), crash.storageId().toString());
        }
        return crash;
    }

    public static void putCrashIntoParams(CrashImpl crash, Params params) {
        params.add("crash", (Object)crash.getJSON());
    }
}

