/*
 * Decompiled with CFR 0.152.
 */
package ly.count.sdk.java.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Future;
import ly.count.sdk.java.Config;
import ly.count.sdk.java.internal.CoreFeature;
import ly.count.sdk.java.internal.CtxCore;
import ly.count.sdk.java.internal.DeviceIdGenerator;
import ly.count.sdk.java.internal.InternalConfig;
import ly.count.sdk.java.internal.Log;
import ly.count.sdk.java.internal.ModuleBase;
import ly.count.sdk.java.internal.ModuleRequests;
import ly.count.sdk.java.internal.Request;
import ly.count.sdk.java.internal.SDKCore;
import ly.count.sdk.java.internal.SessionImpl;
import ly.count.sdk.java.internal.Storage;
import ly.count.sdk.java.internal.Tasks;
import ly.count.sdk.java.internal.Transformer;
import ly.count.sdk.java.internal.Utils;

public class ModuleDeviceIdCore
extends ModuleBase {
    private Tasks tasks;
    private static final Map<Integer, DeviceIdGenerator> generators = new HashMap<Integer, DeviceIdGenerator>();
    private static long testSleep;

    public static void registerGenerator(int index, DeviceIdGenerator generator) {
        generators.put(index, generator);
    }

    @Override
    public void init(InternalConfig config, Log logger) throws IllegalArgumentException {
        super.init(config, logger);
        DeviceIdGenerator generator = generators.get(config.getDeviceIdStrategy());
        if (generator == null) {
            this.L.e("[ModuleDeviceIdCore] Device id strategy [" + config.getDeviceIdStrategy() + "] is not supported by SDK.");
        } else if (!generator.isAvailable()) {
            String str = "Device id strategy [" + config.getDeviceIdStrategy() + "] is not available. Make sure corresponding classes are in class path.";
            if (!config.isDeviceIdFallbackAllowed()) {
                this.L.e(str);
                return;
            }
            this.L.w(str);
            int index = config.getDeviceIdStrategy();
            boolean found = false;
            while (--index > 0) {
                generator = generators.get(index);
                if (!generator.isAvailable()) continue;
                this.L.w("[ModuleDeviceIdCore] Will fall back to strategy [" + index + "]");
                found = true;
            }
            if (!found) {
                this.L.e("[ModuleDeviceIdCore] No fallback device id generation strategy available, SDK won't function properly");
            }
        }
    }

    @Override
    public void onContextAcquired(final CtxCore ctx) {
        this.L.i("[ModuleDeviceIdCore] [onContextAcquired] Starting device ID acquisition");
        if (ctx.getConfig().getDeviceId() == null) {
            this.L.i("[ModuleDeviceIdCore] Acquiring device id");
            if (Utils.isNotEmpty(ctx.getConfig().getCustomDeviceId())) {
                Config.DID did = new Config.DID(0, 10, ctx.getConfig().getCustomDeviceId());
                this.L.d("[ModuleDeviceIdCore] Got developer id [" + did + "]");
                SDKCore.instance.onDeviceId(ctx, did, null);
            } else {
                Config.DID did = new Config.DID(0, ctx.getConfig().getDeviceIdStrategy(), null);
                this.acquireId(ctx, did, ctx.getConfig().isDeviceIdFallbackAllowed(), new Tasks.Callback<Config.DID>(){

                    @Override
                    public void call(Config.DID id) throws Exception {
                        if (id != null) {
                            if (id.strategy == 0) {
                                ModuleDeviceIdCore.this.L.i("During init, custom device id was not provided. SDK has generated a random device id.");
                            }
                            ModuleDeviceIdCore.this.L.d("[ModuleDeviceIdCore] Got device id: " + id);
                            SDKCore.instance.onDeviceId(ctx, id, null);
                        } else {
                            ModuleDeviceIdCore.this.L.i("[ModuleDeviceIdCore] No device id of strategy [" + ctx.getConfig().getDeviceIdStrategy() + "] is available yet");
                        }
                    }
                });
            }
        } else {
            Config.DID loadedDid = ctx.getConfig().getDeviceId();
            this.L.d("[ModuleDeviceIdCore] [onContextAcquired] Loading previously saved device id:[" + loadedDid.id + "] realm:[" + loadedDid.realm + "] strategy:[" + loadedDid.strategy + "]");
            SDKCore.instance.onDeviceId(ctx, loadedDid, loadedDid);
        }
    }

    @Override
    public void onDeviceId(final CtxCore ctx, final Config.DID deviceId, Config.DID oldDeviceId) {
        if (ctx.getConfig().isLimited()) {
            return;
        }
        this.L.d("[ModuleDeviceIdCore] onDeviceId [" + deviceId + "]");
        SessionImpl session = SDKCore.instance.getSession();
        if (deviceId != null && oldDeviceId != null && deviceId.realm == 0 && !deviceId.equals(oldDeviceId)) {
            if (session != null && session.isActive()) {
                this.L.d("[ModuleDeviceIdCore] Ending session because device id was changed from [" + oldDeviceId.id + "]");
                session.end(null, null, oldDeviceId.id);
            }
            Request request = ModuleRequests.nonSessionRequest(ctx);
            if (!request.params.has("device_id")) {
                request.params.add("device_id", (Object)deviceId.id);
            }
            request.params.add("old_device_id", (Object)oldDeviceId.id);
            ModuleRequests.pushAsync(ctx, request);
            this.sendDIDSignal(ctx, deviceId, oldDeviceId);
        } else if (deviceId == null && oldDeviceId != null && oldDeviceId.realm == 0) {
            if (session != null) {
                this.L.d("[ModuleDeviceIdCore] Ending session because device id was unset from [" + oldDeviceId.id + "]");
                session.end(null, null, oldDeviceId.id);
            }
            this.sendDIDSignal(ctx, null, oldDeviceId);
        } else if (deviceId != null && oldDeviceId == null && deviceId.realm == 0) {
            if (this.tasks == null) {
                this.tasks = new Tasks("deviceId", this.L);
            }
            this.tasks.run(new Tasks.Task<Object>(Long.valueOf(0L)){

                @Override
                public Object call() throws Exception {
                    ModuleDeviceIdCore.this.L.i("[ModuleDeviceIdCore] Adding device_id to previous requests");
                    boolean success = ModuleDeviceIdCore.this.transformRequests(ctx, deviceId.id);
                    if (success) {
                        ModuleDeviceIdCore.this.L.i("[ModuleDeviceIdCore] First transform: success");
                    } else {
                        ModuleDeviceIdCore.this.L.w("[ModuleDeviceIdCore] First transform: failure");
                    }
                    success = ModuleDeviceIdCore.this.transformRequests(ctx, deviceId.id);
                    if (!success) {
                        ModuleDeviceIdCore.this.L.e("[ModuleDeviceIdCore] Failed to put device_id into existing requests, following behaviour for unhandled requests is undefined.");
                    } else {
                        ModuleDeviceIdCore.this.L.i("[ModuleDeviceIdCore] Second transform: success");
                    }
                    ModuleDeviceIdCore.this.sendDIDSignal(ctx, deviceId, null);
                    return null;
                }
            });
        }
    }

    @Override
    public Integer getFeature() {
        return CoreFeature.DeviceId.getIndex();
    }

    private boolean transformRequests(CtxCore ctx, final String deviceId) {
        return Storage.transform(ctx, Request.getStoragePrefix(), new Transformer(){

            @Override
            public byte[] doTheJob(Long id, byte[] data) {
                Request request = new Request(id);
                if (request.restore(data, ModuleDeviceIdCore.this.L) && !request.params.has("device_id")) {
                    request.params.add("device_id", (Object)deviceId);
                    return request.store(ModuleDeviceIdCore.this.L);
                }
                return null;
            }
        });
    }

    private void sendDIDSignal(CtxCore ctx, Config.DID id, Config.DID old) {
        this.L.d("[ModuleDeviceIdCore] Sending device id signal: [" + id + "], was [" + old + "]");
        SDKCore.instance.onSignal(ctx, SDKCore.Signal.DID.getIndex(), id, old);
    }

    public void login(CtxCore ctx, String id) {
        if (Utils.isEmptyOrNull(id)) {
            this.L.e("[ModuleDeviceIdCore] Empty id passed to login method");
        } else {
            Config.DID old = ctx.getConfig().getDeviceId();
            ctx.getConfig().setDeviceId(new Config.DID(0, 10, id));
            Storage.push(ctx, ctx.getConfig());
            SDKCore.instance.onDeviceId(ctx, ctx.getConfig().getDeviceId(), old);
        }
    }

    public void logout(final CtxCore ctx) {
        Config.DID old = ctx.getConfig().getDeviceId();
        ctx.getConfig().removeDeviceId(old);
        Storage.push(ctx, ctx.getConfig());
        SDKCore.instance.onDeviceId(ctx, null, old);
        this.acquireId(ctx, new Config.DID(0, ctx.getConfig().getDeviceIdStrategy(), null), ctx.getConfig().isDeviceIdFallbackAllowed(), new Tasks.Callback<Config.DID>(){

            @Override
            public void call(Config.DID id) throws Exception {
                if (id != null) {
                    ModuleDeviceIdCore.this.L.d("[ModuleDeviceIdCore] Got device id: " + id);
                    SDKCore.instance.onDeviceId(ctx, id, null);
                } else {
                    ModuleDeviceIdCore.this.L.i("[ModuleDeviceIdCore] No device id of strategy [" + ctx.getConfig().getDeviceIdStrategy() + "] is available yet");
                }
            }
        });
    }

    public void changeDeviceId(CtxCore ctx, String id, boolean withMerge) {
        if (Utils.isEmptyOrNull(id)) {
            this.L.e("[ModuleDeviceIdCore] Empty id passed to resetId method");
        } else {
            Config.DID old = ctx.getConfig().getDeviceId();
            ctx.getConfig().setDeviceId(new Config.DID(0, 10, id));
            Storage.push(ctx, ctx.getConfig());
            if (withMerge) {
                SDKCore.instance.onDeviceId(ctx, ctx.getConfig().getDeviceId(), old);
            } else {
                SDKCore.instance.onDeviceId(ctx, null, old);
                SDKCore.instance.onDeviceId(ctx, ctx.getConfig().getDeviceId(), null);
            }
        }
    }

    protected Future<Config.DID> acquireId(final CtxCore ctx, final Config.DID holder, final boolean fallbackAllowed, Tasks.Callback<Config.DID> callback) {
        this.L.d("[ModuleDeviceIdCore] d4");
        if (this.tasks == null) {
            this.tasks = new Tasks("deviceId", this.L);
        }
        return this.tasks.run(new Tasks.Task<Config.DID>(Tasks.ID_STRICT){

            @Override
            public Config.DID call() throws Exception {
                return ModuleDeviceIdCore.this.acquireIdSync(ctx, holder, fallbackAllowed);
            }
        }, callback);
    }

    protected Config.DID acquireIdSync(CtxCore ctx, Config.DID holder, boolean fallbackAllowed) {
        if (testSleep > 0L) {
            try {
                Thread.sleep(testSleep);
            }
            catch (InterruptedException ie) {
                this.L.e("[ModuleDeviceIdCore] Exception during tests " + ie);
            }
        }
        this.L.d((ctx.getConfig().isLimited() ? "limited " : "") + "acquireIdSync " + holder + " / " + fallbackAllowed);
        this.L.i("[ModuleDeviceIdCore] Generating " + holder.strategy + " / " + holder.realm);
        int index = holder.strategy;
        while (index >= 0) {
            DeviceIdGenerator generator = generators.get(index);
            if (generator == null || !generator.isAvailable()) {
                if (fallbackAllowed) {
                    this.L.w("[ModuleDeviceIdCore] Device id strategy [" + index + "] is not available. Falling back to next one.");
                    --index;
                    continue;
                }
                this.L.e("[ModuleDeviceIdCore] Device id strategy [" + index + "] is not available, while fallback is not allowed. SDK won't function properly.");
                return null;
            }
            String id = generator.generate(ctx);
            if (Utils.isNotEmpty(id)) {
                return new Config.DID(holder.realm, index, id);
            }
            if (fallbackAllowed) {
                this.L.w("[ModuleDeviceIdCore] Device id strategy [" + index + "] didn't return. Falling back to next one.");
                --index;
                continue;
            }
            this.L.e("[ModuleDeviceIdCore] Device id strategy [" + index + "] didn't return, while fallback is not allowed. SDK won't function properly.");
        }
        this.L.e("[ModuleDeviceIdCore] No device id strategies to fallback from [" + ctx.getConfig().getDeviceIdStrategy() + "] is available. SDK won't function properly.");
        return null;
    }

    protected void callOnDeviceId(CtxCore ctx, Config.DID id, Config.DID old) {
        SDKCore.instance.onDeviceId(ctx, id, old);
    }

    @Override
    public void stop(CtxCore ctx, boolean clear) {
        if (this.tasks != null) {
            this.tasks.shutdown();
            this.tasks = null;
        }
    }

    static {
        ModuleDeviceIdCore.registerGenerator(0, new UUIDGenerator());
        ModuleDeviceIdCore.registerGenerator(10, new CustomIDGenerator());
        testSleep = 0L;
    }

    private static final class CustomIDGenerator
    implements DeviceIdGenerator {
        private CustomIDGenerator() {
        }

        @Override
        public boolean isAvailable() {
            return true;
        }

        @Override
        public String generate(CtxCore context) {
            String customId = context.getConfig().getCustomDeviceId();
            if (customId == null || customId.isEmpty()) {
                context.getLogger().e("[ModuleDeviceIdCore] Device ID should never be empty or null for CustomIDGenerator");
            }
            return customId;
        }
    }

    private static final class UUIDGenerator
    implements DeviceIdGenerator {
        private UUIDGenerator() {
        }

        @Override
        public boolean isAvailable() {
            return true;
        }

        @Override
        public String generate(CtxCore context) {
            return UUID.randomUUID().toString();
        }
    }
}

