/*
 * Decompiled with CFR 0.152.
 */
package ly.count.sdk.java.internal;

import java.io.UnsupportedEncodingException;
import ly.count.sdk.java.internal.CoreFeature;
import ly.count.sdk.java.internal.CtxCore;
import ly.count.sdk.java.internal.InternalConfig;
import ly.count.sdk.java.internal.Log;
import ly.count.sdk.java.internal.ModuleBase;
import ly.count.sdk.java.internal.Request;
import ly.count.sdk.java.internal.Storable;
import ly.count.sdk.java.internal.Storage;
import org.json.JSONException;
import org.json.JSONObject;

public class ModuleRatingCore
extends ModuleBase {
    protected static final String STAR_RATING_EVENT_KEY = "[CLY]_star_rating";
    protected boolean disabledModule = false;
    public static final Long storableStorageId = 123L;
    public static final String storableStoragePrefix = "rating";
    protected InternalConfig internalConfig = null;
    protected CtxCore ctx = null;

    @Override
    public void init(InternalConfig config, Log logger) {
        super.init(config, logger);
        this.internalConfig = config;
    }

    @Override
    public void onContextAcquired(CtxCore ctx) {
        this.ctx = ctx;
    }

    @Override
    public Integer getFeature() {
        return CoreFeature.StarRating.getIndex();
    }

    @Override
    public Boolean onRequest(Request request) {
        return true;
    }

    public void disableModule() {
        this.disabledModule = true;
    }

    public void PurgeRatingInfo() {
        this.ctx.getSDK().sdkStorage.storablePurge(this.ctx, storableStoragePrefix);
    }

    protected StarRatingPreferences loadStarRatingPreferences() {
        StarRatingPreferences srp = new StarRatingPreferences();
        Storage.read(this.ctx, srp);
        return srp;
    }

    protected void saveStarRatingPreferences(StarRatingPreferences srp) {
        Storage.push(this.ctx, srp);
    }

    public void setStarRatingInitConfig(int limit, String starRatingTextTitle, String starRatingTextMessage, String starRatingTextDismiss) {
        StarRatingPreferences srp = this.loadStarRatingPreferences();
        if (limit >= 0) {
            srp.sessionLimit = limit;
        }
        if (starRatingTextTitle != null) {
            srp.dialogTextTitle = starRatingTextTitle;
        }
        if (starRatingTextMessage != null) {
            srp.dialogTextMessage = starRatingTextMessage;
        }
        if (starRatingTextDismiss != null) {
            srp.dialogTextDismiss = starRatingTextDismiss;
        }
        this.saveStarRatingPreferences(srp);
    }

    public void setShowDialogAutomatically(boolean shouldShow) {
        StarRatingPreferences srp = this.loadStarRatingPreferences();
        srp.automaticRatingShouldBeShown = shouldShow;
        this.saveStarRatingPreferences(srp);
    }

    public void setStarRatingDisableAskingForEachAppVersion(boolean disableAsking) {
        StarRatingPreferences srp = this.loadStarRatingPreferences();
        srp.disabledAutomaticForNewVersions = disableAsking;
        this.saveStarRatingPreferences(srp);
    }

    public int getAutomaticStarRatingSessionLimit() {
        StarRatingPreferences srp = this.loadStarRatingPreferences();
        return srp.sessionLimit;
    }

    public int getCurrentVersionsSessionCount() {
        StarRatingPreferences srp = this.loadStarRatingPreferences();
        return srp.sessionAmount;
    }

    public void clearAutomaticStarRatingSessionCount() {
        StarRatingPreferences srp = this.loadStarRatingPreferences();
        srp.sessionAmount = 0;
        this.saveStarRatingPreferences(srp);
    }

    public void setIfRatingDialogIsCancellable(boolean isCancellable) {
        StarRatingPreferences srp = this.loadStarRatingPreferences();
        srp.isDialogCancellable = isCancellable;
        this.saveStarRatingPreferences(srp);
    }

    protected class RatingsCore {
        protected RatingsCore() {
        }

        public synchronized void setStarRatingDialogTexts(String starRatingTextTitle, String starRatingTextMessage, String starRatingTextDismiss) {
            if (ModuleRatingCore.this.disabledModule) {
                return;
            }
            ModuleRatingCore.this.L.d("[ModuleRatingCore] Setting star rating texts");
            ModuleRatingCore.this.setStarRatingInitConfig(-1, starRatingTextTitle, starRatingTextMessage, starRatingTextDismiss);
        }

        public int getAutomaticStarRatingSessionLimit() {
            if (ModuleRatingCore.this.disabledModule) {
                return -1;
            }
            int sessionLimit = ModuleRatingCore.this.getAutomaticStarRatingSessionLimit();
            ModuleRatingCore.this.L.d("[ModuleRatingCore] Getting automatic star rating session limit: [" + sessionLimit + "]");
            return sessionLimit;
        }

        public int getStarRatingsCurrentVersionsSessionCount() {
            if (ModuleRatingCore.this.disabledModule) {
                return -1;
            }
            int sessionCount = ModuleRatingCore.this.getCurrentVersionsSessionCount();
            ModuleRatingCore.this.L.d("[ModuleRatingCore] Getting star rating current version session count: [" + sessionCount + "]");
            return sessionCount;
        }

        public void clearAutomaticStarRatingSessionCount() {
            if (ModuleRatingCore.this.disabledModule) {
                return;
            }
            ModuleRatingCore.this.L.d("[ModuleRatingCore] Clearing star rating session count");
            ModuleRatingCore.this.clearAutomaticStarRatingSessionCount();
        }
    }

    public static class StarRatingPreferences
    implements Storable {
        public String appVersion = "";
        public int sessionLimit = 5;
        public int sessionAmount = 0;
        public boolean isShownForCurrentVersion = false;
        public boolean automaticRatingShouldBeShown = false;
        public boolean disabledAutomaticForNewVersions = false;
        public boolean automaticHasBeenShown = false;
        public boolean isDialogCancellable = true;
        public String dialogTextTitle = "App rating";
        public String dialogTextMessage = "Please rate this app";
        public String dialogTextDismiss = "Cancel";
        private static final String KEY_APP_VERSION = "sr_app_version";
        private static final String KEY_SESSION_LIMIT = "sr_session_limit";
        private static final String KEY_SESSION_AMOUNT = "sr_session_amount";
        private static final String KEY_IS_SHOWN_FOR_CURRENT = "sr_is_shown";
        private static final String KEY_AUTOMATIC_RATING_IS_SHOWN = "sr_is_automatic_shown";
        private static final String KEY_DISABLE_AUTOMATIC_NEW_VERSIONS = "sr_is_disable_automatic_new";
        private static final String KEY_AUTOMATIC_HAS_BEEN_SHOWN = "sr_automatic_has_been_shown";
        private static final String KEY_DIALOG_IS_CANCELLABLE = "sr_automatic_dialog_is_cancellable";
        private static final String KEY_DIALOG_TEXT_TITLE = "sr_text_title";
        private static final String KEY_DIALOG_TEXT_MESSAGE = "sr_text_message";
        private static final String KEY_DIALOG_TEXT_DISMISS = "sr_text_dismiss";

        public JSONObject toJSON(Log L) {
            JSONObject json;
            block2: {
                json = new JSONObject();
                try {
                    json.put(KEY_APP_VERSION, (Object)this.appVersion);
                    json.put(KEY_SESSION_LIMIT, this.sessionLimit);
                    json.put(KEY_SESSION_AMOUNT, this.sessionAmount);
                    json.put(KEY_IS_SHOWN_FOR_CURRENT, this.isShownForCurrentVersion);
                    json.put(KEY_AUTOMATIC_RATING_IS_SHOWN, this.automaticRatingShouldBeShown);
                    json.put(KEY_DISABLE_AUTOMATIC_NEW_VERSIONS, this.disabledAutomaticForNewVersions);
                    json.put(KEY_AUTOMATIC_HAS_BEEN_SHOWN, this.automaticHasBeenShown);
                    json.put(KEY_DIALOG_IS_CANCELLABLE, this.isDialogCancellable);
                    json.put(KEY_DIALOG_TEXT_TITLE, (Object)this.dialogTextTitle);
                    json.put(KEY_DIALOG_TEXT_MESSAGE, (Object)this.dialogTextMessage);
                    json.put(KEY_DIALOG_TEXT_DISMISS, (Object)this.dialogTextDismiss);
                }
                catch (JSONException e) {
                    if (L == null) break block2;
                    L.e("[ModuleRatingCore] [Rating] Got exception converting an StarRatingPreferences to JSON " + (Object)((Object)e));
                }
            }
            return json;
        }

        public void fromJSON(JSONObject json, Log L) {
            block6: {
                if (json != null) {
                    try {
                        this.appVersion = json.getString(KEY_APP_VERSION);
                        this.sessionLimit = json.optInt(KEY_SESSION_LIMIT, 5);
                        this.sessionAmount = json.optInt(KEY_SESSION_AMOUNT, 0);
                        this.isShownForCurrentVersion = json.optBoolean(KEY_IS_SHOWN_FOR_CURRENT, false);
                        this.automaticRatingShouldBeShown = json.optBoolean(KEY_AUTOMATIC_RATING_IS_SHOWN, true);
                        this.disabledAutomaticForNewVersions = json.optBoolean(KEY_DISABLE_AUTOMATIC_NEW_VERSIONS, false);
                        this.automaticHasBeenShown = json.optBoolean(KEY_AUTOMATIC_HAS_BEEN_SHOWN, false);
                        this.isDialogCancellable = json.optBoolean(KEY_DIALOG_IS_CANCELLABLE, true);
                        if (!json.isNull(KEY_DIALOG_TEXT_TITLE)) {
                            this.dialogTextTitle = json.getString(KEY_DIALOG_TEXT_TITLE);
                        }
                        if (!json.isNull(KEY_DIALOG_TEXT_MESSAGE)) {
                            this.dialogTextMessage = json.getString(KEY_DIALOG_TEXT_MESSAGE);
                        }
                        if (!json.isNull(KEY_DIALOG_TEXT_DISMISS)) {
                            this.dialogTextDismiss = json.getString(KEY_DIALOG_TEXT_DISMISS);
                        }
                    }
                    catch (JSONException e) {
                        if (L == null) break block6;
                        L.e("[ModuleRatingCore] [Rating] Got exception converting JSON to a StarRatingPreferences " + (Object)((Object)e));
                    }
                }
            }
        }

        @Override
        public Long storageId() {
            return storableStorageId;
        }

        @Override
        public String storagePrefix() {
            return ModuleRatingCore.storableStoragePrefix;
        }

        @Override
        public byte[] store(Log L) {
            try {
                return this.toJSON(L).toString().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                if (L != null) {
                    L.e("[ModuleRatingCore] [Rating] UTF is not supported for Rating " + e);
                }
                return null;
            }
        }

        @Override
        public boolean restore(byte[] data, Log L) {
            try {
                block5: {
                    String json = new String(data, "UTF-8");
                    try {
                        JSONObject obj = new JSONObject(json);
                        this.fromJSON(obj, L);
                    }
                    catch (JSONException e) {
                        if (L == null) break block5;
                        L.e("[ModuleRatingCore] [Rating] Couldn't decode Rating data successfully " + (Object)((Object)e));
                    }
                }
                return true;
            }
            catch (UnsupportedEncodingException e) {
                if (L != null) {
                    L.e("[ModuleRatingCore] [Rating] Cannot deserialize Rating " + e);
                }
                return false;
            }
        }
    }

    public static interface RatingCallback {
        public void onRate(int var1);

        public void onDismiss();
    }
}

