/*
 * Decompiled with CFR 0.152.
 */
package ly.count.sdk.java.internal;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import ly.count.sdk.java.internal.CoreFeature;
import ly.count.sdk.java.internal.CtxCore;
import ly.count.sdk.java.internal.InternalConfig;
import ly.count.sdk.java.internal.Log;
import ly.count.sdk.java.internal.ModuleBase;
import ly.count.sdk.java.internal.ModuleRequests;
import ly.count.sdk.java.internal.Request;
import ly.count.sdk.java.internal.Storable;
import ly.count.sdk.java.internal.Storage;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ModuleRemoteConfig
extends ModuleBase {
    Long rcRequestTimeout = 5000L;
    boolean automaticUpdateEnabled = false;
    public static final Long storableStorageId = 456L;
    public static final String storableStoragePrefix = "remote_config";
    protected InternalConfig internalConfig = null;
    protected CtxCore ctx = null;
    protected Map<Long, RemoteConfigCallback> requestCallbacks;
    protected boolean disabledModule = false;

    @Override
    public Integer getFeature() {
        return CoreFeature.RemoteConfig.getIndex();
    }

    @Override
    public void init(InternalConfig config, Log logger) {
        super.init(config, logger);
        this.requestCallbacks = new HashMap<Long, RemoteConfigCallback>();
    }

    @Override
    public void onContextAcquired(CtxCore ctx) {
        Boolean automEnabled;
        this.ctx = ctx;
        InternalConfig cfg = ctx.getConfig();
        Long timeoutVal = cfg.getRemoteConfigUpdateTimeoutLength();
        if (timeoutVal != null) {
            this.rcRequestTimeout = timeoutVal;
        }
        if ((automEnabled = cfg.getRemoteConfigAutomaticUpdateEnabled()) != null) {
            this.automaticUpdateEnabled = automEnabled;
        }
        if (this.automaticUpdateEnabled) {
            this.updateRemoteConfigValues(null, null, null);
        }
    }

    @Override
    public Boolean onRequest(Request request) {
        if (this.requestCallbacks.containsKey(request.storageId())) {
            request.own(ModuleRemoteConfig.class);
            return true;
        }
        return false;
    }

    public void disableModule() {
        this.disabledModule = true;
    }

    @Override
    public void onRequestCompleted(Request request, String response, int responseCode) {
        long receivedRequestId = request.storageId();
        boolean requestExists = this.requestCallbacks.containsKey(receivedRequestId);
        RemoteConfigCallback callback = this.requestCallbacks.get(receivedRequestId);
        String error = null;
        if (responseCode == 200) {
            try {
                JSONObject jobj = new JSONObject(response);
                RemoteConfigValueStore stored = this.getStoredValues();
                stored.mergeValues(jobj, this.L);
                this.saveStoredValues(stored);
            }
            catch (Exception e) {
                this.L.e("Failed merging new values into old ones" + e);
                error = "Error merging results";
            }
        } else {
            this.L.w("onRequestCompleted, server returned failure code, response: [" + response + "]");
            error = "Server side error, [" + response + "]";
        }
        if (callback != null) {
            callback.callback(error);
        }
    }

    protected void updateRemoteConfigValues(String[] keysOnly, String[] keysExcept, RemoteConfigCallback callback) {
        String sKOnly = null;
        String sKExcept = null;
        if (keysOnly != null && keysOnly.length > 0) {
            JSONArray includeArray = new JSONArray();
            for (String key : keysOnly) {
                includeArray.put((Object)key);
            }
            sKOnly = includeArray.toString();
        } else if (keysExcept != null && keysExcept.length > 0) {
            JSONArray excludeArray = new JSONArray();
            for (String key : keysExcept) {
                excludeArray.put((Object)key);
            }
            sKExcept = excludeArray.toString();
        }
        Request req = ModuleRequests.remoteConfigUpdate(this.ctx, sKOnly, sKExcept, ModuleRemoteConfig.class);
        this.requestCallbacks.put(req.storageId(), callback);
        ModuleRequests.pushAsync(this.ctx, req);
    }

    protected Object getRemoteConfigValue(String key) {
        RemoteConfigValueStore values = this.getStoredValues();
        return values.getValue(key);
    }

    public RemoteConfigValueStore getStoredValues() {
        RemoteConfigValueStore rcvs = new RemoteConfigValueStore();
        Storage.read(this.ctx, rcvs);
        return rcvs;
    }

    public void saveStoredValues(RemoteConfigValueStore values) {
        Storage.push(this.ctx, values);
    }

    public class RemoteConfig {
        public void updateRemoteConfig(RemoteConfigCallback callback) {
            ModuleRemoteConfig.this.L.d("Manually calling to updateRemoteConfig");
            if (ModuleRemoteConfig.this.disabledModule) {
                return;
            }
            ModuleRemoteConfig.this.updateRemoteConfigValues(null, null, callback);
        }

        public void updateRemoteConfigForKeysOnly(String[] keysOnly, RemoteConfigCallback callback) {
            ModuleRemoteConfig.this.L.d("Manually calling to updateRemoteConfig with include keys");
            if (ModuleRemoteConfig.this.disabledModule) {
                return;
            }
            if (keysOnly == null) {
                ModuleRemoteConfig.this.L.w("updateRemoteConfigExceptKeys passed 'keys to include' array is null");
            }
            ModuleRemoteConfig.this.updateRemoteConfigValues(keysOnly, null, callback);
        }

        public void updateRemoteConfigExceptKeys(String[] keysExclude, RemoteConfigCallback callback) {
            ModuleRemoteConfig.this.L.d("Manually calling to updateRemoteConfig with exclude keys");
            if (ModuleRemoteConfig.this.disabledModule) {
                return;
            }
            if (keysExclude == null) {
                ModuleRemoteConfig.this.L.w("updateRemoteConfigExceptKeys passed 'keys to ignore' array is null");
            }
            ModuleRemoteConfig.this.updateRemoteConfigValues(null, keysExclude, callback);
        }

        public Object remoteConfigValueForKey(String key) {
            ModuleRemoteConfig.this.L.d("Manually calling to remoteConfigValueForKey");
            if (ModuleRemoteConfig.this.disabledModule) {
                return null;
            }
            return ModuleRemoteConfig.this.getRemoteConfigValue(key);
        }
    }

    public static class RemoteConfigValueStore
    implements Storable {
        public JSONObject values = new JSONObject();

        public void mergeValues(JSONObject newValues, Log L) {
            if (newValues == null) {
                return;
            }
            Iterator iter = newValues.keys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                try {
                    Object value = newValues.get(key);
                    this.values.put(key, value);
                }
                catch (Exception e) {
                    if (L == null) continue;
                    L.e("[ModuleRemoteConfig]  Failed merging new remote config values " + e);
                }
            }
        }

        public Object getValue(String key) {
            return this.values.opt(key);
        }

        @Override
        public Long storageId() {
            return storableStorageId;
        }

        @Override
        public String storagePrefix() {
            return ModuleRemoteConfig.storableStoragePrefix;
        }

        @Override
        public byte[] store(Log L) {
            try {
                return this.values.toString().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                if (L != null) {
                    L.e("[ModuleRemoteConfig]  UTF is not supported for RemoteConfigValueStore " + e);
                }
                return null;
            }
        }

        @Override
        public boolean restore(byte[] data, Log L) {
            try {
                block5: {
                    String json = new String(data, "UTF-8");
                    try {
                        this.values = new JSONObject(json);
                    }
                    catch (JSONException e) {
                        if (L == null) break block5;
                        L.e("[ModuleRemoteConfig]  Couldn't decode RemoteConfigValueStore successfully " + (Object)((Object)e));
                    }
                }
                return true;
            }
            catch (UnsupportedEncodingException e) {
                if (L != null) {
                    L.e("[ModuleRemoteConfig]  Cannot deserialize RemoteConfigValueStore " + e);
                }
                return false;
            }
        }

        public String toString() {
            return this.values.toString();
        }
    }

    public static interface RemoteConfigCallback {
        public void callback(String var1);
    }
}

