/*
 * Decompiled with CFR 0.152.
 */
package ly.count.sdk.java.internal;

import java.util.concurrent.Future;
import ly.count.sdk.java.User;
import ly.count.sdk.java.internal.CoreFeature;
import ly.count.sdk.java.internal.CtxCore;
import ly.count.sdk.java.internal.Device;
import ly.count.sdk.java.internal.InternalConfig;
import ly.count.sdk.java.internal.Log;
import ly.count.sdk.java.internal.Module;
import ly.count.sdk.java.internal.ModuleBase;
import ly.count.sdk.java.internal.Params;
import ly.count.sdk.java.internal.Request;
import ly.count.sdk.java.internal.SDKCore;
import ly.count.sdk.java.internal.SessionImpl;
import ly.count.sdk.java.internal.Storage;
import ly.count.sdk.java.internal.Tasks;
import ly.count.sdk.java.internal.UserImpl;
import ly.count.sdk.java.internal.Utils;

public class ModuleRequests
extends ModuleBase {
    private static Params metrics;

    @Override
    public void init(InternalConfig config, Log logger) {
        super.init(config, logger);
    }

    @Override
    public void onContextAcquired(CtxCore ctx) {
        super.onContextAcquired(ctx);
        metrics = Device.dev.buildMetrics();
    }

    @Override
    public Integer getFeature() {
        return CoreFeature.Requests.getIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Request sessionRequest(CtxCore ctx, SessionImpl session, String type, Long value) {
        Request request = Request.build(new Object[0]);
        if (session != null && session.hasConsent(CoreFeature.Sessions)) {
            if (value != null && value > 0L) {
                request.params.add(type, (Object)value);
            }
            request.params.add("session_id", (Object)session.id);
            if ("begin_session".equals(type)) {
                request.params.add(metrics);
            }
        }
        if (session != null) {
            Long l = session.storageId();
            synchronized (l) {
                if (session.events.size() > 0 && session.hasConsent(CoreFeature.Events)) {
                    request.params.arr("events").put(session.events).add();
                    session.events.clear();
                } else {
                    session.events.clear();
                }
                if (session.params.length() > 0) {
                    request.params.add(session.params);
                    session.params.clear();
                }
            }
        }
        if (ctx.getConfig().getDeviceId() != null) {
            request.params.add("device_id", (Object)ctx.getConfig().getDeviceId().id);
        }
        if ((session != null && session.hasConsent(CoreFeature.Location) || session == null && SDKCore.enabled(CoreFeature.Location)) && request.params.has("begin_session")) {
            UserImpl user = SDKCore.instance.user();
            if (((User)user).country() != null) {
                request.params.add("country_code", (Object)((User)user).country());
            }
            if (((User)user).city() != null) {
                request.params.add("city", (Object)((User)user).city());
            }
            if (((User)user).location() != null) {
                request.params.add("location", (Object)((User)user).location());
            }
        }
        return request;
    }

    public static Future<Boolean> sessionBegin(CtxCore ctx, SessionImpl session) {
        Request request = ModuleRequests.sessionRequest(ctx, session, "begin_session", 1L);
        return request.isEmpty() ? null : ModuleRequests.pushAsync(ctx, request);
    }

    public static Future<Boolean> sessionUpdate(CtxCore ctx, SessionImpl session, Long seconds) {
        Request request = ModuleRequests.sessionRequest(ctx, session, "session_duration", seconds);
        return request.isEmpty() ? null : ModuleRequests.pushAsync(ctx, request);
    }

    public static Future<Boolean> sessionEnd(CtxCore ctx, SessionImpl session, Long seconds, String did, Tasks.Callback<Boolean> callback) {
        Request request = ModuleRequests.sessionRequest(ctx, session, "end_session", 1L);
        if (did != null && Utils.isNotEqual(did, request.params.get("device_id"))) {
            request.params.remove("device_id");
            request.params.add("device_id", (Object)did);
        }
        if (seconds != null && seconds > 0L && SDKCore.enabled(CoreFeature.Sessions)) {
            request.params.add("session_duration", (Object)seconds);
        }
        if (request.isEmpty()) {
            if (callback != null) {
                try {
                    callback.call(false);
                }
                catch (Throwable t) {
                    ctx.getLogger().e("Shouldn't happen " + t);
                }
            }
            return null;
        }
        return ModuleRequests.pushAsync(ctx, request, callback);
    }

    public static Future<Boolean> location(CtxCore ctx, double latitude, double longitude) {
        if (!SDKCore.enabled(CoreFeature.Location)) {
            return null;
        }
        Request request = ModuleRequests.sessionRequest(ctx, null, null, null);
        request.params.add("location", (Object)(latitude + "," + longitude));
        return ModuleRequests.pushAsync(ctx, request);
    }

    public static Future<Boolean> changeId(CtxCore ctx, InternalConfig config, CtxCore context, String oldId) {
        return null;
    }

    public static Request nonSessionRequest(CtxCore ctx) {
        return ModuleRequests.sessionRequest(ctx, null, null, null);
    }

    public static Request nonSessionRequest(CtxCore ctx, Long timestamp) {
        return new Request(timestamp);
    }

    public static Request ratingWidgetAvailabilityCheck(CtxCore ctx, String widgetId, Class<? extends Module> module) {
        Request req = Request.build("widget_id", widgetId, "app_key", ctx.getConfig().getServerAppKey());
        req.own(module);
        req.endpoint("/o/feedback/widget?");
        return req;
    }

    public static Request remoteConfigUpdate(CtxCore ctx, String keysInclude, String keysExclude, Class<? extends Module> module) {
        Request req = Request.build("method", "fetch_remote_config", "app_key", ctx.getConfig().getServerAppKey());
        if (keysInclude != null) {
            req.params.add("keys", (Object)keysInclude);
        } else if (keysExclude != null) {
            req.params.add("omit_keys", (Object)keysExclude);
        }
        req.own(module);
        req.endpoint("/o/sdk?");
        return req;
    }

    public static void injectParams(CtxCore ctx, ParamsInjector injector) {
        SessionImpl session = SDKCore.instance.getSession();
        if (session == null) {
            Request request = ModuleRequests.nonSessionRequest(ctx);
            injector.call(request.params);
            ModuleRequests.pushAsync(ctx, request);
        } else {
            injector.call(session.params);
        }
    }

    static Request addRequired(InternalConfig config, Request request) {
        if (request.isEmpty()) {
            return request;
        }
        if (!request.params.has("device_id")) {
            if (config.getDeviceId() == null) {
                return null;
            }
            request.params.add("device_id", (Object)config.getDeviceId().id);
        }
        if (!request.params.has("app_key")) {
            request.params.add("app_key", (Object)config.getServerAppKey());
        }
        if (!request.params.has("sdk_name")) {
            request.params.add("sdk_name", (Object)config.getSdkName()).add("sdk_version", (Object)config.getSdkVersion());
        }
        return request;
    }

    public static Future<Boolean> pushAsync(CtxCore ctx, Request request) {
        return ModuleRequests.pushAsync(ctx, request, null);
    }

    public static Future<Boolean> pushAsync(final CtxCore ctx, final Request request, final Tasks.Callback<Boolean> callback) {
        ctx.getLogger().d("New request " + request.storageId() + ": " + request);
        if (request.isEmpty()) {
            if (callback != null) {
                try {
                    callback.call(null);
                }
                catch (Exception e) {
                    ctx.getLogger().e("[ModuleRequests] Exception in a callback " + e);
                }
            }
            return null;
        }
        request.params.add("timestamp", (Object)Device.dev.uniqueTimestamp()).add("tz", (Object)Device.dev.getTimezoneOffset()).add("hour", (Object)Device.dev.currentHour()).add("dow", (Object)Device.dev.currentDayOfWeek());
        return Storage.pushAsync(ctx, request, new Tasks.Callback<Boolean>(){

            @Override
            public void call(Boolean param) throws Exception {
                SDKCore.instance.onRequest(ctx, request);
                if (callback != null) {
                    callback.call(param);
                }
            }
        });
    }

    public static interface ParamsInjector {
        public void call(Params var1);
    }
}

