/*
 * Decompiled with CFR 0.152.
 */
package ly.count.sdk.java.internal;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import ly.count.sdk.java.Config;
import ly.count.sdk.java.internal.CoreFeature;
import ly.count.sdk.java.internal.CtxCore;
import ly.count.sdk.java.internal.InternalConfig;
import ly.count.sdk.java.internal.Log;
import ly.count.sdk.java.internal.ModuleBase;
import ly.count.sdk.java.internal.SessionImpl;
import ly.count.sdk.java.internal.Storage;
import ly.count.sdk.java.internal.TimedEvents;

public class ModuleSessions
extends ModuleBase {
    private ScheduledExecutorService executor = null;
    private SessionImpl session = null;
    private TimedEvents timedEvents;

    public SessionImpl getSession() {
        return this.session;
    }

    public synchronized SessionImpl session(CtxCore ctx, Long id) {
        if (this.session == null) {
            this.session = new SessionImpl(ctx, id);
        }
        return this.session;
    }

    public void forgetSession() {
        this.session = null;
    }

    @Override
    public Integer getFeature() {
        return CoreFeature.Sessions.getIndex();
    }

    @Override
    public void init(InternalConfig config, Log logger) throws IllegalStateException {
        super.init(config, logger);
    }

    @Override
    public void onContextAcquired(final CtxCore ctx) {
        super.onContextAcquired(ctx);
        try {
            this.timedEvents = Storage.read(ctx, new TimedEvents(this.L));
            if (this.timedEvents == null) {
                this.timedEvents = new TimedEvents(this.L);
            }
            if (ctx.getConfig().getSendUpdateEachSeconds() > 0 && this.executor == null) {
                this.executor = Executors.newScheduledThreadPool(1);
                this.executor.scheduleWithFixedDelay(new Runnable(){

                    @Override
                    public void run() {
                        if (!ctx.getConfig().isBackendModeEnabled() && ModuleSessions.this.isActive() && ModuleSessions.this.getSession() != null) {
                            ModuleSessions.this.L.i("[ModuleSessions] updating session");
                            ModuleSessions.this.getSession().update();
                        }
                    }
                }, ctx.getConfig().getSendUpdateEachSeconds(), ctx.getConfig().getSendUpdateEachSeconds(), TimeUnit.SECONDS);
            }
        }
        catch (Throwable e) {
            this.L.e("[ModuleSessions] Cannot happen" + e);
            this.timedEvents = new TimedEvents(this.L);
        }
    }

    @Override
    public boolean isActive() {
        return super.isActive() || this.executor != null;
    }

    @Override
    public void stop(CtxCore ctx, boolean clear) {
        if (!clear) {
            Storage.pushAsync(ctx, this.timedEvents);
        }
        this.timedEvents = null;
        if (this.executor != null) {
            try {
                this.executor.shutdown();
                if (!this.executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                    this.executor.shutdownNow();
                    if (!this.executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                        this.L.e("[ModuleSessions] Sessions update thread must be locked");
                    }
                }
            }
            catch (Throwable t) {
                this.L.e("[ModuleSessions] Error while stopping session update thread " + t);
            }
            this.executor = null;
        }
        if (clear) {
            ctx.getSDK().sdkStorage.storablePurge(ctx, SessionImpl.getStoragePrefix());
        }
    }

    @Override
    public void onDeviceId(CtxCore ctx, Config.DID deviceId, Config.DID oldDeviceId) {
        this.L.d("[ModuleSessions] onDeviceId " + deviceId + ", old " + oldDeviceId);
        if (deviceId != null && oldDeviceId != null && deviceId.realm == 0 && !deviceId.equals(oldDeviceId) && this.getSession() == null) {
            this.session(ctx, null).begin();
        }
    }

    public TimedEvents timedEvents() {
        return this.timedEvents;
    }
}

