/*
 * Decompiled with CFR 0.152.
 */
package ly.count.sdk.java.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import ly.count.sdk.java.internal.JSONable;
import ly.count.sdk.java.internal.Log;
import ly.count.sdk.java.internal.Utils;
import org.json.JSONException;
import org.json.JSONObject;

public class Params {
    static final String PARAM_DEVICE_ID = "device_id";
    static final String PARAM_OLD_DEVICE_ID = "old_device_id";
    private StringBuilder params;
    Log L;

    public Params(Object ... objects) {
        this.params = new StringBuilder();
        if (objects != null && objects.length == 1 && objects[0] instanceof Object[]) {
            this.addObjects((Object[])objects[0]);
        } else if (objects != null && objects.length == 1 && objects[0] instanceof Params) {
            this.params.append(objects[0].toString());
        } else if (objects != null && objects.length == 1 && objects[0] instanceof String) {
            this.params.append(objects[0].toString());
        } else {
            this.addObjects(objects);
        }
    }

    public Params(String params) {
        this.params = new StringBuilder(params);
    }

    public Params() {
        this.params = new StringBuilder();
    }

    public Params add(Object ... objects) {
        return this.addObjects(objects);
    }

    public Params add(String key, Object value) {
        if (this.params.length() > 0) {
            this.params.append("&");
        }
        this.params.append(key).append("=");
        if (value != null) {
            this.params.append(Utils.urlencode(value.toString(), this.L));
        }
        return this;
    }

    public Params add(Params params) {
        if (params == null || params.length() == 0) {
            return this;
        }
        if (this.params.length() > 0) {
            this.params.append("&");
        }
        this.params.append(params.toString());
        return this;
    }

    public Params add(String string) {
        if (this.params != null) {
            this.params.append(string);
        }
        return this;
    }

    public Obj obj(String key) {
        return new Obj(key, this, this.L);
    }

    public Arr arr(String key) {
        return new Arr(key, this, this.L);
    }

    public String remove(String key) {
        ArrayList<String> pairs = new ArrayList<String>(Arrays.asList(this.params.toString().split("&")));
        for (String pair : pairs) {
            String[] comps = pair.split("=");
            if (comps.length != 2 || !comps[0].equals(key)) continue;
            pairs.remove(pair);
            this.params = new StringBuilder(Utils.join(pairs, "&"));
            return Utils.urldecode(comps[1]);
        }
        return null;
    }

    public Map<String, String> map() {
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<String> pairs = new ArrayList<String>(Arrays.asList(this.params.toString().split("&")));
        for (String pair : pairs) {
            String[] comps = pair.split("=");
            if (comps.length != 2) continue;
            map.put(comps[0], Utils.urldecode(comps[1]));
        }
        return map;
    }

    public String get(String key) {
        String[] pairs;
        if (!this.has(key)) {
            return null;
        }
        for (String pair : pairs = this.params.toString().split("&")) {
            String[] comps = pair.split("=");
            if (comps.length != 2 || !comps[0].equals(key)) continue;
            return Utils.urldecode(comps[1]);
        }
        return null;
    }

    public boolean has(String key) {
        return this.params.indexOf("&" + key + "=") != -1 || this.params.indexOf(key + "=") == 0;
    }

    private Params addObjects(Object[] objects) {
        if (objects.length % 2 != 0) {
            this.L.e("Bad number of parameters");
        } else {
            for (int i = 0; i < objects.length; i += 2) {
                this.add(objects[i] == null ? "unknown" + i : objects[i].toString(), objects.length > i + 1 ? objects[i + 1] : null);
            }
        }
        return this;
    }

    public int length() {
        return this.params.length();
    }

    public void clear() {
        this.params = new StringBuilder();
    }

    public String toString() {
        return this.params.toString();
    }

    public int hashCode() {
        return this.params.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Params)) {
            return false;
        }
        Params p = (Params)obj;
        return p.params.toString().equals(this.params.toString());
    }

    public static final class Arr {
        private final String key;
        private final Collection<String> json;
        private final Params params;
        Log L;

        Arr(String key, Params params, Log givenL) {
            this.L = givenL;
            this.params = params;
            this.key = key;
            this.json = new ArrayList<String>();
        }

        public Arr put(JSONable value) {
            this.json.add(value.toJSON(this.L));
            return this;
        }

        public Arr put(Collection collection) {
            for (Object value : collection) {
                if (!(value instanceof JSONable)) continue;
                this.json.add(((JSONable)value).toJSON(this.L));
            }
            return this;
        }

        public Params add() {
            if (this.json.size() > 0) {
                this.params.add(this.key, (Object)("[" + Utils.join(this.json, ",") + "]"));
            } else {
                this.params.add(this.key, (Object)"[]");
            }
            return this.params;
        }
    }

    public static final class Obj {
        private final String key;
        private final JSONObject json;
        private final Params params;
        Log L;

        Obj(String key, Params params, Log givenL) {
            this.L = givenL;
            this.params = params;
            this.key = key;
            this.json = new JSONObject();
        }

        public Obj put(String key, Object value) {
            try {
                this.json.put(key, value);
            }
            catch (JSONException e) {
                this.L.e("Cannot put property into Params.Obj " + e.toString());
            }
            return this;
        }

        public Params add() {
            this.params.add(this.key, (Object)this.json.toString());
            return this.params;
        }
    }
}

