/*
 * Decompiled with CFR 0.152.
 */
package ly.count.sdk.java.internal;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import ly.count.sdk.java.internal.Device;
import ly.count.sdk.java.internal.Log;
import ly.count.sdk.java.internal.Module;
import ly.count.sdk.java.internal.Params;
import ly.count.sdk.java.internal.Storable;

public class Request
implements Storable {
    public static final String MODULE = "module";
    public static final String ENDPOINT = "endpoint";
    private final Long id;
    private static final String EOR = "\n[CLY][CLY][CLY]";
    public Params params;

    public Request(Object ... params) {
        this.id = Device.dev.uniformTimestamp();
        this.params = new Params(params);
    }

    public Request own(Class<? extends Module> module) {
        this.params.add(MODULE, (Object)module.getName());
        return this;
    }

    public Request endpoint(String value) {
        this.params.add(ENDPOINT, (Object)value);
        return this;
    }

    public Class<? extends Module> owner() {
        String name = this.params.get(MODULE);
        try {
            return name == null ? null : Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public Request(Long id) {
        this.id = id;
    }

    boolean isEmpty() {
        Map<String, String> map = this.params.map();
        return map.isEmpty() || map.size() == 1 && map.containsKey("device_id");
    }

    boolean isGettable(URL serverUrl) {
        return this.isGettable(serverUrl, 0);
    }

    boolean isGettable(URL serverUrl, int addition) {
        return serverUrl.toString().length() + 3 + this.params.length() + addition < 1024;
    }

    static Request build(Object ... params) {
        return new Request(params);
    }

    public int hashCode() {
        return this.id.hashCode() + this.params.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Request)) {
            return false;
        }
        Request r = (Request)obj;
        return this.id.equals(r.id) && this.params.equals(r.params);
    }

    public String toString() {
        String p = this.params == null ? "" : this.params.toString();
        return "[" + this.id + "] " + p;
    }

    @Override
    public Long storageId() {
        return this.id;
    }

    @Override
    public String storagePrefix() {
        return Request.getStoragePrefix();
    }

    public static String getStoragePrefix() {
        return "request";
    }

    @Override
    public byte[] store(Log L) {
        try {
            return (this.params.toString() + EOR).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    @Override
    public boolean restore(byte[] data, Log L) {
        String str = new String(data, Charset.forName("UTF-8"));
        if (str.endsWith(EOR)) {
            this.params = new Params(str.substring(0, str.length() - EOR.length()));
            return true;
        }
        return false;
    }
}

