/*
 * Decompiled with CFR 0.152.
 */
package ly.count.sdk.java.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Future;
import ly.count.sdk.java.Config;
import ly.count.sdk.java.internal.Byteable;
import ly.count.sdk.java.internal.CoreFeature;
import ly.count.sdk.java.internal.CrashImpl;
import ly.count.sdk.java.internal.CtxCore;
import ly.count.sdk.java.internal.DefaultNetworking;
import ly.count.sdk.java.internal.IStorageForRequestQueue;
import ly.count.sdk.java.internal.InternalConfig;
import ly.count.sdk.java.internal.Log;
import ly.count.sdk.java.internal.Module;
import ly.count.sdk.java.internal.ModuleBackendMode;
import ly.count.sdk.java.internal.ModuleBase;
import ly.count.sdk.java.internal.ModuleCrash;
import ly.count.sdk.java.internal.ModuleDeviceIdCore;
import ly.count.sdk.java.internal.ModuleRequests;
import ly.count.sdk.java.internal.ModuleSessions;
import ly.count.sdk.java.internal.ModuleViews;
import ly.count.sdk.java.internal.Networking;
import ly.count.sdk.java.internal.Request;
import ly.count.sdk.java.internal.SDKStorage;
import ly.count.sdk.java.internal.SessionImpl;
import ly.count.sdk.java.internal.Storage;
import ly.count.sdk.java.internal.Tasks;
import ly.count.sdk.java.internal.TimedEvents;
import ly.count.sdk.java.internal.UserImpl;
import ly.count.sdk.java.internal.Utils;
import org.json.JSONObject;

public class SDKCore {
    protected static SDKCore instance;
    protected SDKStorage sdkStorage;
    private UserImpl user;
    public InternalConfig config;
    protected Networking networking;
    protected Queue<Request> requestQueueMemory = null;
    protected final Object lockBRQStorage = new Object();
    protected Log L = null;
    private static Module testDummyModule;
    private static final Map<Integer, Class<? extends Module>> DEFAULT_MAPPINGS;
    protected int consents = 0;
    private static final Map<Integer, Class<? extends Module>> moduleMappings;
    protected Map<Integer, Module> modules = new TreeMap<Integer, Module>();

    public SDKCore() {
        instance = this;
        this.sdkStorage = new SDKStorage();
    }

    protected static void registerDefaultModuleMapping(int feature, Class<? extends Module> cls) {
        DEFAULT_MAPPINGS.put(feature, cls);
    }

    protected static void registerModuleMapping(int feature, Class<? extends Module> cls) {
        if (cls != null) {
            moduleMappings.put(feature, cls);
        }
    }

    public boolean isTracking(Integer feat) {
        return this.modules != null && this.modules.containsKey(feat);
    }

    public void init(CtxCore ctx) {
        this.prepareMappings(ctx);
    }

    public void stop(final CtxCore ctx, final boolean clear) {
        if (instance == null) {
            return;
        }
        if (this.networking != null) {
            this.networking.stop(ctx);
        }
        this.L.i("[SDKCore] [SDKCore] Stopping Countly SDK" + (clear ? " and clearing all data" : ""));
        this.eachModule(new Modulator(){

            @Override
            public void run(int feature, Module module) {
                try {
                    module.stop(ctx, clear);
                    Utils.reflectiveSetField(module, "active", (Object)false, SDKCore.this.L);
                }
                catch (Throwable e) {
                    SDKCore.this.L.e("[SDKModules] Exception while stopping " + module.getClass() + " " + e);
                }
            }
        });
        this.modules.clear();
        moduleMappings.clear();
        this.user = null;
        this.config = null;
        instance = null;
        this.sdkStorage.stop(ctx, clear);
    }

    private boolean addingConsent(int adding, CoreFeature feature) {
        return (this.consents & feature.getIndex()) == 0 && (adding & feature.getIndex()) > 0;
    }

    private boolean removingConsent(int removing, CoreFeature feature) {
        return (this.consents & feature.getIndex()) == feature.getIndex() && (removing & feature.getIndex()) == feature.getIndex();
    }

    public void onConsent(CtxCore ctx, int consent) {
        if (!this.config().requiresConsent()) {
            this.L.e("[SDKModules] onConsent() shouldn't be called when Config.requiresConsent() is false");
            return;
        }
        if (this.addingConsent(consent, CoreFeature.Sessions)) {
            SessionImpl session = this.module(ModuleSessions.class).getSession();
            if (session != null) {
                session.end();
            }
            this.consents |= consent & ctx.getConfig().getFeatures1();
            this.module(ModuleSessions.class).session(ctx, null).begin();
        }
        this.consents |= consent & ctx.getConfig().getFeatures1();
        for (Integer feature : moduleMappings.keySet()) {
            Module existing = this.module(moduleMappings.get(feature));
            if (!SDKCore.enabled(feature) || existing != null) continue;
            Class<? extends Module> cls = moduleMappings.get(feature);
            if (cls == null) {
                this.L.i("[SDKModules] No module mapping for feature " + feature);
                continue;
            }
            Module module = SDKCore.instantiateModule(cls, this.L);
            if (module == null) {
                this.L.e("[SDKModules] Cannot instantiate module " + feature);
                continue;
            }
            module.init(ctx.getConfig(), this.L);
            module.onContextAcquired(ctx);
            this.modules.put(feature, module);
        }
    }

    public void onConsentRemoval(CtxCore ctx, int noConsent) {
        SessionImpl session;
        if (!this.config().requiresConsent()) {
            this.L.e("[SDKModules] onConsentRemoval() shouldn't be called when Config.requiresConsent() is false");
            return;
        }
        if (this.removingConsent(noConsent, CoreFeature.Sessions) && (session = this.module(ModuleSessions.class).getSession()) != null) {
            session.end();
        }
        if (this.removingConsent(noConsent, CoreFeature.Location)) {
            this.user().edit().optOutFromLocationServices();
        }
        this.consents &= ~noConsent;
        for (Integer feature : moduleMappings.keySet()) {
            Module existing = this.module(moduleMappings.get(feature));
            if (feature.intValue() == CoreFeature.Sessions.getIndex() || existing == null) continue;
            existing.stop(ctx, true);
            this.modules.remove(feature);
        }
    }

    protected void prepareMappings(CtxCore ctx) throws IllegalStateException {
        if (this.modules.size() > 0) {
            throw new IllegalStateException("Modules can only be built once");
        }
        moduleMappings.clear();
        moduleMappings.putAll(DEFAULT_MAPPINGS);
        for (int feature : ctx.getConfig().getModuleOverrides()) {
            SDKCore.registerModuleMapping(feature, ctx.getConfig().getModuleOverride(feature));
        }
    }

    protected void buildModules(CtxCore ctx, int features) throws IllegalArgumentException, IllegalStateException {
        if (this.modules.size() > 0) {
            throw new IllegalStateException("Modules can only be built once");
        }
        this.modules.put(-3, SDKCore.instantiateModule(moduleMappings.get(CoreFeature.DeviceId.getIndex()), this.L));
        this.modules.put(-2, SDKCore.instantiateModule(moduleMappings.get(CoreFeature.Requests.getIndex()), this.L));
        this.modules.put(CoreFeature.Sessions.getIndex(), SDKCore.instantiateModule(moduleMappings.get(CoreFeature.Sessions.getIndex()), this.L));
        this.consents = ctx.getConfig().requiresConsent() ? 0 : ctx.getConfig().getFeatures1();
        if (!ctx.getConfig().requiresConsent()) {
            for (int feature : moduleMappings.keySet()) {
                Module m;
                Class<? extends Module> cls = moduleMappings.get(feature);
                if (cls == null) continue;
                Module existing = this.module(cls);
                if ((features & feature) <= 0 || existing != null || (m = SDKCore.instantiateModule(cls, this.L)) == null) continue;
                this.modules.put(feature, m);
            }
        }
        this.modules.put(CoreFeature.BackendMode.getIndex(), SDKCore.instantiateModule(moduleMappings.get(CoreFeature.BackendMode.getIndex()), this.L));
        if (testDummyModule != null) {
            this.modules.put(CoreFeature.TestDummy.getIndex(), testDummyModule);
        }
    }

    private static Module instantiateModule(Class<? extends Module> cls, Log L) {
        try {
            return (Module)cls.getConstructors()[0].newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            L.e("[SDKModules] Module cannot be instantiated" + e);
        }
        catch (IllegalAccessException e) {
            L.e("[SDKModules] Module constructor cannot be accessed" + e);
        }
        catch (InvocationTargetException e) {
            L.e("[SDKModules] Module constructor cannot be invoked" + e);
        }
        catch (IllegalArgumentException e) {
            try {
                return (Module)cls.getConstructors()[0].newInstance(new Object[]{null});
            }
            catch (InstantiationException e1) {
                L.e("[SDKModules] Module cannot be instantiated" + e);
            }
            catch (IllegalAccessException e1) {
                L.e("[SDKModules] Module constructor cannot be accessed" + e);
            }
            catch (InvocationTargetException e1) {
                L.e("[SDKModules] Module constructor cannot be invoked" + e);
            }
        }
        return null;
    }

    protected Module module(int feature) {
        return this.module(moduleMappings.get(feature));
    }

    public <T extends Module> T module(Class<T> cls) {
        for (Module module : this.modules.values()) {
            if (!module.getClass().isAssignableFrom(cls)) continue;
            return (T)module;
        }
        return null;
    }

    protected void eachModule(Modulator modulator) {
        for (Integer feature : this.modules.keySet()) {
            modulator.run(feature, this.modules.get(feature));
        }
    }

    public SessionImpl onSessionBegan(CtxCore ctx, SessionImpl session) {
        for (Module m : this.modules.values()) {
            m.onSessionBegan(session, ctx);
        }
        return session;
    }

    public SessionImpl onSessionEnded(CtxCore ctx, SessionImpl session) {
        for (Module m : this.modules.values()) {
            m.onSessionEnded(session, ctx);
        }
        ModuleSessions sessions = (ModuleSessions)this.module(CoreFeature.Sessions.getIndex());
        if (sessions != null) {
            sessions.forgetSession();
        }
        return session;
    }

    public SessionImpl getSession() {
        ModuleSessions sessions = (ModuleSessions)this.module(CoreFeature.Sessions.getIndex());
        if (sessions != null) {
            return sessions.getSession();
        }
        return null;
    }

    public SessionImpl session(CtxCore ctx, Long id) {
        ModuleSessions sessions = (ModuleSessions)this.module(CoreFeature.Sessions.getIndex());
        if (sessions != null) {
            return sessions.session(ctx, id);
        }
        return null;
    }

    protected InternalConfig prepareConfig(CtxCore ctx) {
        InternalConfig loaded = null;
        try {
            loaded = Storage.read(ctx, new InternalConfig());
        }
        catch (IllegalArgumentException e) {
            this.L.e("[SDKCore] Cannot happen" + e);
        }
        if (loaded == null) {
            return ctx.getConfig();
        }
        loaded.setFrom(ctx.getConfig());
        return loaded;
    }

    public void init(final CtxCore ctx, final Log logger) {
        this.L = logger;
        this.L.i("[SDKCore] [SDKCore] Initializing Countly in " + (ctx.getConfig().isLimited() ? "limited" : "full") + " mode");
        this.sdkStorage.init(ctx, logger);
        this.config = this.prepareConfig(ctx);
        Utils.reflectiveSetField(ctx, "config", (Object)this.config, this.L);
        this.init(ctx);
        this.requestQueueMemory = new ArrayDeque<Request>(this.config.getRequestQueueMaxSize());
        int consents = ctx.getConfig().getFeatures1() | CoreFeature.Sessions.getIndex();
        this.buildModules(ctx, consents);
        final ArrayList failed = new ArrayList();
        this.eachModule(new Modulator(){

            @Override
            public void run(int feature, Module module) {
                try {
                    module.init(SDKCore.this.config, logger);
                    Utils.reflectiveSetField(module, "active", (Object)true, SDKCore.this.L);
                }
                catch (IllegalArgumentException | IllegalStateException e) {
                    SDKCore.this.L.e("[SDKCore] Error during module initialization" + e);
                    failed.add(feature);
                }
            }
        });
        for (Integer feature : failed) {
            this.modules.remove(feature);
        }
        if (this.config.isDefaultNetworking()) {
            this.networking = new DefaultNetworking();
            if (this.config.isBackendModeEnabled()) {
                this.networking.init(ctx, new IStorageForRequestQueue(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Request getNextRequest() {
                        Object object = SDKCore.instance.lockBRQStorage;
                        synchronized (object) {
                            if (SDKCore.this.requestQueueMemory.isEmpty()) {
                                return null;
                            }
                            return SDKCore.this.requestQueueMemory.element();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Boolean removeRequest(Request request) {
                        Object object = SDKCore.instance.lockBRQStorage;
                        synchronized (object) {
                            return SDKCore.this.requestQueueMemory.remove(request);
                        }
                    }
                });
            } else {
                this.networking.init(ctx, new IStorageForRequestQueue(){

                    @Override
                    public Request getNextRequest() {
                        return Storage.readOne(ctx, new Request(0L), true, SDKCore.this.L);
                    }

                    @Override
                    public Boolean removeRequest(Request request) {
                        return Storage.remove(ctx, request);
                    }
                });
            }
            this.networking.check(ctx);
        }
        if (this.config.isLimited()) {
            this.onLimitedContextAcquired(ctx);
        } else {
            this.recover(ctx);
            try {
                this.user = Storage.read(ctx, new UserImpl(ctx));
                if (this.user == null) {
                    this.user = new UserImpl(ctx);
                }
            }
            catch (Throwable e) {
                this.L.e("[SDKCore] Cannot happen" + e);
                this.user = new UserImpl(ctx);
            }
            this.onContextAcquired(ctx);
        }
    }

    protected void onLimitedContextAcquired(final CtxCore ctx) {
        this.eachModule(new Modulator(){

            @Override
            public void run(int feature, Module module) {
                module.onLimitedContextAcquired(ctx);
            }
        });
    }

    protected void onContextAcquired(final CtxCore ctx) {
        this.eachModule(new Modulator(){

            @Override
            public void run(int feature, Module module) {
                module.onContextAcquired(ctx);
            }
        });
    }

    public UserImpl user() {
        return this.user;
    }

    TimedEvents timedEvents() {
        return ((ModuleSessions)this.module(CoreFeature.Sessions.getIndex())).timedEvents();
    }

    public InternalConfig config() {
        return this.config;
    }

    public void onCrash(CtxCore ctx, Throwable t, boolean fatal, String name, Map<String, String> segments, String[] logs) {
        this.L.i("[SDKCore] [SDKCore] onCrash: t: " + t.toString() + " fatal: " + fatal + " name: " + name + " segments: " + segments);
        ModuleCrash module = (ModuleCrash)this.module(CoreFeature.CrashReporting.getIndex());
        if (module != null) {
            module.onCrash(ctx, t, fatal, name, segments, logs);
        }
    }

    public void onUserChanged(final CtxCore ctx, final JSONObject changes, final Set<String> cohortsAdded, final Set<String> cohortsRemoved) {
        this.eachModule(new Modulator(){

            @Override
            public void run(int feature, Module module) {
                module.onUserChanged(ctx, changes, cohortsAdded, cohortsRemoved);
            }
        });
    }

    public void onDeviceId(CtxCore ctx, Config.DID id, Config.DID old) {
        this.L.d((this.config.isLimited() ? "limited" : "non-limited") + " onDeviceId " + id + ", old " + old);
        if (this.config.isLimited()) {
            if (!(id == null || id.equals(old) && id.equals(this.config.getDeviceId(id.realm)))) {
                this.config.setDeviceId(id);
            } else if (id == null && old != null) {
                this.config.removeDeviceId(old);
            }
        } else if (!(id == null || id.equals(old) && id.equals(this.config.getDeviceId(id.realm)))) {
            this.config.setDeviceId(id);
            Storage.push(ctx, SDKCore.instance.config);
        } else if (id == null && old != null && this.config.removeDeviceId(old)) {
            Storage.push(ctx, this.config);
        }
        for (Module module : this.modules.values()) {
            module.onDeviceId(ctx, id, old);
        }
        if (this.config.isLimited()) {
            this.config = Storage.read(ctx, new InternalConfig());
            if (this.config == null) {
                this.L.e("[SDKCore] ConfigCore reload gave null instance");
            } else {
                this.config.setLimited(true);
            }
            this.user = Storage.read(ctx, new UserImpl(ctx));
            if (this.user == null) {
                this.user = new UserImpl(ctx);
            }
        }
        if (!this.config.isLimited() && id != null && id.realm == 0) {
            this.user.id = id.id;
            this.L.d("[SDKCore] 5");
        }
    }

    public Future<Config.DID> acquireId(CtxCore ctx, Config.DID holder, boolean fallbackAllowed, Tasks.Callback<Config.DID> callback) {
        return ((ModuleDeviceIdCore)this.module(CoreFeature.DeviceId.getIndex())).acquireId(ctx, holder, fallbackAllowed, callback);
    }

    public void login(CtxCore ctx, String id) {
        ((ModuleDeviceIdCore)this.module(CoreFeature.DeviceId.getIndex())).login(ctx, id);
    }

    public void logout(CtxCore ctx) {
        ((ModuleDeviceIdCore)this.module(CoreFeature.DeviceId.getIndex())).logout(ctx);
    }

    public void changeDeviceIdWithoutMerge(CtxCore ctx, String id) {
        ((ModuleDeviceIdCore)this.module(CoreFeature.DeviceId.getIndex())).changeDeviceId(ctx, id, false);
    }

    public void changeDeviceIdWithMerge(CtxCore ctx, String id) {
        ((ModuleDeviceIdCore)this.module(CoreFeature.DeviceId.getIndex())).changeDeviceId(ctx, id, true);
    }

    public static boolean enabled(int feature) {
        return (feature & SDKCore.instance.consents) == feature && (feature & instance.config().getFeatures1()) == feature;
    }

    public static boolean enabled(CoreFeature feature) {
        return SDKCore.enabled(feature.getIndex());
    }

    public boolean hasConsentForFeature(CoreFeature feature) {
        if (!SDKCore.instance.config.requiresConsent()) {
            return true;
        }
        return SDKCore.enabled(feature);
    }

    public Boolean isRequestReady(Request request) {
        Class<? extends Module> cls = request.owner();
        if (cls == null) {
            return true;
        }
        ModuleBase module = (ModuleBase)this.module(cls);
        request.params.remove("module");
        if (module == null) {
            return true;
        }
        return module.onRequest(request);
    }

    public void onRequestCompleted(Request request, String response, int responseCode, Class<? extends Module> requestOwner) {
        Module module;
        if (requestOwner != null && (module = this.module(requestOwner)) != null) {
            module.onRequestCompleted(request, response, responseCode);
        }
    }

    protected void recover(CtxCore ctx) {
        List<Long> crashes = Storage.list(ctx, CrashImpl.getStoragePrefix());
        for (Long id : crashes) {
            this.L.i("[SDKCore] [SDKCore] Found unprocessed crash " + id);
            this.onSignal(ctx, Signal.Crash.getIndex(), id.toString());
        }
        List<Long> sessions = Storage.list(ctx, SessionImpl.getStoragePrefix());
        for (Long id : sessions) {
            this.L.d("[SDKCore] recovering session " + id);
            SessionImpl session = Storage.read(ctx, new SessionImpl(ctx, id));
            if (session == null) {
                this.L.e("[SDKCore] no session with id " + id + " found while recovering");
                continue;
            }
            Boolean success = session.recover(this.config, this.L);
            this.L.d("[SDKCore] session " + id + " recovery " + (success == null ? "won't recover" : (success != false ? "success" : "failure")));
        }
    }

    public void onSignal(CtxCore ctx, int id, Byteable param1, Byteable param2) {
        if (id == Signal.DID.getIndex()) {
            this.networking.check(ctx);
        }
    }

    public void onSignal(CtxCore ctx, int id, String param) {
        if (id == Signal.Ping.getIndex()) {
            this.networking.check(ctx);
        } else if (id == Signal.Crash.getIndex()) {
            this.processCrash(ctx, Long.parseLong(param));
        }
    }

    private boolean processCrash(CtxCore ctx, Long id) {
        CrashImpl crash = new CrashImpl(id, this.L);
        if ((crash = Storage.read(ctx, crash)) == null) {
            this.L.e("Cannot read crash from storage, skipping");
            return false;
        }
        Request request = ModuleRequests.nonSessionRequest(ctx);
        ModuleCrash.putCrashIntoParams(crash, request.params);
        if (Storage.push(ctx, request)) {
            this.L.i("[SDKLifecycle] Added request " + request.storageId() + " instead of crash " + crash.storageId());
            this.networking.check(ctx);
            Boolean success = Storage.remove(ctx, crash);
            return success == null ? false : success;
        }
        this.L.e("[SDKLifecycle] Couldn't write request " + request.storageId() + " instead of crash " + crash.storageId());
        return false;
    }

    public void onRequest(CtxCore ctx, Request request) {
        this.onSignal(ctx, Signal.Ping.getIndex(), null);
    }

    static {
        testDummyModule = null;
        DEFAULT_MAPPINGS = new HashMap<Integer, Class<? extends Module>>();
        SDKCore.registerDefaultModuleMapping(CoreFeature.DeviceId.getIndex(), ModuleDeviceIdCore.class);
        SDKCore.registerDefaultModuleMapping(CoreFeature.Requests.getIndex(), ModuleRequests.class);
        SDKCore.registerDefaultModuleMapping(CoreFeature.Views.getIndex(), ModuleViews.class);
        SDKCore.registerDefaultModuleMapping(CoreFeature.Sessions.getIndex(), ModuleSessions.class);
        SDKCore.registerDefaultModuleMapping(CoreFeature.CrashReporting.getIndex(), ModuleCrash.class);
        SDKCore.registerDefaultModuleMapping(CoreFeature.BackendMode.getIndex(), ModuleBackendMode.class);
        moduleMappings = new HashMap<Integer, Class<? extends Module>>();
    }

    static interface ModuleCallback {
        public void call(Module var1);
    }

    public static interface Modulator {
        public void run(int var1, Module var2);
    }

    public static enum Signal {
        DID(1),
        Crash(2),
        Ping(3),
        Start(10);

        private final int index;

        private Signal(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

