/*
 * Decompiled with CFR 0.152.
 */
package ly.count.sdk.java.internal;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import ly.count.sdk.java.internal.CtxCore;
import ly.count.sdk.java.internal.Log;
import ly.count.sdk.java.internal.Storable;
import ly.count.sdk.java.internal.Storage;
import ly.count.sdk.java.internal.Utils;

public class SDKStorage {
    private Log L;
    private CtxCore ctx;
    private static final String FILE_NAME_PREFIX = "[CLY]";
    private static final String FILE_NAME_SEPARATOR = "_";

    protected SDKStorage() {
    }

    public void init(CtxCore ctx, Log logger) {
        this.L = logger;
        this.ctx = ctx;
    }

    public void stop(CtxCore ctx, boolean clear) {
        Storage.await(this.L);
        if (clear) {
            this.storablePurge(ctx, null);
        }
        Storage.stop();
    }

    private static String getName(Storable storable) {
        return SDKStorage.getName(storable.storagePrefix(), storable.storageId().toString());
    }

    private static String getName(String ... names) {
        if (names == null || names.length == 0 || Utils.isEmptyOrNull(names[0])) {
            return FILE_NAME_PREFIX;
        }
        StringBuilder prefix = new StringBuilder(FILE_NAME_PREFIX);
        for (String name : names) {
            if (name == null) break;
            prefix.append(FILE_NAME_SEPARATOR).append(name);
        }
        return prefix.toString();
    }

    private static String extractName(String filename, String prefix) {
        if (filename.indexOf(prefix) == 0) {
            return filename.substring(prefix.length());
        }
        return null;
    }

    public int storablePurge(CtxCore context, String prefix) {
        String[] files;
        prefix = SDKStorage.getName(prefix) + FILE_NAME_SEPARATOR;
        this.L.i("[SDKStorage] Purging storage for prefix " + prefix);
        int deleted = 0;
        for (String file : files = this.getFileList(context)) {
            if (!file.startsWith(prefix) || !this.deleteFile(context, file)) continue;
            ++deleted;
        }
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean storableWrite(CtxCore context, String prefix, Long id, byte[] data) {
        String filename = SDKStorage.getName(prefix, id.toString());
        FileOutputStream stream = null;
        FileLock lock = null;
        try {
            stream = this.openFileAsOutputStream(context, filename);
            lock = stream.getChannel().tryLock();
            if (lock == null) {
                Boolean bl = false;
                return bl;
            }
            stream.write(data);
            stream.close();
            Boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.L.w("[SDKStorage] Cannot write data to " + filename + " " + e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    this.L.w("[SDKStorage] Couldn't close output stream for " + filename + " " + e);
                }
            }
            if (lock != null && lock.isValid()) {
                try {
                    lock.release();
                }
                catch (IOException e) {
                    this.L.w("[SDKStorage] Couldn't release lock for " + filename + " " + e);
                }
            }
        }
        return false;
    }

    public <T extends Storable> Boolean storableWrite(CtxCore context, T storable) {
        return this.storableWrite(context, storable.storagePrefix(), storable.storageId(), storable.store(this.L));
    }

    private String createFileFullPath(CtxCore context, String filename) {
        String directoryPath = context.getContext().getAbsolutePath();
        return directoryPath + File.separator + filename;
    }

    private FileInputStream openFileAsInputStream(CtxCore context, String filename) throws FileNotFoundException {
        File initialFile = new File(this.createFileFullPath(context, filename));
        return new FileInputStream(initialFile);
    }

    private FileOutputStream openFileAsOutputStream(CtxCore context, String filename) throws FileNotFoundException {
        File initialFile = new File(this.createFileFullPath(context, filename));
        return new FileOutputStream(initialFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] storableReadBytes(CtxCore context, String filename) {
        ByteArrayOutputStream buffer = null;
        FileInputStream stream = null;
        try {
            int read;
            buffer = new ByteArrayOutputStream();
            stream = this.openFileAsInputStream(context, filename);
            byte[] data = new byte[4096];
            while ((read = stream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, read);
            }
            stream.close();
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
        catch (FileNotFoundException e) {
            byte[] byArray = null;
            return byArray;
        }
        catch (IOException e) {
            this.L.e("[SDKStorage] Error while reading file " + filename + " " + e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    this.L.e("[SDKStorage] Couldn't close input stream for " + filename + " " + e);
                }
            }
            if (buffer != null) {
                try {
                    buffer.close();
                }
                catch (IOException e) {
                    this.L.e("[SDKStorage] Cannot happen" + e);
                }
            }
        }
        return null;
    }

    public byte[] storableReadBytes(CtxCore ctx, String prefix, Long id) {
        return this.storableReadBytes(ctx, SDKStorage.getName(prefix, id.toString()));
    }

    public <T extends Storable> Boolean storableRead(CtxCore context, T storable) {
        byte[] data = this.storableReadBytes(context, SDKStorage.getName(storable));
        if (data == null) {
            return null;
        }
        return storable.restore(data, this.L);
    }

    public <T extends Storable> Map.Entry<Long, byte[]> storableReadBytesOneOf(CtxCore context, T storable, boolean asc) {
        List<Long> list = this.storableList(context, storable.storagePrefix(), asc ? 1 : -1);
        if (list.size() > 0) {
            return new AbstractMap.SimpleEntry<Long, byte[]>(list.get(0), this.storableReadBytes(context, SDKStorage.getName(storable.storagePrefix(), list.get(0).toString())));
        }
        return null;
    }

    private boolean deleteFile(CtxCore context, String filename) {
        File file = new File(this.createFileFullPath(context, filename));
        return file.delete();
    }

    public <T extends Storable> Boolean storableRemove(CtxCore context, T storable) {
        return this.deleteFile(context, SDKStorage.getName(storable.storagePrefix(), storable.storageId().toString()));
    }

    public <T extends Storable> Boolean storablePop(CtxCore ctx, T storable) {
        Boolean read = this.storableRead(ctx, storable);
        if (read == null) {
            return null;
        }
        if (read.booleanValue()) {
            return this.storableRemove(ctx, storable);
        }
        return read;
    }

    private String[] getFileList(CtxCore context) {
        File[] files = context.getContext().listFiles();
        if (files == null) {
            return new String[0];
        }
        ArrayList<String> fileNames = new ArrayList<String>();
        for (File file : files) {
            if (!file.isFile()) continue;
            fileNames.add(file.getName());
        }
        String[] ret = new String[fileNames.size()];
        return fileNames.toArray(ret);
    }

    public List<Long> storableList(CtxCore context, String prefix, int slice) {
        if (Utils.isEmptyOrNull(prefix)) {
            this.L.e("[SDKStorage] Cannot get list of ids without prefix");
        }
        prefix = prefix + FILE_NAME_SEPARATOR;
        String alternativePrefix = "[CLY]_" + prefix;
        ArrayList<Long> list = new ArrayList<Long>();
        Object[] files = this.getFileList(context);
        Arrays.sort(files);
        int max = slice == 0 ? Integer.MAX_VALUE : Math.abs(slice);
        for (int i = 0; i < files.length; ++i) {
            int idx = slice >= 0 ? i : files.length - 1 - i;
            Object file = files[idx];
            if (!((String)file).startsWith(prefix) && !((String)file).startsWith(alternativePrefix)) continue;
            try {
                String name = SDKStorage.extractName((String)file, ((String)file).startsWith(prefix) ? prefix : alternativePrefix);
                if (name != null) {
                    list.add(Long.parseLong(name));
                }
            }
            catch (NumberFormatException nfe) {
                this.L.e("[SDKStorage] Wrong file name: " + (String)file + " / " + prefix);
            }
            if (list.size() >= max) break;
        }
        return list;
    }
}

