/*
 * Decompiled with CFR 0.152.
 */
package ly.count.sdk.java.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import ly.count.sdk.java.Config;
import ly.count.sdk.java.Event;
import ly.count.sdk.java.Session;
import ly.count.sdk.java.Usage;
import ly.count.sdk.java.User;
import ly.count.sdk.java.View;
import ly.count.sdk.java.internal.CoreFeature;
import ly.count.sdk.java.internal.CtxCore;
import ly.count.sdk.java.internal.Device;
import ly.count.sdk.java.internal.EventImpl;
import ly.count.sdk.java.internal.InternalConfig;
import ly.count.sdk.java.internal.Log;
import ly.count.sdk.java.internal.ModuleRequests;
import ly.count.sdk.java.internal.Params;
import ly.count.sdk.java.internal.SDKCore;
import ly.count.sdk.java.internal.Storable;
import ly.count.sdk.java.internal.Storage;
import ly.count.sdk.java.internal.Tasks;
import ly.count.sdk.java.internal.TimedEvents;
import ly.count.sdk.java.internal.ViewImpl;

public class SessionImpl
implements Session,
Storable,
EventImpl.EventRecorder {
    protected Log L = null;
    protected final Long id;
    protected final CtxCore ctx;
    protected Long began;
    protected Long updated;
    protected Long ended;
    protected final List<Event> events = new ArrayList<Event>();
    protected final Params params = new Params();
    protected View currentView = null;
    protected boolean startView = true;
    private int consents;
    private boolean pushOnChange = true;

    protected SessionImpl(CtxCore ctx) {
        this.L = ctx.getLogger();
        this.id = Device.dev.uniformTimestamp();
        this.ctx = ctx;
    }

    public SessionImpl(CtxCore ctx, Long id) {
        this.L = ctx.getLogger();
        this.ctx = ctx;
        this.id = id == null ? Device.dev.uniformTimestamp() : id.longValue();
        if (SDKCore.instance != null) {
            this.consents = SDKCore.instance.consents;
        }
    }

    @Override
    public Session begin() {
        if (this.ctx.getConfig().isBackendModeEnabled()) {
            this.L.w("[SessionImpl] begin: Skipping session begin, backend mode is enabled!");
            return this;
        }
        this.L.d("[SessionImpl] begin");
        this.begin(null);
        return this;
    }

    Future<Boolean> begin(Long now) {
        if (SDKCore.instance == null) {
            this.L.e("[SessionImpl] Countly is not initialized");
            return null;
        }
        if (this.began != null) {
            this.L.e("[SessionImpl] Session already began");
            return null;
        }
        if (this.ended != null) {
            this.L.e("[SessionImpl] Session already ended");
            return null;
        }
        this.began = now == null ? System.nanoTime() : now;
        this.consents = SDKCore.instance.consents;
        if (this.pushOnChange) {
            Storage.pushAsync(this.ctx, this);
        }
        Future<Boolean> ret = ModuleRequests.sessionBegin(this.ctx, this);
        SDKCore.instance.onSessionBegan(this.ctx, this);
        return ret;
    }

    @Override
    public Session update() {
        if (this.ctx.getConfig().isBackendModeEnabled()) {
            this.L.w("[SessionImpl] update: Skipping session update, backend mode is enabled!");
            return this;
        }
        this.L.d("[SessionImpl] update");
        this.update(null);
        return this;
    }

    Future<Boolean> update(Long now) {
        if (SDKCore.instance == null) {
            this.L.e("[SessionImpl] Countly is not initialized");
            return null;
        }
        if (this.began == null) {
            this.L.e("[SessionImpl] Session is not began to update it");
            return null;
        }
        if (this.ended != null) {
            this.L.e("[SessionImpl] Session is already ended to update it");
            return null;
        }
        this.consents = SDKCore.instance.consents;
        Long duration = this.updateDuration(now);
        if (this.pushOnChange) {
            Storage.pushAsync(this.ctx, this);
        }
        return ModuleRequests.sessionUpdate(this.ctx, this, duration);
    }

    @Override
    public void end() {
        if (this.ctx.getConfig().isBackendModeEnabled()) {
            this.L.w("end: Skipping session end, backend mode is enabled!");
            return;
        }
        this.L.d("[SessionImpl] end");
        this.end(null, null, null);
    }

    Future<Boolean> end(Long now, final Tasks.Callback<Boolean> callback, String did) {
        if (SDKCore.instance == null) {
            this.L.e("[SessionImpl] Countly is not initialized");
            return null;
        }
        if (this.began == null) {
            this.L.e("[SessionImpl] Session is not began to end it");
            return null;
        }
        if (this.ended != null) {
            this.L.e("[SessionImpl] Session already ended");
            return null;
        }
        this.ended = now == null ? System.nanoTime() : now;
        this.consents = SDKCore.instance.consents;
        if (this.currentView != null) {
            this.currentView.stop(true);
        } else {
            Storage.pushAsync(this.ctx, this);
        }
        Long duration = this.updateDuration(now);
        Future<Boolean> ret = ModuleRequests.sessionEnd(this.ctx, this, duration, did, new Tasks.Callback<Boolean>(){

            @Override
            public void call(Boolean removed) throws Exception {
                if (!removed.booleanValue()) {
                    SessionImpl.this.L.i("[SessionImpl] No data in session end request");
                }
                Storage.removeAsync(SessionImpl.this.ctx, SessionImpl.this, callback);
            }
        });
        SDKCore.instance.onSessionEnded(this.ctx, this);
        return ret;
    }

    Boolean recover(Config config, Log L) {
        if (System.currentTimeMillis() - this.id < 0L) {
            return null;
        }
        Future<Boolean> future = null;
        if (this.began == null) {
            return Storage.remove(this.ctx, this);
        }
        if (this.ended == null && this.updated == null) {
            future = this.end(this.began, null, null);
        } else if (this.ended == null) {
            future = this.end(this.updated, null, null);
        } else {
            return Storage.remove(this.ctx, this);
        }
        if (future == null) {
            return null;
        }
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            if (L != null) {
                L.e("[SessionImpl] Interrupted while resolving session recovery future" + e);
            }
            return false;
        }
    }

    @Override
    public boolean isActive() {
        this.L.d("[SessionImpl] isActive");
        return this.began != null && this.ended == null;
    }

    private Long updateDuration(Long now) {
        now = now == null ? System.nanoTime() : now;
        Long duration = this.updated == null ? Long.valueOf(now - this.began) : Long.valueOf(now - this.updated);
        this.updated = now;
        return Device.dev.nsToSec(duration);
    }

    @Override
    public Event event(String key) {
        return new EventImpl(this, key, this.L);
    }

    @Override
    public Event timedEvent(String key) {
        return this.timedEvents().event(this.ctx, key);
    }

    protected TimedEvents timedEvents() {
        return SDKCore.instance.timedEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordEvent(Event event) {
        this.L.d("[SessionImpl] recordEvent: " + event.toString());
        if (!SDKCore.enabled(CoreFeature.Events)) {
            this.L.i("[SessionImpl] recordEvent: Skipping event - feature is not enabled");
            return;
        }
        if (this.began == null) {
            this.begin();
        }
        Long l = this.storageId();
        synchronized (l) {
            InternalConfig config;
            this.events.add(event);
            if (this.pushOnChange) {
                Storage.pushAsync(this.ctx, this);
            }
            if ((config = SDKCore.instance.config()) != null && this.ctx.getConfig().getEventsBufferSize() <= this.events.size()) {
                this.update();
            }
        }
    }

    @Override
    public User user() {
        if (SDKCore.instance == null) {
            this.L.e("[SessionImpl] Countly is not initialized");
            return null;
        }
        return SDKCore.instance.user();
    }

    @Override
    public Session addCrashReport(Throwable t, boolean fatal) {
        return this.addCrashReport(t, fatal, (String)null, (Map)null, new String[0]);
    }

    @Override
    public Session addCrashReport(Throwable t, boolean fatal, String name, Map<String, String> segments, String ... logs) {
        if (this.ctx.getConfig().isBackendModeEnabled()) {
            this.L.w("[SessionImpl] addCrashReport: Skipping crash, backend mode is enabled!");
            return this;
        }
        if (!SDKCore.enabled(CoreFeature.CrashReporting)) {
            this.L.i("[SessionImpl] addCrashReport: Skipping event - feature is not enabled");
            return this;
        }
        SDKCore.instance.onCrash(this.ctx, t, fatal, name, segments, logs);
        return this;
    }

    @Override
    public Session addLocation(double latitude, double longitude) {
        if (this.ctx.getConfig().isBackendModeEnabled()) {
            this.L.w("[SessionImpl] addLocation: Skipping location, backend mode is enabled!");
            return this;
        }
        this.L.d("[SessionImpl] addLocation: latitude = " + latitude + " longitude = " + longitude);
        if (!SDKCore.enabled(CoreFeature.Location)) {
            this.L.i("[SessionImpl] addLocation: Skipping event - feature is not enabled");
            return this;
        }
        return this.addParam("location", latitude + "," + longitude);
    }

    @Override
    public View view(String name, boolean start) {
        this.L.d("[SessionImpl] view: name = " + name + " start = " + start);
        if (!SDKCore.enabled(CoreFeature.Views)) {
            this.L.i("[SessionImpl] view: Skipping view - feature is not enabled");
            return null;
        }
        if (this.currentView != null) {
            this.currentView.stop(false);
        }
        this.currentView = new ViewImpl(this, name, this.L);
        this.currentView.start(start);
        this.startView = false;
        return this.currentView;
    }

    @Override
    public View view(String name) {
        return this.view(name, this.startView);
    }

    @Override
    public Usage login(String id) {
        SDKCore.instance.login(this.ctx, id);
        return this;
    }

    @Override
    public Usage logout() {
        SDKCore.instance.logout(this.ctx);
        return this;
    }

    @Override
    public String getDeviceId() {
        return this.ctx.getConfig().getDeviceId().id;
    }

    @Override
    public Usage resetDeviceId(String id) {
        this.L.d("[SessionImpl] resetDeviceId: id = " + id);
        SDKCore.instance.changeDeviceIdWithoutMerge(this.ctx, id);
        return this;
    }

    @Override
    public Usage changeDeviceIdWithMerge(String id) {
        if (this.ctx.getConfig().isBackendModeEnabled()) {
            this.L.w("[SessionImpl] changeDeviceIdWithMerge: Skipping change device id with merge, backend mode is enabled!");
            return this;
        }
        this.L.d("[SessionImpl] changeDeviceIdWithoutMerge: id = " + id);
        SDKCore.instance.changeDeviceIdWithMerge(this.ctx, id);
        return this;
    }

    @Override
    public Usage changeDeviceIdWithoutMerge(String id) {
        if (this.ctx.getConfig().isBackendModeEnabled()) {
            this.L.w("[SessionImpl] changeDeviceIdWithoutMerge: Skipping change device id without merge, backend mode is enabled!");
            return this;
        }
        this.L.d("[SessionImpl] changeDeviceIdWithoutMerge: id = " + id);
        SDKCore.instance.changeDeviceIdWithoutMerge(this.ctx, id);
        return this;
    }

    @Override
    public Session addParam(String key, Object value) {
        this.params.add(key, value);
        if (this.pushOnChange) {
            Storage.pushAsync(this.ctx, this);
        }
        return this;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public Long getBegan() {
        return this.began;
    }

    @Override
    public Long getEnded() {
        return this.ended;
    }

    @Override
    public Long storageId() {
        return this.id;
    }

    @Override
    public String storagePrefix() {
        return SessionImpl.getStoragePrefix();
    }

    public static String getStoragePrefix() {
        return "session";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] store(Log L) {
        ByteArrayOutputStream bytes = null;
        ObjectOutputStream stream = null;
        try {
            bytes = new ByteArrayOutputStream();
            stream = new ObjectOutputStream(bytes);
            stream.writeLong(this.id);
            stream.writeLong(this.began == null ? 0L : this.began);
            stream.writeLong(this.updated == null ? 0L : this.updated);
            stream.writeLong(this.ended == null ? 0L : this.ended);
            stream.writeInt(this.events.size());
            for (Event event : this.events) {
                stream.writeUTF(event.toString());
            }
            stream.writeUTF(this.params.toString());
            stream.writeInt(this.consents);
            stream.close();
            Object object = bytes.toByteArray();
            return object;
        }
        catch (IOException e) {
            if (L != null) {
                L.e("[SessionImpl] Cannot serialize session" + e);
            }
        }
        finally {
            block23: {
                block22: {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException e) {
                            if (L == null) break block22;
                            L.e("[SessionImpl] Cannot happen" + e);
                        }
                    }
                }
                if (bytes != null) {
                    try {
                        bytes.close();
                    }
                    catch (IOException e) {
                        if (L == null) break block23;
                        L.e("[SessionImpl] Cannot happen" + e);
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean restore(byte[] data, Log L) {
        ByteArrayInputStream bytes = null;
        ObjectInputStream stream = null;
        try {
            bytes = new ByteArrayInputStream(data);
            stream = new ObjectInputStream(bytes);
            if (this.id.longValue() != stream.readLong() && L != null) {
                L.e("[SessionImpl] Wrong file for session deserialization");
            }
            this.began = stream.readLong();
            this.began = this.began == 0L ? null : this.began;
            this.updated = stream.readLong();
            this.updated = this.updated == 0L ? null : this.updated;
            this.ended = stream.readLong();
            this.ended = this.ended == 0L ? null : this.ended;
            int count = stream.readInt();
            for (int i = 0; i < count; ++i) {
                EventImpl event = EventImpl.fromJSON(stream.readUTF(), null, L);
                if (event == null) continue;
                this.events.add(event);
            }
            this.params.add(stream.readUTF());
            this.consents = stream.readInt();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            if (L != null) {
                L.e("[SessionImpl] Cannot deserialize session" + e);
            }
        }
        finally {
            block24: {
                block23: {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException e) {
                            if (L == null) break block23;
                            L.e("[SessionImpl] Cannot happen" + e);
                        }
                    }
                }
                if (bytes != null) {
                    try {
                        bytes.close();
                    }
                    catch (IOException e) {
                        if (L == null) break block24;
                        L.e("[SessionImpl] Cannot happen" + e);
                    }
                }
            }
        }
        return false;
    }

    SessionImpl setPushOnChange(boolean pushOnChange) {
        this.pushOnChange = pushOnChange;
        return this;
    }

    boolean hasConsent(CoreFeature feature) {
        return this.hasConsent(feature.getIndex());
    }

    boolean hasConsent(int feature) {
        return (this.consents & feature) > 0;
    }

    void setConsents(CtxCore ctx, int features) {
        this.consents = features;
        Storage.pushAsync(ctx, this);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SessionImpl)) {
            return false;
        }
        SessionImpl session = (SessionImpl)obj;
        if (!this.id.equals(session.id)) {
            return false;
        }
        if (this.began != null && !this.began.equals(session.began) || session.began != null && !session.began.equals(this.began)) {
            return false;
        }
        if (this.updated != null && !this.updated.equals(session.updated) || session.updated != null && !session.updated.equals(this.updated)) {
            return false;
        }
        if (this.ended != null && !this.ended.equals(session.ended) || session.ended != null && !session.ended.equals(this.ended)) {
            return false;
        }
        if (!this.params.equals(session.params)) {
            return false;
        }
        return this.events.equals(session.events);
    }

    public String toString() {
        return this.params.toString();
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

