/*
 * Decompiled with CFR 0.152.
 */
package ly.count.sdk.java.internal;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import ly.count.sdk.java.internal.CtxCore;
import ly.count.sdk.java.internal.Log;
import ly.count.sdk.java.internal.Storable;
import ly.count.sdk.java.internal.Tasks;
import ly.count.sdk.java.internal.Transformer;
import ly.count.sdk.java.internal.Utils;

public class Storage {
    private static final Tasks tasks = new Tasks("storage", null);

    public static String name(Storable storable) {
        return storable.storagePrefix() + "_" + storable.storageId();
    }

    public static boolean push(CtxCore ctx, Storable storable) {
        ctx.getLogger().d("[Storage] push: " + Storage.name(storable) + " " + storable);
        try {
            return Storage.pushAsync(ctx, storable).get();
        }
        catch (InterruptedException | ExecutionException e) {
            ctx.getLogger().e("[Storage] Interrupted while pushing " + Storage.name(storable) + " " + e);
            return false;
        }
    }

    public static Future<Boolean> pushAsync(final CtxCore ctx, final Storable storable, Tasks.Callback<Boolean> callback) {
        ctx.getLogger().d("[Storage] pushAsync: " + Storage.name(storable) + " " + storable.toString());
        return tasks.run(new Tasks.Task<Boolean>(storable.storageId()){

            @Override
            public Boolean call() throws Exception {
                return ctx.getSDK().sdkStorage.storableWrite(ctx, storable);
            }
        }, callback);
    }

    public static Future<Boolean> pushAsync(CtxCore ctx, Storable storable) {
        ctx.getLogger().d("[Storage] pushAsync: " + Storage.name(storable) + " " + storable.toString());
        return Storage.pushAsync(ctx, storable, null);
    }

    public static <T extends Storable> Boolean remove(CtxCore ctx, T storable) {
        ctx.getLogger().d("[Storage] remove: " + Storage.name(storable) + " " + storable.toString());
        try {
            return Storage.removeAsync(ctx, storable, null).get();
        }
        catch (InterruptedException | ExecutionException e) {
            ctx.getLogger().e("[Storage] Interrupted while removing " + Storage.name(storable) + " " + e);
            return null;
        }
    }

    public static <T extends Storable> Future<Boolean> removeAsync(final CtxCore ctx, final T storable, Tasks.Callback<Boolean> callback) {
        return tasks.run(new Tasks.Task<Boolean>(Tasks.ID_STRICT){

            @Override
            public Boolean call() throws Exception {
                return ctx.getSDK().sdkStorage.storableRemove(ctx, storable);
            }
        }, callback);
    }

    public static <T extends Storable> T pop(CtxCore ctx, T storable) {
        ctx.getLogger().d("[Storage] pop: " + Storage.name(storable) + " " + storable.toString());
        try {
            return Storage.popAsync(ctx, storable).get();
        }
        catch (InterruptedException | ExecutionException e) {
            ctx.getLogger().e("[Storage] Interrupted while removing " + Storage.name(storable) + " " + e);
            return null;
        }
    }

    public static <T extends Storable> Future<T> popAsync(final CtxCore ctx, final T storable) {
        return tasks.run(new Tasks.Task<T>(-storable.storageId().longValue()){

            @Override
            public T call() throws Exception {
                Boolean result = ctx.getSDK().sdkStorage.storablePop(ctx, storable);
                if (result == null || !result.booleanValue()) {
                    return null;
                }
                return storable;
            }
        });
    }

    static <T extends Storable> boolean transform(final CtxCore ctx, final String prefix, final Transformer transformer) {
        ctx.getLogger().d("[Storage] readAll " + prefix);
        try {
            return tasks.run(new Tasks.Task<Boolean>(Tasks.ID_STRICT){

                @Override
                public Boolean call() throws Exception {
                    boolean success = true;
                    List<Long> ids = ctx.getSDK().sdkStorage.storableList(ctx, prefix, 0);
                    for (Long id : ids) {
                        byte[] data = ctx.getSDK().sdkStorage.storableReadBytes(ctx, prefix, id);
                        if (data != null) {
                            byte[] transformed = transformer.doTheJob(id, data);
                            if (transformed == null || ctx.getSDK().sdkStorage.storableWrite(ctx, prefix, id, transformed).booleanValue()) continue;
                            success = false;
                            ctx.getLogger().e("[Storage] Couldn't write transformed data for " + id);
                            continue;
                        }
                        success = false;
                        ctx.getLogger().e("[Storage] Couldn't read data to transform from " + id);
                    }
                    return success;
                }
            }).get();
        }
        catch (InterruptedException | ExecutionException e) {
            ctx.getLogger().e("[Storage] Interrupted while reading all " + prefix + " " + e);
            return false;
        }
    }

    public static <T extends Storable> T read(CtxCore ctx, T storable) {
        ctx.getLogger().d("[Storage] read: " + Storage.name(storable) + " " + storable.toString());
        try {
            return Storage.readAsync(ctx, storable).get();
        }
        catch (InterruptedException | ExecutionException e) {
            ctx.getLogger().e("[Storage] Interrupted while popping " + Storage.name(storable) + " " + e);
            return null;
        }
    }

    public static <T extends Storable> Future<T> readAsync(CtxCore ctx, T storable) {
        return Storage.readAsync(ctx, storable, null);
    }

    public static <T extends Storable> Future<T> readAsync(final CtxCore ctx, final T storable, final Tasks.Callback<T> callback) {
        return tasks.run(new Tasks.Task<T>(-storable.storageId().longValue()){

            @Override
            public T call() throws Exception {
                Boolean done = ctx.getSDK().sdkStorage.storableRead(ctx, storable);
                Storable ret = null;
                if (done == null || !done.booleanValue()) {
                    ctx.getLogger().e("[Storage] No data for file " + Storage.name(storable));
                } else {
                    ret = storable;
                }
                if (callback != null) {
                    callback.call(ret);
                }
                return ret;
            }
        });
    }

    public static <T extends Storable> T readOne(CtxCore ctx, T storable, boolean asc, Log L) {
        ctx.getLogger().d("[Storage] readOne: " + Storage.name(storable) + " " + storable.toString());
        try {
            return Storage.readOneAsync(ctx, storable, asc, L).get();
        }
        catch (InterruptedException | ExecutionException e) {
            ctx.getLogger().e("[Storage] Interrupted while popping " + Storage.name(storable) + " " + e);
            return null;
        }
    }

    public static <T extends Storable> Future<T> readOneAsync(final CtxCore ctx, final T storable, final boolean asc, final Log L) {
        return tasks.run(new Tasks.Task<T>(-storable.storageId().longValue()){

            @Override
            public T call() throws Exception {
                Map.Entry<Long, byte[]> data = ctx.getSDK().sdkStorage.storableReadBytesOneOf(ctx, storable, asc);
                if (data == null) {
                    return null;
                }
                Utils.reflectiveSetField(storable, "id", (Object)data.getKey(), L);
                if (storable.restore(data.getValue(), L)) {
                    return storable;
                }
                return null;
            }
        });
    }

    public static List<Long> list(CtxCore ctx, String prefix) {
        return Storage.list(ctx, prefix, 0);
    }

    public static List<Long> list(CtxCore ctx, String prefix, int slice) {
        ctx.getLogger().d("[Storage] readOne: " + prefix);
        try {
            return Storage.listAsync(ctx, prefix, slice).get();
        }
        catch (InterruptedException | ExecutionException e) {
            ctx.getLogger().e("[Storage] Interrupted while listing " + prefix + " " + e);
            return null;
        }
    }

    public static Future<List<Long>> listAsync(final CtxCore ctx, final String prefix, final int slice) {
        return tasks.run(new Tasks.Task<List<Long>>(Tasks.ID_STRICT){

            @Override
            public List<Long> call() throws Exception {
                List<Long> list = ctx.getSDK().sdkStorage.storableList(ctx, prefix, slice);
                Collections.sort(list, new Comparator<Long>(){

                    @Override
                    public int compare(Long o1, Long o2) {
                        return slice >= 0 ? o1.compareTo(o2) : o2.compareTo(o1);
                    }
                });
                return list;
            }
        });
    }

    public static void await(final Log L) {
        block3: {
            if (L != null) {
                L.d("[Storage] Waiting for storage tasks to complete");
            }
            try {
                tasks.run(new Tasks.Task<Boolean>(Tasks.ID_STRICT){

                    @Override
                    public Boolean call() throws Exception {
                        if (L != null) {
                            L.d("[Storage] Waiting for storage tasks to complete DONE");
                        }
                        return null;
                    }
                }).get();
            }
            catch (InterruptedException | ExecutionException e) {
                if (L == null) break block3;
                L.e("[Storage] Interrupted while waiting " + e);
            }
        }
    }

    public static void stop() {
        tasks.shutdown();
    }
}

