/*
 * Decompiled with CFR 0.152.
 */
package ly.count.sdk.java.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import ly.count.sdk.java.internal.Log;

public class Tasks {
    public static final Long ID_STRICT = 0L;
    public static final Long ID_LIST = -1L;
    Log L;
    private final ExecutorService executor;
    private Long running = null;
    private final Map<Long, Future> pending;

    public Tasks(final String name, Log L) {
        this.L = L;
        this.executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                return new Thread(runnable, name);
            }
        });
        this.pending = new HashMap<Long, Future>();
    }

    public <T> Future<T> run(Task<T> task) {
        return this.run(task, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> Future<T> run(final Task<T> task, final Callback<T> callback) {
        Map<Long, Future> map = this.pending;
        synchronized (map) {
            Future existing;
            if (!(task.id.equals(0L) || (existing = this.pending.get(task.id)) == null || existing.isDone() || existing.isCancelled() || this.running != null && this.running.equals(task.id))) {
                return existing;
            }
            Future future = this.executor.submit(new Task<T>(task.id){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public T call() throws Exception {
                    Tasks.this.running = task.id;
                    Object result = task.call();
                    Map map = Tasks.this.pending;
                    synchronized (map) {
                        if (!task.id.equals(0L)) {
                            Tasks.this.pending.remove(task.id);
                        }
                        Tasks.this.running = null;
                    }
                    if (callback != null) {
                        callback.call(result);
                    }
                    return result;
                }
            });
            if (!task.id.equals(0L)) {
                this.pending.put(task.id, future);
            }
            return future;
        }
    }

    boolean isRunning() {
        return this.running != null;
    }

    void shutdown() {
        block5: {
            if (!this.executor.isShutdown() && !this.executor.isTerminated()) {
                this.executor.shutdown();
                try {
                    if (!this.executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                        this.executor.shutdownNow();
                        if (!this.executor.awaitTermination(5L, TimeUnit.SECONDS) && this.L != null) {
                            this.L.e("[Task] didn't shutdown gracefully");
                        }
                    }
                }
                catch (Throwable t) {
                    if (this.L == null) break block5;
                    this.L.e("[Task] Error while shutting down tasks " + t);
                }
            }
        }
    }

    void await() {
        block2: {
            try {
                this.executor.submit(new Runnable(){

                    @Override
                    public void run() {
                    }
                }).get();
            }
            catch (InterruptedException | ExecutionException e) {
                if (this.L == null) break block2;
                this.L.e("[Task] Interrupted while waiting for Tasks to finish running tasks " + e);
            }
        }
    }

    public static interface Callback<T> {
        public void call(T var1) throws Exception;
    }

    public static abstract class Task<T>
    implements Callable<T> {
        Long id;

        Task(Long id) {
            this.id = id;
        }

        @Override
        public abstract T call() throws Exception;
    }
}

