/*
 * Decompiled with CFR 0.152.
 */
package ly.count.sdk.java.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import ly.count.sdk.java.Event;
import ly.count.sdk.java.internal.CtxCore;
import ly.count.sdk.java.internal.EventImpl;
import ly.count.sdk.java.internal.Log;
import ly.count.sdk.java.internal.SDKCore;
import ly.count.sdk.java.internal.SessionImpl;
import ly.count.sdk.java.internal.Storable;
import ly.count.sdk.java.internal.Storage;

class TimedEvents
implements Storable,
EventImpl.EventRecorder {
    private final Log L;
    private Map<String, EventImpl> events;

    protected TimedEvents(Log logger) {
        this.L = logger;
        this.events = new HashMap<String, EventImpl>();
    }

    Set<String> keys() {
        return this.events.keySet();
    }

    EventImpl event(CtxCore ctx, String key) {
        EventImpl event = this.events.get(key);
        if (event == null) {
            event = new EventImpl(this, key, this.L);
            this.events.put(key, event);
            Storage.pushAsync(ctx, this);
        }
        return event;
    }

    boolean has(String key) {
        return this.events.containsKey(key);
    }

    @Override
    public Long storageId() {
        return 0L;
    }

    @Override
    public String storagePrefix() {
        return "timedEvent";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] store(Log L) {
        ByteArrayOutputStream bytes = null;
        ObjectOutputStream stream = null;
        try {
            bytes = new ByteArrayOutputStream();
            stream = new ObjectOutputStream(bytes);
            stream.writeInt(this.events.size());
            for (String key : this.events.keySet()) {
                stream.writeUTF(key);
                stream.writeUTF(this.events.get(key).toJSON(L));
            }
            stream.close();
            Object object = bytes.toByteArray();
            return object;
        }
        catch (IOException e) {
            if (L != null) {
                L.e("[TimedEvents] Cannot serialize timed events" + e);
            }
        }
        finally {
            block23: {
                block22: {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException e) {
                            if (L == null) break block22;
                            L.e("[TimedEvents] Cannot happen" + e);
                        }
                    }
                }
                if (bytes != null) {
                    try {
                        bytes.close();
                    }
                    catch (IOException e) {
                        if (L == null) break block23;
                        L.e("[TimedEvents] Cannot happen" + e);
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean restore(byte[] data, Log L) {
        ByteArrayInputStream bytes = null;
        ObjectInputStream stream = null;
        try {
            bytes = new ByteArrayInputStream(data);
            stream = new ObjectInputStream(bytes);
            int l = stream.readInt();
            while (l-- > 0) {
                String key = stream.readUTF();
                EventImpl event = EventImpl.fromJSON(stream.readUTF(), this, L);
                this.events.put(key, event);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            if (L != null) {
                L.e("[TimedEvents] Cannot deserialize config" + e);
            }
        }
        finally {
            block23: {
                block22: {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException e) {
                            if (L == null) break block22;
                            L.e("[TimedEvents] Cannot happen" + e);
                        }
                    }
                }
                if (bytes != null) {
                    try {
                        bytes.close();
                    }
                    catch (IOException e) {
                        if (L == null) break block23;
                        L.e("[TimedEvents] Cannot happen" + e);
                    }
                }
            }
        }
        return false;
    }

    @Override
    public void recordEvent(Event event) {
        if (this.events.containsKey(((EventImpl)event).getKey())) {
            event.endAndRecord();
            this.events.remove(((EventImpl)event).getKey());
            SessionImpl session = SDKCore.instance.getSession();
            if (session != null) {
                session.recordEvent(event);
            }
        }
    }

    public int size() {
        return this.events.size();
    }
}

