/*
 * Decompiled with CFR 0.152.
 */
package ly.count.sdk.java.internal;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import ly.count.sdk.java.User;
import ly.count.sdk.java.internal.InternalConfig;
import ly.count.sdk.java.internal.Log;
import ly.count.sdk.java.internal.Module;
import ly.count.sdk.java.internal.ModuleRequests;
import ly.count.sdk.java.internal.Request;
import ly.count.sdk.java.internal.SDKCore;
import ly.count.sdk.java.internal.Tasks;
import ly.count.sdk.java.internal.Utils;
import org.json.JSONObject;

public class Transport
implements X509TrustManager {
    private Log L = null;
    private static final String PARAMETER_TAMPERING_DIGEST = "SHA-256";
    private static final String CHECKSUM = "checksum256";
    private InternalConfig config;
    private SSLContext sslContext;
    private List<byte[]> keyPins = null;
    private List<byte[]> certPins = null;
    private X509TrustManager defaultTrustManager = null;

    public void init(InternalConfig config, Log logger) throws IllegalArgumentException {
        this.L = logger;
        this.L.i("[network] Server: " + config.getServerURL());
        this.config = config;
        try {
            this.setPins(config.getPublicKeyPins(), config.getCertificatePins());
        }
        catch (CertificateException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public HttpURLConnection openConnection(String url, String params, boolean usingGET) throws IOException {
        URL u = usingGET ? new URL(url + params) : new URL(url);
        HttpURLConnection connection = (HttpURLConnection)u.openConnection();
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(!usingGET);
        connection.setRequestMethod(usingGET ? "GET" : "POST");
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HttpURLConnection connection(Request request, User user) throws IOException {
        boolean usingGET;
        String endpoint = request.params.remove("endpoint");
        if (endpoint == null) {
            endpoint = "/i?";
        }
        String path = this.config.getServerURL().toString() + endpoint;
        String picture = request.params.remove("picturePath");
        boolean bl = usingGET = !this.config.isUsePOST() && request.isGettable(this.config.getServerURL()) && Utils.isEmptyOrNull(picture);
        if (usingGET && this.config.getParameterTamperingProtectionSalt() != null) {
            request.params.add(CHECKSUM, (Object)Utils.digestHex(PARAMETER_TAMPERING_DIGEST, request.params.toString() + this.config.getParameterTamperingProtectionSalt(), this.L));
        }
        HttpURLConnection connection = this.openConnection(path, request.params.toString(), usingGET);
        connection.setConnectTimeout(1000 * this.config.getNetworkConnectionTimeout());
        connection.setReadTimeout(1000 * this.config.getNetworkReadTimeout());
        if (connection instanceof HttpsURLConnection && this.sslContext != null) {
            HttpsURLConnection https = (HttpsURLConnection)connection;
            https.setSSLSocketFactory(this.sslContext.getSocketFactory());
        }
        if (!usingGET) {
            OutputStream output = null;
            PrintWriter writer = null;
            try {
                byte[] data;
                this.L.d("[network] Picture " + picture);
                byte[] byArray = data = picture == null ? null : this.pictureData(user, picture);
                if (data != null) {
                    String boundary = Long.toHexString(System.currentTimeMillis());
                    connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
                    output = connection.getOutputStream();
                    writer = new PrintWriter((Writer)new OutputStreamWriter(output, "UTF-8"), true);
                    this.addMultipart(output, writer, boundary, "", "profilePicture", "image", data);
                    StringBuilder salting = new StringBuilder();
                    Map<String, String> map = request.params.map();
                    for (String key : map.keySet()) {
                        String value = Utils.urldecode(map.get(key));
                        salting.append(key).append("=").append(value).append("&");
                        this.addMultipart(output, writer, boundary, "text/plain", key, value, null);
                    }
                    if (this.config.getParameterTamperingProtectionSalt() != null) {
                        this.addMultipart(output, writer, boundary, "text/plain", CHECKSUM, Utils.digestHex(PARAMETER_TAMPERING_DIGEST, salting.substring(0, salting.length() - 1) + this.config.getParameterTamperingProtectionSalt(), this.L), null);
                    }
                    writer.append("\r\n").append("--").append(boundary).append("--").append("\r\n").flush();
                } else {
                    if (this.config.getParameterTamperingProtectionSalt() != null) {
                        request.params.add(CHECKSUM, (Object)Utils.digestHex(PARAMETER_TAMPERING_DIGEST, request.params.toString() + this.config.getParameterTamperingProtectionSalt(), this.L));
                    }
                    connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    output = connection.getOutputStream();
                    writer = new PrintWriter((Writer)new OutputStreamWriter(output, "UTF-8"), true);
                    writer.write(request.params.toString());
                    writer.flush();
                }
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable) {}
                }
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        return connection;
    }

    void addMultipart(OutputStream output, PrintWriter writer, String boundary, String contentType, String name, String value, Object file) throws IOException {
        writer.append("--").append(boundary).append("\r\n");
        if (file != null) {
            writer.append("Content-Disposition: form-data; name=\"").append(name).append("\"; filename=\"").append(value).append("\"").append("\r\n");
            writer.append("Content-Type: ").append(contentType).append("\r\n");
            writer.append("Content-Transfer-Encoding: binary").append("\r\n");
            writer.append("\r\n").flush();
            output.write((byte[])file);
            output.flush();
            writer.append("\r\n").flush();
        } else {
            writer.append("Content-Disposition: form-data; name=\"").append(name).append("\"").append("\r\n");
            writer.append("Content-Type: ").append(contentType).append("; charset=").append("UTF-8").append("\r\n");
            writer.append("\r\n").append(value).append("\r\n").flush();
        }
    }

    byte[] pictureData(User user, String picture) throws IOException {
        byte[] data;
        if ("[CLY]_USER_PROFILE_PICTURE".equals(picture)) {
            data = user.picture();
        } else {
            String protocol = null;
            try {
                URI uri = new URI(picture);
                protocol = uri.isAbsolute() ? uri.getScheme() : new URL(picture).getProtocol();
            }
            catch (Throwable t) {
                try {
                    File f = new File(picture);
                    protocol = f.toURI().toURL().getProtocol();
                }
                catch (Throwable tt) {
                    this.L.w("[network] Couldn't determine picturePath protocol " + tt);
                }
            }
            if (protocol != null && protocol.equals("file")) {
                int len;
                File file = new File(picture);
                if (!file.exists()) {
                    return null;
                }
                FileInputStream input = new FileInputStream(file);
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((len = input.read(buffer)) != -1) {
                    output.write(buffer, 0, len);
                }
                input.close();
                data = output.toByteArray();
                output.close();
            } else {
                return null;
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String response(HttpURLConnection connection) {
        BufferedReader reader = null;
        try {
            String line;
            InputStream responseInputStream;
            try {
                responseInputStream = connection.getInputStream();
            }
            catch (Exception ex) {
                responseInputStream = connection.getErrorStream();
            }
            reader = new BufferedReader(new InputStreamReader(responseInputStream));
            StringBuilder total = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                total.append(line).append('\n');
            }
            String string = total.toString();
            return string;
        }
        catch (IOException e) {
            this.L.w("[network] Error while reading server response " + e);
            String string = null;
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Tasks.Task<Boolean> send(final Request request) {
        return new Tasks.Task<Boolean>(request.storageId()){

            @Override
            public Boolean call() {
                return this.send();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean send() {
                Transport.this.L.i("[network] [send] Sending request: " + request);
                HttpURLConnection connection = null;
                try {
                    ModuleRequests.addRequired(Transport.this.config, request);
                    Class<? extends Module> requestOwner = request.owner();
                    request.params.remove("module");
                    connection = Transport.this.connection(request, SDKCore.instance.user());
                    connection.connect();
                    int code = connection.getResponseCode();
                    String response = Transport.this.response(connection);
                    try {
                        if (request.params.has("old_device_id") || request.params.has("token_session")) {
                            if (Transport.this.config.getNetworkImportantRequestCooldown() > 0) {
                                Thread.sleep(Transport.this.config.getNetworkImportantRequestCooldown());
                            }
                        } else if (Transport.this.config.getNetworkRequestCooldown() > 0) {
                            Thread.sleep(Transport.this.config.getNetworkRequestCooldown());
                        }
                    }
                    catch (InterruptedException ie) {
                        Transport.this.L.w("[network] Interrupted while waiting for did change request cooldown " + ie);
                    }
                    SDKCore.instance.onRequestCompleted(request, response, code, requestOwner);
                    Boolean bl = Transport.this.processResponse(code, response, request.storageId());
                    return bl;
                }
                catch (IOException e) {
                    Transport.this.L.w("[network] Error while sending request " + request + " " + e);
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    if (connection != null) {
                        connection.disconnect();
                    }
                }
            }
        };
    }

    Boolean processResponse(int code, String response, Long requestId) {
        this.L.i("[network] [processResponse] Code [" + code + "] response [" + response + "] for request[" + requestId + "]");
        JSONObject jsonObject = new JSONObject(response);
        if (code >= 200 && code < 300 && jsonObject.has("result")) {
            this.L.d("[network] Success");
            return true;
        }
        this.L.w("[network] Fail: code :" + code + ", result: " + response);
        return false;
    }

    private static String trimPem(String pem) {
        pem = pem.trim();
        String beginPK = "-----BEGIN PUBLIC KEY-----";
        if (pem.startsWith("-----BEGIN PUBLIC KEY-----")) {
            pem = pem.substring(pem.indexOf("-----BEGIN PUBLIC KEY-----") + "-----BEGIN PUBLIC KEY-----".length());
        }
        String beginCert = "-----BEGIN CERTIFICATE-----";
        if (pem.startsWith("-----BEGIN CERTIFICATE-----")) {
            pem = pem.substring(pem.indexOf("-----BEGIN CERTIFICATE-----") + "-----BEGIN CERTIFICATE-----".length());
        }
        if (pem.contains("-----END ")) {
            pem = pem.substring(0, pem.indexOf("-----END"));
        }
        String res = pem.replaceAll("\n", "");
        return res;
    }

    private void setPins(Set<String> keys, Set<String> certs) throws CertificateException {
        String string;
        byte[] data;
        this.keyPins = new ArrayList<byte[]>();
        this.certPins = new ArrayList<byte[]>();
        if (keys != null) {
            for (String key : keys) {
                try {
                    data = Utils.readStream(Transport.class.getClassLoader().getResourceAsStream(key), this.L);
                    if (data != null) {
                        string = new String(data);
                        if (string.contains("--BEGIN")) {
                            data = Utils.Base64.decode(Transport.trimPem(string), this.L);
                        }
                    } else {
                        data = Utils.Base64.decode(Transport.trimPem(key), this.L);
                    }
                    try {
                        X509EncodedKeySpec spec = new X509EncodedKeySpec(data);
                        KeyFactory kf = KeyFactory.getInstance("RSA");
                        PublicKey k = kf.generatePublic(spec);
                        this.keyPins.add(k.getEncoded());
                    }
                    catch (InvalidKeySpecException e) {
                        this.L.d("[network] Certificate in instead of public key it seems " + e);
                        CertificateFactory cf = CertificateFactory.getInstance("X.509");
                        Certificate cert = cf.generateCertificate(new ByteArrayInputStream(data));
                        this.keyPins.add(cert.getPublicKey().getEncoded());
                    }
                }
                catch (NoSuchAlgorithmException e) {
                    this.L.d("[network] Shouldn't happen " + key);
                }
            }
        }
        if (certs != null) {
            for (String cert : certs) {
                data = Utils.readStream(Transport.class.getClassLoader().getResourceAsStream(cert), this.L);
                if (data != null) {
                    string = new String(data);
                    if (string.contains("--BEGIN")) {
                        data = Utils.Base64.decode(Transport.trimPem(string), this.L);
                    }
                } else {
                    data = Utils.Base64.decode(Transport.trimPem(cert), this.L);
                }
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                Certificate certificate = cf.generateCertificate(new ByteArrayInputStream(data));
                this.certPins.add(certificate.getEncoded());
            }
        }
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("X509");
            trustManagerFactory.init((KeyStore)null);
            for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
                if (!(trustManager instanceof X509TrustManager)) continue;
                this.defaultTrustManager = (X509TrustManager)trustManager;
            }
            if (!this.keyPins.isEmpty() || !this.certPins.isEmpty()) {
                this.sslContext = SSLContext.getInstance("TLS");
                this.sslContext.init(null, new TrustManager[]{this}, null);
            }
        }
        catch (Throwable t) {
            throw new CertificateException(t);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (this.defaultTrustManager != null) {
            this.defaultTrustManager.checkClientTrusted(chain, authType);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (this.keyPins.size() == 0 && this.certPins.size() == 0) {
            return;
        }
        if (chain == null) {
            throw new IllegalArgumentException("PublicKeyManager: X509Certificate array is null");
        }
        if (chain.length <= 0) {
            throw new IllegalArgumentException("PublicKeyManager: X509Certificate is empty");
        }
        if (null == authType || !authType.contains("RSA")) {
            throw new CertificateException("PublicKeyManager: AuthType is not RSA");
        }
        if (this.defaultTrustManager != null) {
            this.defaultTrustManager.checkServerTrusted(chain, authType);
        }
        byte[] serverPublicKey = chain[0].getPublicKey().getEncoded();
        byte[] serverCertificate = chain[0].getEncoded();
        for (byte[] key : this.keyPins) {
            if (!Arrays.equals(key, serverPublicKey)) continue;
            return;
        }
        for (byte[] key : this.certPins) {
            if (!Arrays.equals(key, serverCertificate)) continue;
            return;
        }
        throw new CertificateException("Neither certificate nor public key passed pinning validation");
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }
}

