/*
 * Decompiled with CFR 0.152.
 */
package ly.count.sdk.java.internal;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ly.count.sdk.java.User;
import ly.count.sdk.java.UserEditor;
import ly.count.sdk.java.internal.CoreFeature;
import ly.count.sdk.java.internal.Log;
import ly.count.sdk.java.internal.ModuleRequests;
import ly.count.sdk.java.internal.Params;
import ly.count.sdk.java.internal.SDKCore;
import ly.count.sdk.java.internal.Storage;
import ly.count.sdk.java.internal.UserImpl;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UserEditorImpl
implements UserEditor {
    private Log L = null;
    static final String NAME = "name";
    static final String USERNAME = "username";
    static final String EMAIL = "email";
    static final String ORG = "org";
    static final String PHONE = "phone";
    static final String PICTURE = "picture";
    public static final String PICTURE_PATH = "picturePath";
    public static final String PICTURE_IN_USER_PROFILE = "[CLY]_USER_PROFILE_PICTURE";
    static final String GENDER = "gender";
    static final String BIRTHYEAR = "byear";
    static final String LOCALE = "locale";
    static final String COUNTRY = "country";
    static final String CITY = "city";
    static final String LOCATION = "location";
    static final String CUSTOM = "custom";
    private final UserImpl user;
    private final Map<String, Object> sets;
    private final List<Op> ops;
    private final List<String> cohortsToAdd;
    private final List<String> cohortsToRemove;

    UserEditorImpl(UserImpl user, Log logger) {
        this.L = logger;
        this.user = user;
        this.sets = new HashMap<String, Object>();
        this.ops = new ArrayList<Op>();
        this.cohortsToAdd = new ArrayList<String>();
        this.cohortsToRemove = new ArrayList<String>();
    }

    void perform(JSONObject changes, Set<String> cohortsAdded, Set<String> cohortsRemoved) throws JSONException {
        block34: for (String key : this.sets.keySet()) {
            Object value = this.sets.get(key);
            switch (key) {
                case "name": {
                    if (value == null || value instanceof String) {
                        this.user.name = (String)value;
                    } else {
                        this.L.w("user.name will be cast to String");
                        this.user.name = value.toString();
                    }
                    changes.put(NAME, value == null ? JSONObject.NULL : this.user.name);
                    break;
                }
                case "username": {
                    if (value == null || value instanceof String) {
                        this.user.username = (String)value;
                    } else {
                        this.L.w("user.username will be cast to String");
                        this.user.username = value.toString();
                    }
                    changes.put(USERNAME, value == null ? JSONObject.NULL : this.user.username);
                    break;
                }
                case "email": {
                    if (value == null || value instanceof String) {
                        this.user.email = (String)value;
                    } else {
                        this.L.w("user.email will be cast to String");
                        this.user.email = value.toString();
                    }
                    changes.put(EMAIL, value == null ? JSONObject.NULL : this.user.email);
                    break;
                }
                case "org": {
                    if (value == null || value instanceof String) {
                        this.user.org = (String)value;
                    } else {
                        this.L.w("user.org will be cast to String");
                        this.user.org = value.toString();
                    }
                    changes.put(ORG, value == null ? JSONObject.NULL : this.user.org);
                    break;
                }
                case "phone": {
                    if (value == null || value instanceof String) {
                        this.user.phone = (String)value;
                    } else {
                        this.L.w("user.phone will be cast to String");
                        this.user.phone = value.toString();
                    }
                    changes.put(PHONE, value == null ? JSONObject.NULL : this.user.phone);
                    break;
                }
                case "picture": {
                    if (value == null) {
                        this.user.picture = null;
                        this.user.picturePath = null;
                        changes.put(PICTURE_PATH, JSONObject.NULL);
                        break;
                    }
                    if (value instanceof byte[]) {
                        this.user.picture = (byte[])value;
                        changes.put(PICTURE_PATH, (Object)PICTURE_IN_USER_PROFILE);
                        break;
                    }
                    this.L.e("[UserEditorImpl Won't set user picture (must be of type byte[])");
                    break;
                }
                case "picturePath": {
                    if (value == null) {
                        this.user.picture = null;
                        this.user.picturePath = null;
                        changes.put(PICTURE_PATH, JSONObject.NULL);
                        break;
                    }
                    if (value instanceof String) {
                        try {
                            this.user.picturePath = new URI((String)value).toString();
                            changes.put(PICTURE_PATH, (Object)this.user.picturePath);
                        }
                        catch (URISyntaxException e) {
                            this.L.e("[UserEditorImpl Supplied picturePath is not parsable to java.net.URI");
                        }
                        break;
                    }
                    this.L.e("[UserEditorImpl Won't set user picturePath (must be String or null)");
                    break;
                }
                case "gender": {
                    if (value == null || value instanceof User.Gender) {
                        this.user.gender = (User.Gender)((Object)value);
                        changes.put(GENDER, this.user.gender == null ? JSONObject.NULL : this.user.gender.toString());
                        break;
                    }
                    if (value instanceof String) {
                        User.Gender gender = User.Gender.fromString((String)value);
                        if (gender == null) {
                            this.L.e("[UserEditorImpl Cannot parse gender string: " + value + " (must be one of 'F' & 'M')");
                            break;
                        }
                        this.user.gender = gender;
                        changes.put(GENDER, (Object)this.user.gender.toString());
                        break;
                    }
                    this.L.e("[UserEditorImpl Won't set user gender (must be of type User.Gender or one of following Strings: 'F', 'M')");
                    break;
                }
                case "byear": {
                    if (value == null || value instanceof Integer) {
                        this.user.birthyear = (Integer)value;
                        changes.put(BIRTHYEAR, value == null ? JSONObject.NULL : this.user.birthyear);
                        break;
                    }
                    if (value instanceof String) {
                        try {
                            this.user.birthyear = Integer.parseInt((String)value);
                            changes.put(BIRTHYEAR, (Object)this.user.birthyear);
                        }
                        catch (NumberFormatException e) {
                            this.L.e("[UserEditorImpl user.birthyear must be either Integer or String which can be parsed to Integer" + e);
                        }
                        break;
                    }
                    this.L.e("[UserEditorImpl Won't set user birthyear (must be of type Integer or String which can be parsed to Integer)");
                    break;
                }
                case "locale": {
                    if (value != null && !(value instanceof String)) continue block34;
                    this.user.locale = (String)value;
                    changes.put(LOCALE, value == null ? JSONObject.NULL : this.user.locale);
                    break;
                }
                case "country": {
                    if (value != null && !(value instanceof String)) continue block34;
                    this.user.country = (String)value;
                    changes.put(COUNTRY, value == null ? JSONObject.NULL : this.user.country);
                    break;
                }
                case "city": {
                    if (value != null && !(value instanceof String)) continue block34;
                    this.user.city = (String)value;
                    changes.put(CITY, value == null ? JSONObject.NULL : this.user.city);
                    break;
                }
                case "location": {
                    if (value != null && !(value instanceof String)) continue block34;
                    this.user.location = (String)value;
                    changes.put(LOCATION, value == null ? JSONObject.NULL : this.user.location);
                    break;
                }
                default: {
                    if (value == null || value instanceof String || value instanceof Integer || value instanceof Float || value instanceof Double || value instanceof Boolean || value instanceof String[] || value instanceof Integer[] || value instanceof Float[] || value instanceof Double[] || value instanceof Boolean[] || value instanceof Object[]) {
                        if (!changes.has(CUSTOM)) {
                            changes.put(CUSTOM, (Object)new JSONObject());
                        }
                        changes.getJSONObject(CUSTOM).put(key, value);
                        if (value == null) {
                            this.user.custom.remove(key);
                            break;
                        }
                        this.user.custom.put(key, value);
                        break;
                    }
                    this.L.e("[UserEditorImpl Type of value " + value + " '" + value.getClass().getSimpleName() + "' is not supported yet, thus user property is not stored");
                }
            }
        }
        if (this.ops.size() > 0 && !changes.has(CUSTOM)) {
            changes.put(CUSTOM, (Object)new JSONObject());
        }
        for (Op op : this.ops) {
            op.apply(changes.getJSONObject(CUSTOM));
            op.apply(this.user.custom);
        }
        this.user.cohorts.addAll(this.cohortsToAdd);
        this.user.cohorts.removeAll(this.cohortsToRemove);
        cohortsAdded.addAll(this.cohortsToAdd);
        cohortsRemoved.addAll(this.cohortsToRemove);
    }

    @Override
    public UserEditor set(String key, Object value) {
        this.sets.put(key, value);
        return this;
    }

    @Override
    public UserEditor setCustom(String key, Object value) {
        if (!this.sets.containsKey(CUSTOM)) {
            this.sets.put(CUSTOM, new HashMap());
        }
        Map custom = (Map)this.sets.get(CUSTOM);
        custom.put(key, value);
        return this;
    }

    private UserEditor setCustomOp(String op, String key, Object value) {
        this.ops.add(new Op(op, key, value));
        return this;
    }

    @Override
    public UserEditor setName(String value) {
        this.L.d("setName: value = " + value);
        return this.set(NAME, value);
    }

    @Override
    public UserEditor setUsername(String value) {
        this.L.d("setUsername: value = " + value);
        return this.set(USERNAME, value);
    }

    @Override
    public UserEditor setEmail(String value) {
        this.L.d("setEmail: value = " + value);
        return this.set(EMAIL, value);
    }

    @Override
    public UserEditor setOrg(String value) {
        this.L.d("setOrg: value = " + value);
        return this.set(ORG, value);
    }

    @Override
    public UserEditor setPhone(String value) {
        this.L.d("setPhone: value = " + value);
        return this.set(PHONE, value);
    }

    @Override
    public UserEditor setPicture(byte[] picture) {
        this.L.d("setPicture: picture = " + picture);
        return this.set(PICTURE, picture);
    }

    @Override
    public UserEditor setPicturePath(String picturePath) {
        this.L.d("setPicturePath: picturePath = " + picturePath);
        return this.set(PICTURE_PATH, picturePath);
    }

    @Override
    public UserEditor setGender(Object gender) {
        this.L.d("setGender: gender = " + gender);
        return this.set(GENDER, gender);
    }

    @Override
    public UserEditor setBirthyear(int birthyear) {
        this.L.d("setBirthyear: birthyear = " + birthyear);
        return this.set(BIRTHYEAR, birthyear);
    }

    @Override
    public UserEditor setBirthyear(String birthyear) {
        this.L.d("setBirthyear: birthyear = " + birthyear);
        return this.set(BIRTHYEAR, birthyear);
    }

    @Override
    public UserEditor setLocale(String locale) {
        this.L.d("setLocale: locale = " + locale);
        return this.set(LOCALE, locale);
    }

    @Override
    public UserEditor setCountry(String country) {
        this.L.d("setCountry: country = " + country);
        if (SDKCore.enabled(CoreFeature.Location)) {
            return this.set(COUNTRY, country);
        }
        return this;
    }

    @Override
    public UserEditor setCity(String city) {
        this.L.d("setCity: city = " + city);
        if (SDKCore.enabled(CoreFeature.Location)) {
            return this.set(CITY, city);
        }
        return this;
    }

    @Override
    public UserEditor setLocation(String location) {
        this.L.d("setLocation: location = " + location);
        if (location != null) {
            String[] comps = location.split(",");
            if (comps.length == 2) {
                try {
                    return this.set(LOCATION, Double.valueOf(comps[0]) + "," + Double.valueOf(comps[1]));
                }
                catch (Throwable t) {
                    this.L.e("[UserEditorImpl Invalid location format: " + location + " " + t);
                    return this;
                }
            }
            this.L.e("[UserEditorImpl Invalid location format: " + location);
            return this;
        }
        return this.set(LOCATION, null);
    }

    @Override
    public UserEditor setLocation(double latitude, double longitude) {
        this.L.d("setLocation: latitude = " + latitude + " longitude" + longitude);
        if (SDKCore.enabled(CoreFeature.Location)) {
            return this.set(LOCATION, latitude + "," + longitude);
        }
        return this;
    }

    @Override
    public UserEditor optOutFromLocationServices() {
        this.L.d("optOutFromLocationServices");
        return this.set(COUNTRY, "").set(CITY, "").set(LOCATION, "");
    }

    @Override
    public UserEditor inc(String key, int by) {
        this.L.d("inc: key " + key + " by " + by);
        return this.setCustomOp("$inc", key, by);
    }

    @Override
    public UserEditor mul(String key, double by) {
        this.L.d("mul: key " + key + " by " + by);
        return this.setCustomOp("$mul", key, by);
    }

    @Override
    public UserEditor min(String key, double value) {
        this.L.d("min: key " + key + " value " + value);
        return this.setCustomOp("$min", key, value);
    }

    @Override
    public UserEditor max(String key, double value) {
        this.L.d("max: key " + key + " value " + value);
        return this.setCustomOp("$max", key, value);
    }

    @Override
    public UserEditor setOnce(String key, Object value) {
        this.L.d("setOnce: key " + key + " value " + value);
        if (value == null) {
            this.L.e("[UserEditorImpl $setOnce operation operand cannot be null: key " + key);
            return this;
        }
        return this.setCustomOp("$setOnce", key, value);
    }

    @Override
    public UserEditor pull(String key, Object value) {
        this.L.d("pull: key " + key + " value " + value);
        if (value == null) {
            this.L.e("[UserEditorImpl $pull operation operand cannot be null: key " + key);
            return this;
        }
        return this.setCustomOp("$pull", key, value);
    }

    @Override
    public UserEditor push(String key, Object value) {
        this.L.d("push: key " + key + " value " + value);
        if (value == null) {
            this.L.e("[UserEditorImpl $push operation operand cannot be null: key " + key);
            return this;
        }
        return this.setCustomOp("$push", key, value);
    }

    @Override
    public UserEditor pushUnique(String key, Object value) {
        this.L.d("pushUnique: key " + key + " value " + value);
        if (value == null) {
            this.L.e("[UserEditorImpl pushUnique / $addToSet operation operand cannot be null: key " + key);
            return this;
        }
        return this.setCustomOp("$addToSet", key, value);
    }

    @Override
    public UserEditor addToCohort(String key) {
        this.L.d("addToCohort: key " + key);
        if (this.cohortsToRemove.contains(key)) {
            this.cohortsToRemove.remove(key);
        }
        this.cohortsToAdd.add(key);
        return this;
    }

    @Override
    public UserEditor removeFromCohort(String key) {
        this.L.d("removeFromCohort: key " + key);
        if (this.cohortsToAdd.contains(key)) {
            this.cohortsToAdd.remove(key);
        }
        this.cohortsToRemove.add(key);
        return this;
    }

    @Override
    public User commit() {
        this.L.d("commit");
        if (SDKCore.instance == null) {
            this.L.e("[UserEditorImpl Countly is not initialized");
            return null;
        }
        if (SDKCore.instance != null && SDKCore.instance.config.isBackendModeEnabled()) {
            this.L.w("commit: Skipping user detail, backend mode is enabled!");
            return null;
        }
        try {
            final JSONObject changes = new JSONObject();
            final HashSet<String> cohortsAdded = new HashSet<String>();
            final HashSet<String> cohortsRemoved = new HashSet<String>();
            this.perform(changes, cohortsAdded, cohortsRemoved);
            Storage.push(this.user.ctx, this.user);
            ModuleRequests.injectParams(this.user.ctx, new ModuleRequests.ParamsInjector(){

                @Override
                public void call(Params params) {
                    params.add("user_details", (Object)changes.toString());
                    if (changes.has(UserEditorImpl.PICTURE_PATH)) {
                        try {
                            params.add(UserEditorImpl.PICTURE_PATH, (Object)changes.getString(UserEditorImpl.PICTURE_PATH));
                        }
                        catch (JSONException e) {
                            UserEditorImpl.this.L.w("Won't send picturePath" + (Object)((Object)e));
                        }
                    }
                    if (cohortsAdded.size() > 0) {
                        params.add("add_cohorts", (Object)new JSONArray((Collection)cohortsAdded).toString());
                    }
                    if (cohortsRemoved.size() > 0) {
                        params.add("remove_cohorts", (Object)new JSONArray((Collection)cohortsRemoved).toString());
                    }
                    if (changes.has(UserEditorImpl.LOCALE) && ((UserEditorImpl)UserEditorImpl.this).user.locale != null) {
                        params.add(UserEditorImpl.LOCALE, (Object)((UserEditorImpl)UserEditorImpl.this).user.locale);
                    }
                    if (changes.has(UserEditorImpl.COUNTRY) && ((UserEditorImpl)UserEditorImpl.this).user.country != null) {
                        params.add("country_code", (Object)((UserEditorImpl)UserEditorImpl.this).user.country);
                    }
                    if (changes.has(UserEditorImpl.CITY) && ((UserEditorImpl)UserEditorImpl.this).user.city != null) {
                        params.add(UserEditorImpl.CITY, (Object)((UserEditorImpl)UserEditorImpl.this).user.city);
                    }
                    if (changes.has(UserEditorImpl.LOCATION) && ((UserEditorImpl)UserEditorImpl.this).user.location != null) {
                        params.add(UserEditorImpl.LOCATION, (Object)((UserEditorImpl)UserEditorImpl.this).user.location);
                    }
                }
            });
            SDKCore.instance.onUserChanged(this.user.ctx, changes, cohortsAdded, cohortsRemoved);
        }
        catch (JSONException e) {
            this.L.e("[UserEditorImpl Exception while committing changes to User profile" + (Object)((Object)e));
        }
        this.sets.clear();
        this.ops.clear();
        this.cohortsToAdd.clear();
        this.cohortsToRemove.clear();
        return this.user;
    }

    static class Op {
        static final String INC = "$inc";
        static final String MUL = "$mul";
        static final String MIN = "$min";
        static final String MAX = "$max";
        static final String SET_ONCE = "$setOnce";
        static final String PULL = "$pull";
        static final String PUSH = "$push";
        static final String PUSH_UNIQUE = "$addToSet";
        final String op;
        final String key;
        final Object value;

        Op(String op, String key, Object value) {
            this.op = op;
            this.key = key;
            this.value = value;
        }

        public void apply(Map<String, Object> custom) {
        }

        public void apply(JSONObject json) throws JSONException {
            switch (this.op) {
                case "$inc": 
                case "$mul": {
                    JSONObject object = json.optJSONObject(this.key);
                    if (object == null) {
                        object = new JSONObject();
                    }
                    if (this.op.equals(INC)) {
                        int n = object.optInt(this.op, 0);
                        object.put(this.op, n + (Integer)this.value);
                    } else {
                        double n = object.optDouble(this.op, 1.0);
                        object.put(this.op, n * (Double)this.value);
                    }
                    json.put(this.key, (Object)object);
                    break;
                }
                case "$min": 
                case "$max": {
                    JSONObject object = json.optJSONObject(this.key);
                    if (object == null) {
                        object = new JSONObject();
                    }
                    if (object.has(this.op)) {
                        object.put(this.op, this.op.equals(MIN) ? Math.min(object.getDouble(this.op), (Double)this.value) : Math.max(object.getDouble(this.op), (Double)this.value));
                    } else {
                        object.put(this.op, this.value);
                    }
                    json.put(this.key, (Object)object);
                    break;
                }
                case "$setOnce": {
                    JSONObject object = json.optJSONObject(this.key);
                    if (object == null) {
                        object = new JSONObject();
                    }
                    object.put(this.op, this.value);
                    json.put(this.key, (Object)object);
                    break;
                }
                case "$pull": 
                case "$push": 
                case "$addToSet": {
                    JSONObject object = json.optJSONObject(this.key);
                    if (object == null) {
                        object = new JSONObject();
                    }
                    object.accumulate(this.op, this.value);
                    json.put(this.key, (Object)object);
                }
            }
        }
    }
}

