/*
 * Decompiled with CFR 0.152.
 */
package ly.count.sdk.java.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ly.count.sdk.java.User;
import ly.count.sdk.java.UserEditor;
import ly.count.sdk.java.internal.CtxCore;
import ly.count.sdk.java.internal.Log;
import ly.count.sdk.java.internal.Storable;
import ly.count.sdk.java.internal.UserEditorImpl;

public class UserImpl
extends User
implements Storable {
    private Log L = null;
    String id;
    String name;
    String username;
    String email;
    String org;
    String phone;
    String picturePath;
    String locale;
    String country;
    String city;
    String location;
    byte[] picture;
    User.Gender gender;
    Integer birthyear;
    Set<String> cohorts;
    Map<String, Object> custom;
    CtxCore ctx;

    public UserImpl(CtxCore ctx) {
        this.L = ctx.getLogger();
        this.ctx = ctx;
        this.custom = new HashMap<String, Object>();
        this.cohorts = new HashSet<String>();
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String username() {
        return this.username;
    }

    @Override
    public String email() {
        return this.email;
    }

    @Override
    public String org() {
        return this.org;
    }

    @Override
    public String phone() {
        return this.phone;
    }

    @Override
    public byte[] picture() {
        return this.picture;
    }

    @Override
    public String picturePath() {
        return this.picturePath;
    }

    @Override
    public User.Gender gender() {
        return this.gender;
    }

    @Override
    public String locale() {
        return this.locale;
    }

    @Override
    public Integer birthyear() {
        return this.birthyear;
    }

    @Override
    public String country() {
        return this.country;
    }

    @Override
    public String city() {
        return this.city;
    }

    @Override
    public String location() {
        return this.location;
    }

    @Override
    public Set<String> cohorts() {
        return this.cohorts;
    }

    @Override
    public Map<String, Object> custom() {
        return this.custom;
    }

    @Override
    public UserEditor edit() {
        return new UserEditorImpl(this, this.L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] store(Log L) {
        ByteArrayOutputStream bytes = null;
        ObjectOutputStream stream = null;
        try {
            bytes = new ByteArrayOutputStream();
            stream = new ObjectOutputStream(bytes);
            stream.writeObject(this.name);
            stream.writeObject(this.username);
            stream.writeObject(this.email);
            stream.writeObject(this.org);
            stream.writeObject(this.phone);
            stream.writeInt(this.picture == null ? 0 : this.picture.length);
            if (this.picture != null) {
                stream.write(this.picture);
            }
            stream.writeObject(this.picturePath);
            stream.writeObject(this.gender == null ? null : this.gender.toString());
            stream.writeInt(this.birthyear == null ? -1 : this.birthyear);
            stream.writeObject(this.locale);
            stream.writeObject(this.country);
            stream.writeObject(this.city);
            stream.writeObject(this.location);
            stream.writeObject(this.cohorts == null || this.cohorts.size() == 0 ? null : this.cohorts);
            stream.writeObject(this.custom);
            stream.close();
            byte[] byArray = bytes.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            if (L != null) {
                L.e("[UserImpl Cannot serialize session" + e);
            }
        }
        finally {
            block23: {
                block22: {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException e) {
                            if (L == null) break block22;
                            L.e("[UserImpl Cannot happen" + e);
                        }
                    }
                }
                if (bytes != null) {
                    try {
                        bytes.close();
                    }
                    catch (IOException e) {
                        if (L == null) break block23;
                        L.e("[UserImpl Cannot happen" + e);
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean restore(byte[] data, Log L) {
        ByteArrayInputStream bytes = null;
        ObjectInputStream stream = null;
        try {
            int y;
            bytes = new ByteArrayInputStream(data);
            stream = new ObjectInputStream(bytes);
            this.name = (String)stream.readObject();
            this.username = (String)stream.readObject();
            this.email = (String)stream.readObject();
            this.org = (String)stream.readObject();
            this.phone = (String)stream.readObject();
            int picLength = stream.readInt();
            if (picLength != 0) {
                this.picture = new byte[picLength];
                stream.readFully(this.picture);
            }
            this.picturePath = (String)stream.readObject();
            String g = (String)stream.readObject();
            if (g != null) {
                this.gender = User.Gender.fromString(g);
            }
            if ((y = stream.readInt()) != -1) {
                this.birthyear = y;
            }
            this.locale = (String)stream.readObject();
            this.country = (String)stream.readObject();
            this.city = (String)stream.readObject();
            this.location = (String)stream.readObject();
            this.cohorts = (Set)stream.readObject();
            this.cohorts = this.cohorts == null ? new HashSet() : this.cohorts;
            this.custom = (Map)stream.readObject();
            if (this.custom == null) {
                this.custom = new HashMap<String, Object>();
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException | ClassNotFoundException e) {
            if (L != null) {
                L.e("[UserImpl Cannot deserialize session" + e);
            }
        }
        finally {
            block26: {
                block25: {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException e) {
                            if (L == null) break block25;
                            L.e("[UserImpl Cannot happen" + e);
                        }
                    }
                }
                if (bytes != null) {
                    try {
                        bytes.close();
                    }
                    catch (IOException e) {
                        if (L == null) break block26;
                        L.e("[UserImpl Cannot happen" + e);
                    }
                }
            }
        }
        return false;
    }

    public String toString() {
        return "UserImpl{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", username='" + this.username + '\'' + " + email='" + this.email + '\'' + ", org='" + this.org + '\'' + ", phone='" + this.phone + '\'' + ", picturePath='" + this.picturePath + '\'' + ", locale='" + this.locale + '\'' + ", country='" + this.country + '\'' + ", city='" + this.city + '\'' + ", location='" + this.location + '\'' + ", picture=" + Arrays.toString(this.picture) + ", gender=" + (Object)((Object)this.gender) + ", birthyear=" + this.birthyear + ", cohorts=" + this.cohorts + ", custom=" + this.custom + ", ctx=" + this.ctx + '}';
    }

    @Override
    public Long storageId() {
        return 0L;
    }

    @Override
    public String storagePrefix() {
        return "user";
    }
}

