/*
 * Decompiled with CFR 0.152.
 */
package ly.count.sdk.java.internal;

import ly.count.sdk.java.Session;
import ly.count.sdk.java.View;
import ly.count.sdk.java.internal.Device;
import ly.count.sdk.java.internal.EventImpl;
import ly.count.sdk.java.internal.Log;
import ly.count.sdk.java.internal.SDKCore;

class ViewImpl
implements View {
    private Log L = null;
    static final String EVENT = "[CLY]_view";
    static final String NAME = "name";
    static final String VISIT = "visit";
    static final String VISIT_VALUE = "1";
    static final String SEGMENT = "segment";
    static final String SEGMENT_VALUE = System.getProperty("os.name");
    static final String START = "start";
    static final String START_VALUE = "1";
    static final String EXIT = "exit";
    static final String EXIT_VALUE = "1";
    static final String BOUNCE = "bounce";
    static final String BOUNCE_VALUE = "1";
    private String name;
    private Session session;
    private EventImpl start;
    private boolean firstView;
    private boolean started;
    private boolean ended;

    ViewImpl(Session session, String name, Log logger) {
        this.L = logger;
        this.name = name;
        this.session = session;
    }

    @Override
    public void start(boolean firstView) {
        if (SDKCore.instance != null && SDKCore.instance.config.isBackendModeEnabled()) {
            this.L.w("[ViewImpl] start: Skipping view, backend mode is enabled!");
            return;
        }
        this.L.d("[ViewImpl] start: firstView = " + firstView);
        if (this.started) {
            return;
        }
        this.started = true;
        this.firstView = firstView;
        this.start = (EventImpl)this.session.event(EVENT).addSegments(NAME, this.name, VISIT, "1", SEGMENT, Device.dev.getOS());
        if (firstView) {
            this.start.addSegment(START, "1");
        }
        this.start.record();
    }

    @Override
    public void stop(boolean lastView) {
        if (SDKCore.instance != null && SDKCore.instance.config.isBackendModeEnabled()) {
            this.L.w("[ViewImpl] stop: Skipping view, backend mode is enabled!");
            return;
        }
        if (this.start == null) {
            this.L.e("[ViewImpl] stop: We are trying to end a view that has not been started.");
            return;
        }
        this.L.d("[ViewImpl] stop: lastView = " + lastView);
        if (this.ended) {
            return;
        }
        this.ended = true;
        EventImpl event = (EventImpl)this.session.event(EVENT).addSegments(NAME, this.name, SEGMENT, SEGMENT_VALUE);
        long startTs = Device.dev.uniqueTimestamp();
        long endTs = this.start.getTimestamp();
        long viewDurationSeconds = (startTs - endTs) / 1000L;
        event.setDuration(viewDurationSeconds);
        if (lastView) {
            event.addSegment(EXIT, "1");
        }
        if (lastView && this.firstView) {
            event.addSegment(BOUNCE, "1");
        }
        event.record();
    }

    public String toString() {
        return "ViewImpl{name='" + this.name + '\'' + ", session=" + this.session + ", start=" + this.start + ", firstView=" + this.firstView + ", started=" + this.started + ", ended=" + this.ended + '}';
    }
}

