/*
 * Decompiled with CFR 0.152.
 */
package me.chenzz.java.script.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class ShellUtil {
    private static String path = null;
    private static String[] envArr = null;
    private static final Map<String, String> envMap = new HashMap<String, String>();

    public static void configEnvp(String[] envArrOfExplicitSpecify) {
        String output = ShellUtil.execAndGetStdOutput("env");
        String[] envArrOfOrigin = output.split("\n");
        ArrayList<String> mergedEnvList = new ArrayList<String>(Arrays.asList(envArrOfOrigin));
        mergedEnvList.addAll(Arrays.asList(envArrOfExplicitSpecify));
        for (String env : envArr = mergedEnvList.toArray(new String[0])) {
            String[] kvArr = env.split("=");
            envMap.put(kvArr[0], kvArr[1]);
        }
    }

    public static void configPath(String path) {
        ShellUtil.path = path;
    }

    public static void exec(String cmd) {
        ShellUtil.exec(cmd, StdOutputStrategyEnum.PRINT);
    }

    public static void exec(String ... cmdArr) {
        ShellUtil.exec(cmdArr, StdOutputStrategyEnum.PRINT);
    }

    public static String execAndGetStdOutput(String cmd) {
        return ShellUtil.exec(cmd, StdOutputStrategyEnum.RETURN);
    }

    public static String execAndGetStdOutput(String ... cmdArr) {
        return ShellUtil.exec(cmdArr, StdOutputStrategyEnum.RETURN);
    }

    private static String exec(String cmd, StdOutputStrategyEnum stdOutputStrategyEnum) {
        return ShellUtil.exec(new String[]{cmd}, stdOutputStrategyEnum);
    }

    private static String exec(String[] cmdArr, StdOutputStrategyEnum stdOutputStrategyEnum) {
        String errorOutput;
        int exitCode;
        if (null == cmdArr || 0 == cmdArr.length) {
            throw new RuntimeException("cmdArr should not null");
        }
        System.out.println("============= \u6267\u884c\u547d\u4ee4 \u5f00\u59cb\uff1a " + Arrays.toString(cmdArr));
        if (null == stdOutputStrategyEnum) {
            stdOutputStrategyEnum = StdOutputStrategyEnum.PRINT;
        }
        File file = null;
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            file = new File(path);
        }
        Process process = Runtime.getRuntime().exec(cmdArr, envArr, file);
        String normalOutput = null;
        if (StdOutputStrategyEnum.PRINT == stdOutputStrategyEnum) {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
            }
        } else {
            normalOutput = IOUtils.toString((InputStream)process.getInputStream());
        }
        if (0 != (exitCode = process.waitFor())) {
            System.out.println("=== \u7a0b\u5e8f\u9000\u51fa\u7801");
            System.out.println("exitCode=" + exitCode);
        }
        if (StringUtils.isNotEmpty((CharSequence)(errorOutput = IOUtils.toString((InputStream)process.getErrorStream())))) {
            System.out.println("=== \u6ce8\u610f\uff1a\u9519\u8bef\u8f93\u51fa");
            System.out.println(errorOutput);
        }
        System.out.println("============= \u6267\u884c\u547d\u4ee4 \u7ed3\u675f");
        System.out.println();
        return normalOutput;
    }

    static enum StdOutputStrategyEnum {
        PRINT,
        RETURN;

    }
}

