/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment;

import java.io.File;
import java.time.Duration;
import java.util.Optional;
import lombok.NonNull;
import ml.comet.experiment.BaseExperiment;
import ml.comet.experiment.builder.ApiExperimentBuilder;
import ml.comet.experiment.config.CometConfig;
import ml.comet.experiment.http.Connection;
import ml.comet.experiment.http.ConnectionInitializer;
import ml.comet.experiment.utils.CometUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApiExperiment
extends BaseExperiment {
    private final String baseUrl;
    private final String experimentKey;
    private final Duration cleaningTimeout;
    private final Connection connection;
    private Logger logger = LoggerFactory.getLogger(ApiExperiment.class);

    private ApiExperiment(String apiKey, String anExperimentKey, Logger logger, String baseUrl, int maxAuthRetries, Duration cleaningTimeout) {
        this.experimentKey = anExperimentKey;
        this.baseUrl = baseUrl;
        this.cleaningTimeout = cleaningTimeout;
        if (logger != null) {
            this.logger = logger;
        }
        this.connection = ConnectionInitializer.initConnection(apiKey, this.baseUrl, maxAuthRetries, this.logger);
        CometUtils.printCometSdkVersion();
    }

    public static ApiExperimentBuilderImpl builder(@NonNull String experimentKey) {
        if (experimentKey == null) {
            throw new NullPointerException("experimentKey is marked non-null but is null");
        }
        return new ApiExperimentBuilderImpl(experimentKey);
    }

    @Override
    protected Connection getConnection() {
        return this.connection;
    }

    @Override
    protected Logger getLogger() {
        return this.logger;
    }

    @Override
    public String getContext() {
        return "";
    }

    @Override
    public String getWorkspaceName() {
        return this.getMetadata().getWorkspaceName();
    }

    @Override
    public String getProjectName() {
        return this.getMetadata().getProjectName();
    }

    @Override
    public String getExperimentName() {
        return this.getMetadata().getExperimentName();
    }

    @Override
    public void end() {
        super.end(this.cleaningTimeout);
    }

    @Override
    public String getExperimentKey() {
        return this.experimentKey;
    }

    @Override
    public Optional<String> getExperimentLink() {
        if (StringUtils.isEmpty((CharSequence)this.experimentKey)) {
            return Optional.empty();
        }
        try {
            return Optional.of(CometUtils.createExperimentLink(this.baseUrl, this.getWorkspaceName(), this.getProjectName(), this.experimentKey));
        }
        catch (Exception ex) {
            this.logger.error("failed to build experiment link", (Throwable)ex);
            return Optional.empty();
        }
    }

    public static final class ApiExperimentBuilderImpl
    implements ApiExperimentBuilder {
        private final String experimentKey;
        private String apiKey;
        private Logger logger;

        private ApiExperimentBuilderImpl(String anExperimentKey) {
            this.experimentKey = anExperimentKey;
        }

        public ApiExperimentBuilderImpl withApiKey(@NonNull String anApiKey) {
            if (anApiKey == null) {
                throw new NullPointerException("anApiKey is marked non-null but is null");
            }
            this.apiKey = anApiKey;
            return this;
        }

        public ApiExperimentBuilderImpl withLogger(@NonNull Logger logger) {
            if (logger == null) {
                throw new NullPointerException("logger is marked non-null but is null");
            }
            this.logger = logger;
            return this;
        }

        public ApiExperimentBuilderImpl withConfigOverride(@NonNull File overrideConfig) {
            if (overrideConfig == null) {
                throw new NullPointerException("overrideConfig is marked non-null but is null");
            }
            CometConfig.applyConfigOverride(overrideConfig);
            return this;
        }

        @Override
        public ApiExperiment build() {
            if (StringUtils.isEmpty((CharSequence)this.apiKey)) {
                this.apiKey = CometConfig.COMET_API_KEY.getString();
            }
            return new ApiExperiment(this.apiKey, this.experimentKey, this.logger, CometConfig.COMET_BASE_URL.getString(), CometConfig.COMET_MAX_AUTH_RETRIES.getInt(), CometConfig.COMET_TIMEOUT_CLEANING_SECONDS.getDuration());
        }
    }
}

