/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import ml.comet.experiment.CometApi;
import ml.comet.experiment.builder.BaseCometBuilder;
import ml.comet.experiment.builder.CometApiBuilder;
import ml.comet.experiment.config.CometConfig;
import ml.comet.experiment.constants.QueryParamName;
import ml.comet.experiment.http.Connection;
import ml.comet.experiment.http.ConnectionInitializer;
import ml.comet.experiment.model.ExperimentMetadataRest;
import ml.comet.experiment.model.GetExperimentsResponse;
import ml.comet.experiment.model.GetProjectsResponse;
import ml.comet.experiment.model.GetWorkspacesResponse;
import ml.comet.experiment.model.RestProject;
import ml.comet.experiment.utils.CometUtils;
import ml.comet.experiment.utils.JsonUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CometApiImpl
implements CometApi {
    private Logger logger = LoggerFactory.getLogger(CometApiImpl.class);
    private final Connection connection;

    CometApiImpl(@NonNull String apiKey, @NonNull String baseUrl, int maxAuthRetries, Logger logger) {
        if (apiKey == null) {
            throw new NullPointerException("apiKey is marked non-null but is null");
        }
        if (baseUrl == null) {
            throw new NullPointerException("baseUrl is marked non-null but is null");
        }
        if (logger != null) {
            this.logger = logger;
        }
        this.connection = ConnectionInitializer.initConnection(apiKey, baseUrl, maxAuthRetries, this.logger);
        CometUtils.printCometSdkVersion();
    }

    @Override
    public List<String> getAllWorkspaces() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getAllWorkspaces invoked");
        }
        GetWorkspacesResponse response = this.getObject("/api/rest/v2/workspaces", Collections.emptyMap(), GetWorkspacesResponse.class);
        return response.getWorkspaceNames();
    }

    @Override
    public List<RestProject> getAllProjects(@NonNull String workspaceName) {
        if (workspaceName == null) {
            throw new NullPointerException("workspaceName is marked non-null but is null");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getAllProjects invoked");
        }
        Map<QueryParamName, String> params = Collections.singletonMap(QueryParamName.WORKSPACE_NAME, workspaceName);
        GetProjectsResponse response = this.getObject("/api/rest/v2/projects", params, GetProjectsResponse.class);
        return response.getProjects();
    }

    @Override
    public List<ExperimentMetadataRest> getAllExperiments(@NonNull String projectId) {
        if (projectId == null) {
            throw new NullPointerException("projectId is marked non-null but is null");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getAllExperiments invoked");
        }
        Map<QueryParamName, String> params = Collections.singletonMap(QueryParamName.PROJECT_ID, projectId);
        GetExperimentsResponse response = this.getObject("/api/rest/v2/experiments", params, GetExperimentsResponse.class);
        return response.getExperiments();
    }

    @Override
    public void close() throws IOException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public static CometApiBuilder builder() {
        return new CometApiBuilderImpl();
    }

    private <T> T getObject(@NonNull String endpoint, @NonNull Map<QueryParamName, String> params, @NonNull Class<T> clazz) {
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return (T)this.connection.sendGet(endpoint, params).map(body -> JsonUtils.fromJson(body, clazz)).orElseThrow(() -> new IllegalArgumentException("Failed to parse endpoint response " + endpoint));
    }

    static final class CometApiBuilderImpl
    implements CometApiBuilder {
        private String apiKey;
        private Logger logger;

        CometApiBuilderImpl() {
        }

        public CometApiBuilder withConfigOverride(@NonNull File overrideConfig) {
            if (overrideConfig == null) {
                throw new NullPointerException("overrideConfig is marked non-null but is null");
            }
            CometConfig.applyConfigOverride(overrideConfig);
            return this;
        }

        @Override
        public BaseCometBuilder<CometApi> withLogger(@NonNull Logger logger) {
            if (logger == null) {
                throw new NullPointerException("logger is marked non-null but is null");
            }
            this.logger = logger;
            return this;
        }

        public CometApiBuilder withApiKey(@NonNull String apiKey) {
            if (apiKey == null) {
                throw new NullPointerException("apiKey is marked non-null but is null");
            }
            this.apiKey = apiKey;
            return this;
        }

        @Override
        public CometApi build() {
            if (StringUtils.isEmpty((CharSequence)this.apiKey)) {
                this.apiKey = CometConfig.COMET_API_KEY.getString();
            }
            return new CometApiImpl(this.apiKey, CometConfig.COMET_BASE_URL.getString(), CometConfig.COMET_MAX_AUTH_RETRIES.getInt(), this.logger);
        }
    }
}

