/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment;

import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.NonNull;
import ml.comet.experiment.BaseExperiment;
import ml.comet.experiment.OnlineExperiment;
import ml.comet.experiment.builder.OnlineExperimentBuilder;
import ml.comet.experiment.config.CometConfig;
import ml.comet.experiment.config.ConfigException;
import ml.comet.experiment.constants.QueryParamName;
import ml.comet.experiment.exception.CometGeneralException;
import ml.comet.experiment.http.Connection;
import ml.comet.experiment.http.ConnectionInitializer;
import ml.comet.experiment.log.StdOutLogger;
import ml.comet.experiment.model.CreateExperimentRequest;
import ml.comet.experiment.model.CreateExperimentResponse;
import ml.comet.experiment.model.OutputLine;
import ml.comet.experiment.model.OutputUpdate;
import ml.comet.experiment.utils.CometUtils;
import ml.comet.experiment.utils.JsonUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineExperimentImpl
extends BaseExperiment
implements OnlineExperiment {
    private static final int SCHEDULED_EXECUTOR_TERMINATION_WAIT_SEC = 60;
    private static final int STD_OUT_LOGGER_FLUSH_WAIT_DELAY_MS = 2000;
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
    private final String projectName;
    private final String workspaceName;
    private final String apiKey;
    private final String baseUrl;
    private final Duration cleaningTimeout;
    private Logger logger = LoggerFactory.getLogger(OnlineExperimentImpl.class);
    private Connection connection;
    private String experimentKey;
    private String experimentLink;
    private String experimentName;
    private StdOutLogger stdOutLogger;
    private StdOutLogger stdErrLogger;
    private boolean interceptStdout;
    private ScheduledFuture<?> heartbeatSendFuture;
    private long step;
    private long epoch;
    private String context = "";
    private final AtomicBoolean atShutdown = new AtomicBoolean();

    private OnlineExperimentImpl(String apiKey, String projectName, String workspaceName, String experimentName, String experimentKey, Logger logger, boolean interceptStdout, String baseUrl, int maxAuthRetries, Duration cleaningTimeout) {
        this.projectName = projectName;
        this.workspaceName = workspaceName;
        this.apiKey = apiKey;
        this.experimentName = experimentName;
        this.experimentKey = experimentKey;
        this.interceptStdout = interceptStdout;
        if (logger != null) {
            this.logger = logger;
        }
        this.baseUrl = baseUrl;
        this.cleaningTimeout = cleaningTimeout;
        this.initializeExperiment(maxAuthRetries);
    }

    public OnlineExperimentImpl() throws ConfigException {
        this.apiKey = CometConfig.COMET_API_KEY.getString();
        this.projectName = CometConfig.COMET_PROJECT_NAME.getString();
        this.workspaceName = CometConfig.COMET_WORKSPACE_NAME.getString();
        this.baseUrl = CometConfig.COMET_BASE_URL.getString();
        this.cleaningTimeout = CometConfig.COMET_TIMEOUT_CLEANING_SECONDS.getDuration();
        this.initializeExperiment(CometConfig.COMET_MAX_AUTH_RETRIES.getInt());
    }

    @Override
    public String getExperimentName() {
        return this.experimentName;
    }

    public static OnlineExperimentBuilderImpl builder() {
        return new OnlineExperimentBuilderImpl();
    }

    @Override
    protected Connection getConnection() {
        return this.connection;
    }

    @Override
    protected Logger getLogger() {
        return this.logger;
    }

    @Override
    public void end() {
        this.atShutdown.set(true);
        if (this.heartbeatSendFuture != null) {
            if (!this.heartbeatSendFuture.cancel(true)) {
                this.logger.error("failed to stop experiment's heartbeat sender");
            } else {
                this.logger.info("Experiment's heartbeat sender stopped");
            }
            this.heartbeatSendFuture = null;
        }
        this.scheduledExecutorService.shutdownNow();
        try {
            if (!this.scheduledExecutorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.logger.warn("scheduled executor failed to terminate");
            }
        }
        catch (InterruptedException e) {
            this.logger.error("scheduled executor's wait for termination was interrupted", (Throwable)e);
        }
        if (this.interceptStdout) {
            try {
                this.stopInterceptStdout();
            }
            catch (IOException e) {
                this.logger.error("failed to stop StdOut/StdErr intercepting", (Throwable)e);
            }
        }
        super.end(this.cleaningTimeout);
    }

    @Override
    public void setInterceptStdout() throws IOException {
        if (!this.interceptStdout) {
            this.interceptStdout = true;
            this.captureStdout();
        }
    }

    @Override
    public void stopInterceptStdout() throws IOException {
        if (this.stdOutLogger != null) {
            this.stopStdOutLogger(this.stdOutLogger, 2000L);
            this.stdOutLogger = null;
            this.interceptStdout = false;
        }
        if (this.stdErrLogger != null) {
            this.stopStdOutLogger(this.stdErrLogger, 0L);
            this.stdErrLogger = null;
        }
    }

    private void stopStdOutLogger(@NonNull StdOutLogger stdOutLogger, long delay) throws IOException {
        if (stdOutLogger == null) {
            throw new NullPointerException("stdOutLogger is marked non-null but is null");
        }
        stdOutLogger.flush();
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            this.logger.warn("interrupted while waiting for stdlogger to flush", (Throwable)e);
        }
        stdOutLogger.close();
    }

    @Override
    public void logLine(String line, long offset, boolean stderr) {
        if (this.getExperimentKey() == null) {
            return;
        }
        OutputUpdate outputUpdate = this.getLogLineRequest(line, offset, stderr);
        this.getConnection().sendPostAsync(outputUpdate, "/api/rest/v2/write/experiment/output");
    }

    @Override
    public void setStep(long step) {
        this.step = step;
    }

    @Override
    public void nextStep() {
        ++this.step;
    }

    @Override
    public long getStep() {
        return this.step;
    }

    @Override
    public void setEpoch(long epoch) {
        this.epoch = epoch;
    }

    @Override
    public void nextEpoch() {
        ++this.epoch;
    }

    @Override
    public long getEpoch() {
        return this.epoch;
    }

    @Override
    public void setContext(String context) {
        this.context = context;
    }

    @Override
    public String getContext() {
        return this.context;
    }

    @Override
    public String getExperimentKey() {
        return this.experimentKey;
    }

    @Override
    public Optional<String> getExperimentLink() {
        return Optional.ofNullable(this.experimentLink);
    }

    @Override
    public void logMetric(@NonNull String metricName, @NonNull Object metricValue, long step) {
        if (metricName == null) {
            throw new NullPointerException("metricName is marked non-null but is null");
        }
        if (metricValue == null) {
            throw new NullPointerException("metricValue is marked non-null but is null");
        }
        this.logMetric(metricName, metricValue, step, this.epoch);
    }

    @Override
    public void logMetric(@NonNull String metricName, @NonNull Object metricValue) {
        if (metricName == null) {
            throw new NullPointerException("metricName is marked non-null but is null");
        }
        if (metricValue == null) {
            throw new NullPointerException("metricValue is marked non-null but is null");
        }
        this.logMetric(metricName, metricValue, this.step, this.epoch);
    }

    @Override
    public void logMetric(@NonNull String metricName, @NonNull Object metricValue, long step, long epoch) {
        if (metricName == null) {
            throw new NullPointerException("metricName is marked non-null but is null");
        }
        if (metricValue == null) {
            throw new NullPointerException("metricValue is marked non-null but is null");
        }
        this.setStep(step);
        this.setEpoch(epoch);
        super.logMetric(metricName, metricValue, step, epoch);
    }

    @Override
    public void logParameter(@NonNull String parameterName, @NonNull Object paramValue) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName is marked non-null but is null");
        }
        if (paramValue == null) {
            throw new NullPointerException("paramValue is marked non-null but is null");
        }
        this.logParameter(parameterName, paramValue, this.step);
    }

    @Override
    public void logParameter(@NonNull String parameterName, @NonNull Object paramValue, long step) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName is marked non-null but is null");
        }
        if (paramValue == null) {
            throw new NullPointerException("paramValue is marked non-null but is null");
        }
        this.setStep(step);
        super.logParameter(parameterName, paramValue, step);
    }

    @Override
    public void uploadAsset(@NonNull File asset, @NonNull String fileName, boolean overwrite, long step) {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        super.uploadAsset(asset, fileName, overwrite, step, this.epoch);
    }

    @Override
    public void uploadAsset(@NonNull File asset, boolean overwrite) {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        this.uploadAsset(asset, asset.getName(), overwrite);
    }

    @Override
    public void uploadAsset(@NonNull File asset, @NonNull String fileName, boolean overwrite) {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        super.uploadAsset(asset, fileName, overwrite, this.step, this.epoch);
    }

    private void initializeExperiment(int maxAuthRetries) {
        CometUtils.printCometSdkVersion();
        this.validateInitialParams();
        this.connection = ConnectionInitializer.initConnection(this.apiKey, this.baseUrl, maxAuthRetries, this.logger);
        this.setupStdOutIntercept();
        this.registerExperiment();
    }

    private void validateInitialParams() {
        if (StringUtils.isEmpty((CharSequence)this.apiKey)) {
            throw new IllegalArgumentException("Apikey is not specified!");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.experimentKey)) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)this.projectName)) {
            throw new IllegalArgumentException("ProjectName is not specified!");
        }
        if (StringUtils.isEmpty((CharSequence)this.workspaceName)) {
            throw new IllegalArgumentException("Workspace name is not specified!");
        }
    }

    private void setupStdOutIntercept() {
        if (this.interceptStdout) {
            try {
                this.captureStdout();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void registerExperiment() {
        if (this.experimentKey != null) {
            this.logger.debug("Not registering a new experiment. Using previous experiment key {}", (Object)this.experimentKey);
            return;
        }
        CreateExperimentRequest request = new CreateExperimentRequest(this.workspaceName, this.projectName, this.experimentName);
        String body = JsonUtils.toJson(request);
        this.connection.sendPost(body, "/api/rest/v2/write/experiment/create", true).ifPresent(response -> {
            CreateExperimentResponse result = JsonUtils.fromJson(response, CreateExperimentResponse.class);
            this.experimentKey = result.getExperimentKey();
            this.experimentLink = result.getLink();
            this.logger.info("Experiment is live on comet.ml " + this.getExperimentUrl());
            this.heartbeatSendFuture = this.scheduledExecutorService.scheduleAtFixedRate(new HeartbeatPing(this), 1L, 3L, TimeUnit.SECONDS);
        });
        if (this.experimentKey == null) {
            throw new CometGeneralException("Failed to register onlineExperiment with Comet ML");
        }
    }

    private String getExperimentUrl() {
        return this.experimentLink != null ? this.experimentLink : "";
    }

    private void captureStdout() throws IOException {
        this.stdOutLogger = StdOutLogger.createStdoutLogger(this);
        this.stdErrLogger = StdOutLogger.createStderrLogger(this);
    }

    protected void sendHeartbeat() {
        if (this.experimentKey == null || this.atShutdown.get()) {
            return;
        }
        this.logger.debug("sendHeartbeat");
        this.connection.sendGet("/api/rest/v2/write/experiment/set-status", Collections.singletonMap(QueryParamName.EXPERIMENT_KEY, this.experimentKey));
    }

    private OutputUpdate getLogLineRequest(@NonNull String line, long offset, boolean stderr) {
        if (line == null) {
            throw new NullPointerException("line is marked non-null but is null");
        }
        OutputLine outputLine = new OutputLine();
        outputLine.setOutput(line);
        outputLine.setStderr(stderr);
        outputLine.setLocalTimestamp(System.currentTimeMillis());
        outputLine.setOffset(offset);
        OutputUpdate outputUpdate = new OutputUpdate();
        outputUpdate.setExperimentKey(this.getExperimentKey());
        outputUpdate.setRunContext(this.context);
        outputUpdate.setOutputLines(Collections.singletonList(outputLine));
        return outputUpdate;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    @Override
    public String getProjectName() {
        return this.projectName;
    }

    @Override
    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public Duration getCleaningTimeout() {
        return this.cleaningTimeout;
    }

    public StdOutLogger getStdOutLogger() {
        return this.stdOutLogger;
    }

    public StdOutLogger getStdErrLogger() {
        return this.stdErrLogger;
    }

    public boolean isInterceptStdout() {
        return this.interceptStdout;
    }

    public ScheduledFuture<?> getHeartbeatSendFuture() {
        return this.heartbeatSendFuture;
    }

    public AtomicBoolean getAtShutdown() {
        return this.atShutdown;
    }

    public static final class OnlineExperimentBuilderImpl
    implements OnlineExperimentBuilder {
        private String projectName;
        private String workspace;
        private String apiKey;
        private String baseUrl;
        private int maxAuthRetries = -1;
        private String experimentName;
        private String experimentKey;
        private Logger logger;
        private boolean interceptStdout = false;

        private OnlineExperimentBuilderImpl() {
        }

        @Override
        public OnlineExperimentBuilderImpl withProjectName(@NonNull String projectName) {
            if (projectName == null) {
                throw new NullPointerException("projectName is marked non-null but is null");
            }
            this.projectName = projectName;
            return this;
        }

        @Override
        public OnlineExperimentBuilderImpl withWorkspace(@NonNull String workspace) {
            if (workspace == null) {
                throw new NullPointerException("workspace is marked non-null but is null");
            }
            this.workspace = workspace;
            return this;
        }

        public OnlineExperimentBuilderImpl withApiKey(@NonNull String apiKey) {
            if (apiKey == null) {
                throw new NullPointerException("apiKey is marked non-null but is null");
            }
            this.apiKey = apiKey;
            return this;
        }

        @Override
        public OnlineExperimentBuilderImpl withMaxAuthRetries(int maxAuthRetries) {
            this.maxAuthRetries = maxAuthRetries;
            return this;
        }

        @Override
        public OnlineExperimentBuilderImpl withUrlOverride(@NonNull String urlOverride) {
            if (urlOverride == null) {
                throw new NullPointerException("urlOverride is marked non-null but is null");
            }
            this.baseUrl = urlOverride;
            return this;
        }

        @Override
        public OnlineExperimentBuilderImpl withExperimentName(@NonNull String experimentName) {
            if (experimentName == null) {
                throw new NullPointerException("experimentName is marked non-null but is null");
            }
            this.experimentName = experimentName;
            return this;
        }

        @Override
        public OnlineExperimentBuilderImpl withExistingExperimentKey(@NonNull String experimentKey) {
            if (experimentKey == null) {
                throw new NullPointerException("experimentKey is marked non-null but is null");
            }
            this.experimentKey = experimentKey;
            return this;
        }

        public OnlineExperimentBuilderImpl withLogger(@NonNull Logger logger) {
            if (logger == null) {
                throw new NullPointerException("logger is marked non-null but is null");
            }
            this.logger = logger;
            return this;
        }

        public OnlineExperimentBuilderImpl withConfigOverride(@NonNull File overrideConfig) {
            if (overrideConfig == null) {
                throw new NullPointerException("overrideConfig is marked non-null but is null");
            }
            CometConfig.applyConfigOverride(overrideConfig);
            return this;
        }

        @Override
        public OnlineExperimentBuilderImpl interceptStdout() {
            this.interceptStdout = true;
            return this;
        }

        @Override
        public OnlineExperimentImpl build() {
            if (StringUtils.isEmpty((CharSequence)this.apiKey)) {
                this.apiKey = CometConfig.COMET_API_KEY.getString();
            }
            if (StringUtils.isEmpty((CharSequence)this.projectName)) {
                this.projectName = CometConfig.COMET_PROJECT_NAME.getOptionalString().orElse(null);
            }
            if (StringUtils.isEmpty((CharSequence)this.workspace)) {
                this.workspace = CometConfig.COMET_WORKSPACE_NAME.getOptionalString().orElse(null);
            }
            if (StringUtils.isEmpty((CharSequence)this.baseUrl)) {
                this.baseUrl = CometConfig.COMET_BASE_URL.getString();
            }
            if (this.maxAuthRetries == -1) {
                this.maxAuthRetries = CometConfig.COMET_MAX_AUTH_RETRIES.getInt();
            }
            Duration cleaningTimeout = CometConfig.COMET_TIMEOUT_CLEANING_SECONDS.getDuration();
            return new OnlineExperimentImpl(this.apiKey, this.projectName, this.workspace, this.experimentName, this.experimentKey, this.logger, this.interceptStdout, this.baseUrl, this.maxAuthRetries, cleaningTimeout);
        }
    }

    static class HeartbeatPing
    implements Runnable {
        OnlineExperimentImpl onlineExperiment;

        HeartbeatPing(OnlineExperimentImpl onlineExperiment) {
            this.onlineExperiment = onlineExperiment;
        }

        @Override
        public void run() {
            this.onlineExperiment.sendHeartbeat();
        }
    }
}

