/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.context;

import java.util.Objects;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public final class ExperimentContext {
    private Long step;
    private Long epoch;
    private String context;

    ExperimentContext() {
    }

    public ExperimentContext(long step, long epoch, String context) {
        this.step = step;
        this.epoch = epoch;
        this.context = context;
    }

    public ExperimentContext(long step, long epoch) {
        this(step, epoch, "");
    }

    public ExperimentContext(long step) {
        this(step, 0L);
    }

    public ExperimentContext(ExperimentContext other) {
        this.step = other.step;
        this.epoch = other.epoch;
        this.context = other.context;
    }

    public void mergeFrom(@NonNull ExperimentContext other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        if (this == other) {
            return;
        }
        if (Objects.nonNull(other.step)) {
            this.step = other.step;
        }
        if (Objects.nonNull(other.epoch)) {
            this.epoch = other.epoch;
        }
        if (StringUtils.isNotBlank((CharSequence)other.context)) {
            this.context = other.context;
        }
    }

    public static ExperimentContext empty() {
        return new ExperimentContext();
    }

    public static ExperimentContextBuilder builder() {
        return new ExperimentContextBuilder();
    }

    public Long getStep() {
        return this.step;
    }

    public Long getEpoch() {
        return this.epoch;
    }

    public String getContext() {
        return this.context;
    }

    public void setStep(Long step) {
        this.step = step;
    }

    public void setEpoch(Long epoch) {
        this.epoch = epoch;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExperimentContext)) {
            return false;
        }
        ExperimentContext other = (ExperimentContext)o;
        Long this$step = this.getStep();
        Long other$step = other.getStep();
        if (this$step == null ? other$step != null : !((Object)this$step).equals(other$step)) {
            return false;
        }
        Long this$epoch = this.getEpoch();
        Long other$epoch = other.getEpoch();
        if (this$epoch == null ? other$epoch != null : !((Object)this$epoch).equals(other$epoch)) {
            return false;
        }
        String this$context = this.getContext();
        String other$context = other.getContext();
        return !(this$context == null ? other$context != null : !this$context.equals(other$context));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $step = this.getStep();
        result = result * 59 + ($step == null ? 43 : ((Object)$step).hashCode());
        Long $epoch = this.getEpoch();
        result = result * 59 + ($epoch == null ? 43 : ((Object)$epoch).hashCode());
        String $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : $context.hashCode());
        return result;
    }

    public String toString() {
        return "ExperimentContext(step=" + this.getStep() + ", epoch=" + this.getEpoch() + ", context=" + this.getContext() + ")";
    }

    public static final class ExperimentContextBuilder {
        private final ExperimentContext context = new ExperimentContext();

        ExperimentContextBuilder() {
        }

        public ExperimentContextBuilder withStep(long step) {
            this.context.step = step;
            return this;
        }

        public ExperimentContextBuilder withEpoch(long epoch) {
            this.context.epoch = epoch;
            return this;
        }

        public ExperimentContextBuilder withContext(String context) {
            this.context.context = context;
            return this;
        }

        public ExperimentContext build() {
            return this.context;
        }
    }
}

