/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.impl;

import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.functions.Function;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import ml.comet.experiment.Experiment;
import ml.comet.experiment.context.ExperimentContext;
import ml.comet.experiment.exception.CometApiException;
import ml.comet.experiment.exception.CometGeneralException;
import ml.comet.experiment.impl.RestApiClient;
import ml.comet.experiment.impl.asset.Asset;
import ml.comet.experiment.impl.asset.AssetType;
import ml.comet.experiment.impl.http.Connection;
import ml.comet.experiment.impl.http.ConnectionInitializer;
import ml.comet.experiment.impl.resources.LogMessages;
import ml.comet.experiment.impl.utils.CometUtils;
import ml.comet.experiment.impl.utils.DataUtils;
import ml.comet.experiment.model.CreateExperimentRequest;
import ml.comet.experiment.model.CreateExperimentResponse;
import ml.comet.experiment.model.ExperimentAssetLink;
import ml.comet.experiment.model.ExperimentAssetListResponse;
import ml.comet.experiment.model.ExperimentMetadataRest;
import ml.comet.experiment.model.ExperimentStatusResponse;
import ml.comet.experiment.model.GetGraphResponse;
import ml.comet.experiment.model.GetHtmlResponse;
import ml.comet.experiment.model.GetOutputResponse;
import ml.comet.experiment.model.GitMetadata;
import ml.comet.experiment.model.GitMetadataRest;
import ml.comet.experiment.model.LogDataResponse;
import ml.comet.experiment.model.MinMaxResponse;
import ml.comet.experiment.model.TagsResponse;
import ml.comet.experiment.model.ValueMinMaxDto;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

abstract class BaseExperiment
implements Experiment {
    final String apiKey;
    final String baseUrl;
    final int maxAuthRetries;
    final Duration cleaningTimeout;
    String projectName;
    String workspaceName;
    String experimentKey;
    String experimentLink;
    String experimentName;
    boolean alive;
    private RestApiClient restApiClient;
    private Connection connection;

    protected abstract Logger getLogger();

    BaseExperiment(@NonNull String apiKey, @NonNull String baseUrl, int maxAuthRetries, String experimentKey, @NonNull Duration cleaningTimeout) {
        this(apiKey, baseUrl, maxAuthRetries, experimentKey, cleaningTimeout, "", "");
        if (apiKey == null) {
            throw new NullPointerException("apiKey is marked non-null but is null");
        }
        if (baseUrl == null) {
            throw new NullPointerException("baseUrl is marked non-null but is null");
        }
        if (cleaningTimeout == null) {
            throw new NullPointerException("cleaningTimeout is marked non-null but is null");
        }
    }

    BaseExperiment(@NonNull String apiKey, @NonNull String baseUrl, int maxAuthRetries, String experimentKey, @NonNull Duration cleaningTimeout, String projectName, String workspaceName) {
        if (apiKey == null) {
            throw new NullPointerException("apiKey is marked non-null but is null");
        }
        if (baseUrl == null) {
            throw new NullPointerException("baseUrl is marked non-null but is null");
        }
        if (cleaningTimeout == null) {
            throw new NullPointerException("cleaningTimeout is marked non-null but is null");
        }
        this.apiKey = apiKey;
        this.baseUrl = baseUrl;
        this.maxAuthRetries = maxAuthRetries;
        this.experimentKey = experimentKey;
        this.cleaningTimeout = cleaningTimeout;
        this.projectName = projectName;
        this.workspaceName = workspaceName;
    }

    void init() {
        CometUtils.printCometSdkVersion();
        this.validateInitialParams();
        this.connection = ConnectionInitializer.initConnection(this.apiKey, this.baseUrl, this.maxAuthRetries, this.getLogger());
        this.restApiClient = new RestApiClient(this.connection);
        this.alive = true;
    }

    private void validateInitialParams() throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)this.apiKey)) {
            throw new IllegalArgumentException("API key is not specified!");
        }
        if (StringUtils.isBlank((CharSequence)this.baseUrl)) {
            throw new IllegalArgumentException("The Comet base URL is not specified!");
        }
    }

    void registerExperiment() throws CometGeneralException {
        if (StringUtils.isNotBlank((CharSequence)this.experimentKey)) {
            this.getLogger().debug("Not registering a new experiment. Using previous experiment key {}", (Object)this.experimentKey);
            return;
        }
        CreateExperimentResponse result = (CreateExperimentResponse)this.restApiClient.registerExperiment(new CreateExperimentRequest(this.workspaceName, this.projectName, this.experimentName)).blockingGet();
        this.experimentKey = result.getExperimentKey();
        this.experimentLink = result.getLink();
        this.getLogger().info(LogMessages.getString("EXPERIMENT_LIVE", this.experimentLink));
        if (StringUtils.isBlank((CharSequence)this.experimentKey)) {
            throw new CometGeneralException("Failed to register onlineExperiment with Comet ML");
        }
    }

    @Override
    public String getExperimentKey() {
        return this.experimentKey;
    }

    @Override
    public String getProjectName() {
        return this.projectName;
    }

    @Override
    public String getWorkspaceName() {
        return this.workspaceName;
    }

    @Override
    public String getExperimentName() {
        return this.experimentName;
    }

    @Override
    public void setExperimentName(@NonNull String experimentName) {
        if (experimentName == null) {
            throw new NullPointerException("experimentName is marked non-null but is null");
        }
        this.logOther("Name", experimentName);
        this.experimentName = experimentName;
    }

    @Override
    public void logMetric(@NonNull String metricName, @NonNull Object metricValue, @NonNull ExperimentContext context) {
        if (metricName == null) {
            throw new NullPointerException("metricName is marked non-null but is null");
        }
        if (metricValue == null) {
            throw new NullPointerException("metricValue is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logMetric {} = {}, context: {}", new Object[]{metricName, metricValue, context});
        }
        this.sendSynchronously(this.restApiClient::logMetric, DataUtils.createLogMetricRequest(metricName, metricValue, context));
    }

    @Override
    public void logMetric(String metricName, Object metricValue, long step, long epoch) {
        this.logMetric(metricName, metricValue, new ExperimentContext(step, epoch));
    }

    @Override
    public void logParameter(String parameterName, Object paramValue, ExperimentContext context) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logParameter {} = {}, context: {}", new Object[]{parameterName, paramValue, context});
        }
        this.sendSynchronously(this.restApiClient::logParameter, DataUtils.createLogParamRequest(parameterName, paramValue, context));
    }

    @Override
    public void logParameter(String parameterName, Object paramValue, long step) {
        this.logParameter(parameterName, paramValue, new ExperimentContext(step));
    }

    @Override
    public void logLine(String line, long offset, boolean stderr, String context) {
        this.validate();
        this.sendSynchronously(this.restApiClient::logOutputLine, DataUtils.createLogLineRequest(line, offset, stderr, context));
    }

    @Override
    public void logHtml(@NonNull String html, boolean override) {
        if (html == null) {
            throw new NullPointerException("html is marked non-null but is null");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logHtml {}, override: {}", (Object)html, (Object)override);
        }
        this.sendSynchronously(this.restApiClient::logHtml, DataUtils.createLogHtmlRequest(html, override));
    }

    @Override
    public void logOther(@NonNull String key, @NonNull Object value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logOther {} {}", (Object)key, value);
        }
        this.sendSynchronously(this.restApiClient::logOther, DataUtils.createLogOtherRequest(key, value));
    }

    @Override
    public void addTag(@NonNull String tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("addTag {}", (Object)tag);
        }
        this.sendSynchronously(this.restApiClient::addTag, DataUtils.createTagRequest(tag));
    }

    @Override
    public void logGraph(@NonNull String graph) {
        if (graph == null) {
            throw new NullPointerException("graph is marked non-null but is null");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logGraph {}", (Object)graph);
        }
        this.sendSynchronously(this.restApiClient::logGraph, DataUtils.createGraphRequest(graph));
    }

    @Override
    public void logStartTime(long startTimeMillis) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logStartTime {}", (Object)startTimeMillis);
        }
        this.sendSynchronously(this.restApiClient::logStartEndTime, DataUtils.createLogStartTimeRequest(startTimeMillis));
    }

    @Override
    public void logEndTime(long endTimeMillis) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logEndTime {}", (Object)endTimeMillis);
        }
        this.sendSynchronously(this.restApiClient::logStartEndTime, DataUtils.createLogEndTimeRequest(endTimeMillis));
    }

    @Override
    public void logGitMetadata(GitMetadata gitMetadata) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("logGitMetadata {}", (Object)gitMetadata);
        }
        this.sendSynchronously(this.restApiClient::logGitMetadata, gitMetadata);
    }

    @Override
    public void logCode(@NonNull String code, @NonNull String fileName, @NonNull ExperimentContext context) {
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("log raw source code, file name: {}", (Object)fileName);
        }
        Asset asset = new Asset();
        asset.setFileLikeData(code.getBytes(StandardCharsets.UTF_8));
        asset.setFileName(fileName);
        asset.setExperimentContext(context);
        asset.setType(AssetType.ASSET_TYPE_SOURCE_CODE);
        this.sendSynchronously(this.restApiClient::logAsset, asset);
    }

    @Override
    public void logCode(String code, String fileName) {
        this.logCode(code, fileName, ExperimentContext.empty());
    }

    @Override
    public void logCode(@NonNull File file, @NonNull ExperimentContext context) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("log source code from file {}", (Object)file.getName());
        }
        Asset asset = new Asset();
        asset.setFile(file);
        asset.setFileName(file.getName());
        asset.setExperimentContext(context);
        asset.setType(AssetType.ASSET_TYPE_SOURCE_CODE);
        this.sendSynchronously(this.restApiClient::logAsset, asset);
    }

    @Override
    public void logCode(File file) {
        this.logCode(file, ExperimentContext.empty());
    }

    @Override
    public void uploadAsset(@NonNull File file, @NonNull String fileName, boolean overwrite, @NonNull ExperimentContext context) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("uploadAsset from file {}, name {}, override {}, context {}", new Object[]{file.getName(), fileName, overwrite, context});
        }
        Asset asset = new Asset();
        asset.setFile(file);
        asset.setFileName(fileName);
        asset.setExperimentContext(context);
        asset.setOverwrite(overwrite);
        asset.setType(AssetType.ASSET_TYPE_ASSET);
        this.sendSynchronously(this.restApiClient::logAsset, asset);
    }

    @Override
    public void uploadAsset(@NonNull File asset, String fileName, boolean overwrite, long step, long epoch) {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        this.uploadAsset(asset, fileName, overwrite, new ExperimentContext(step, epoch));
    }

    @Override
    public void uploadAsset(@NonNull File asset, boolean overwrite, @NonNull ExperimentContext context) {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.uploadAsset(asset, asset.getName(), overwrite, context);
    }

    @Override
    public void uploadAsset(@NonNull File asset, boolean overwrite, long step, long epoch) {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        this.uploadAsset(asset, overwrite, new ExperimentContext(step, epoch));
    }

    @Override
    public ExperimentMetadataRest getMetadata() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("get metadata for experiment {}", (Object)this.experimentKey);
        }
        return (ExperimentMetadataRest)this.loadRemote(this.restApiClient::getMetadata, "METADATA");
    }

    @Override
    public GitMetadataRest getGitMetadata() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("get git metadata for experiment {}", (Object)this.experimentKey);
        }
        return (GitMetadataRest)this.loadRemote(this.restApiClient::getGitMetadata, "GIT METADATA");
    }

    @Override
    public Optional<String> getHtml() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("get html for experiment {}", (Object)this.experimentKey);
        }
        return Optional.ofNullable(((GetHtmlResponse)this.loadRemote(this.restApiClient::getHtml, "HTML")).getHtml());
    }

    @Override
    public Optional<String> getOutput() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("get output for experiment {}", (Object)this.experimentKey);
        }
        return Optional.ofNullable(((GetOutputResponse)this.loadRemote(this.restApiClient::getOutput, "StdOut")).getOutput());
    }

    @Override
    public Optional<String> getGraph() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("get graph for experiment {}", (Object)this.experimentKey);
        }
        return Optional.ofNullable(((GetGraphResponse)this.loadRemote(this.restApiClient::getGraph, "GRAPH")).getGraph());
    }

    @Override
    public List<ValueMinMaxDto> getParameters() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("get params for experiment {}", (Object)this.experimentKey);
        }
        return ((MinMaxResponse)this.loadRemote(this.restApiClient::getParameters, "PARAMETERS")).getValues();
    }

    @Override
    public List<ValueMinMaxDto> getMetrics() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("get metrics summary for experiment {}", (Object)this.experimentKey);
        }
        return ((MinMaxResponse)this.loadRemote(this.restApiClient::getMetrics, "METRICS")).getValues();
    }

    @Override
    public List<ValueMinMaxDto> getLogOther() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("get log other for experiment {}", (Object)this.experimentKey);
        }
        return ((MinMaxResponse)this.loadRemote(this.restApiClient::getLogOther, "OTHER PARAMETERS")).getValues();
    }

    @Override
    public List<String> getTags() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("get tags for experiment {}", (Object)this.experimentKey);
        }
        return ((TagsResponse)this.loadRemote(this.restApiClient::getTags, "TAGs")).getTags();
    }

    @Override
    public List<ExperimentAssetLink> getAssetList(@NonNull AssetType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("get assets with type {} for experiment {}", (Object)type, (Object)this.experimentKey);
        }
        return ((ExperimentAssetListResponse)this.validateAndGetExperimentKey().concatMap(experimentKey -> this.restApiClient.getAssetList((String)experimentKey, type)).doOnError(ex -> this.getLogger().error("Failed to read ASSETS list for the experiment, experiment key: {}", (Object)this.experimentKey, ex)).blockingGet()).getAssets();
    }

    @Override
    public void end() {
        if (!this.alive) {
            return;
        }
        this.getLogger().info(LogMessages.getString("EXPERIMENT_CLEANUP_PROMPT", this.cleaningTimeout.getSeconds()));
        this.alive = false;
        if (this.restApiClient != null) {
            this.restApiClient.dispose();
        }
        if (this.connection != null) {
            try {
                this.connection.waitAndClose(this.cleaningTimeout);
                this.connection = null;
            }
            catch (Exception e) {
                this.getLogger().error("failed to close connection", (Throwable)e);
            }
        }
    }

    Optional<ExperimentStatusResponse> sendExperimentStatus() {
        return Optional.ofNullable(this.validateAndGetExperimentKey().concatMap(experimentKey -> this.restApiClient.sendExperimentStatus((String)experimentKey)).onErrorComplete().blockingGet());
    }

    private <T> T loadRemote(Function<String, Single<T>> loadFunc, String alias) {
        return (T)this.validateAndGetExperimentKey().concatMap(loadFunc).doOnError(ex -> this.getLogger().error(LogMessages.getString("FAILED_READ_DATA_FOR_EXPERIMENT", alias, this.experimentKey), ex)).blockingGet();
    }

    private <T> void sendSynchronously(BiFunction<T, String, Single<LogDataResponse>> func, T request) throws CometApiException {
        LogDataResponse response = (LogDataResponse)this.validateAndGetExperimentKey().concatMap(experimentKey -> (Single)func.apply(request, experimentKey)).blockingGet();
        if (response.hasFailed()) {
            throw new CometApiException("Failed to log {}, reason: %s", request, response.getMsg());
        }
    }

    private void validate() throws IllegalStateException {
        if (StringUtils.isBlank((CharSequence)this.experimentKey)) {
            throw new IllegalStateException("Experiment key must be present!");
        }
        if (!this.alive) {
            throw new IllegalStateException("Experiment was not initialized. You need to call init().");
        }
    }

    Single<String> validateAndGetExperimentKey() {
        if (StringUtils.isBlank((CharSequence)this.experimentKey)) {
            return Single.error((Throwable)new IllegalStateException("Experiment key must be present!"));
        }
        if (!this.alive) {
            return Single.error((Throwable)new IllegalStateException("Experiment is not alive or already closed."));
        }
        return Single.just((Object)this.getExperimentKey());
    }

    public RestApiClient getRestApiClient() {
        return this.restApiClient;
    }

    public Connection getConnection() {
        return this.connection;
    }
}

