/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.impl;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import lombok.NonNull;
import ml.comet.experiment.CometApi;
import ml.comet.experiment.builder.BaseCometBuilder;
import ml.comet.experiment.builder.CometApiBuilder;
import ml.comet.experiment.impl.RestApiClient;
import ml.comet.experiment.impl.config.CometConfig;
import ml.comet.experiment.impl.http.Connection;
import ml.comet.experiment.impl.http.ConnectionInitializer;
import ml.comet.experiment.impl.utils.CometUtils;
import ml.comet.experiment.model.ExperimentMetadataRest;
import ml.comet.experiment.model.GetExperimentsResponse;
import ml.comet.experiment.model.GetProjectsResponse;
import ml.comet.experiment.model.GetWorkspacesResponse;
import ml.comet.experiment.model.RestProject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CometApiImpl
implements CometApi {
    private Logger logger = LoggerFactory.getLogger(CometApiImpl.class);
    private final String apiKey;
    private final String baseUrl;
    private final int maxAuthRetries;
    private RestApiClient restApiClient;
    private Connection connection;

    CometApiImpl(@NonNull String apiKey, @NonNull String baseUrl, int maxAuthRetries, Logger logger) {
        if (apiKey == null) {
            throw new NullPointerException("apiKey is marked non-null but is null");
        }
        if (baseUrl == null) {
            throw new NullPointerException("baseUrl is marked non-null but is null");
        }
        this.apiKey = apiKey;
        this.baseUrl = baseUrl;
        this.maxAuthRetries = maxAuthRetries;
        if (logger != null) {
            this.logger = logger;
        }
    }

    @Override
    public List<String> getAllWorkspaces() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getAllWorkspaces invoked");
        }
        return ((GetWorkspacesResponse)this.restApiClient.getAllWorkspaces().doOnError(ex -> this.logger.error("Failed to read workspaces for the current user", ex)).blockingGet()).getWorkspaceNames();
    }

    @Override
    public List<RestProject> getAllProjects(@NonNull String workspaceName) {
        if (workspaceName == null) {
            throw new NullPointerException("workspaceName is marked non-null but is null");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getAllProjects invoked");
        }
        return ((GetProjectsResponse)this.restApiClient.getAllProjects(workspaceName).doOnError(ex -> this.logger.error("Failed to read projects in the workspace {}", (Object)workspaceName, ex)).blockingGet()).getProjects();
    }

    @Override
    public List<ExperimentMetadataRest> getAllExperiments(@NonNull String projectId) {
        if (projectId == null) {
            throw new NullPointerException("projectId is marked non-null but is null");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getAllExperiments invoked");
        }
        return ((GetExperimentsResponse)this.restApiClient.getAllExperiments(projectId).doOnError(ex -> this.logger.error("Failed to read experiments found in the project {}", (Object)projectId, ex)).blockingGet()).getExperiments();
    }

    @Override
    public void close() throws IOException {
        if (Objects.nonNull(this.restApiClient)) {
            this.restApiClient.dispose();
        }
        if (Objects.nonNull(this.connection)) {
            this.connection.close();
        }
    }

    void init() {
        CometUtils.printCometSdkVersion();
        this.connection = ConnectionInitializer.initConnection(this.apiKey, this.baseUrl, this.maxAuthRetries, this.logger);
        this.restApiClient = new RestApiClient(this.connection);
    }

    public static CometApiBuilder builder() {
        return new CometApiBuilderImpl();
    }

    static final class CometApiBuilderImpl
    implements CometApiBuilder {
        private String apiKey;
        private Logger logger;

        CometApiBuilderImpl() {
        }

        public CometApiBuilder withConfigOverride(@NonNull File overrideConfig) {
            if (overrideConfig == null) {
                throw new NullPointerException("overrideConfig is marked non-null but is null");
            }
            CometConfig.applyConfigOverride(overrideConfig);
            return this;
        }

        @Override
        public BaseCometBuilder<CometApi> withLogger(@NonNull Logger logger) {
            if (logger == null) {
                throw new NullPointerException("logger is marked non-null but is null");
            }
            this.logger = logger;
            return this;
        }

        public CometApiBuilder withApiKey(@NonNull String apiKey) {
            if (apiKey == null) {
                throw new NullPointerException("apiKey is marked non-null but is null");
            }
            this.apiKey = apiKey;
            return this;
        }

        @Override
        public CometApi build() {
            if (StringUtils.isBlank((CharSequence)this.apiKey)) {
                this.apiKey = CometConfig.COMET_API_KEY.getString();
            }
            CometApiImpl api = new CometApiImpl(this.apiKey, CometConfig.COMET_BASE_URL.getString(), CometConfig.COMET_MAX_AUTH_RETRIES.getInt(), this.logger);
            try {
                api.init();
            }
            catch (Throwable throwable) {
                api.close();
                throw throwable;
            }
            return api;
        }
    }
}

