/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.impl;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.NonNull;
import ml.comet.experiment.OnlineExperiment;
import ml.comet.experiment.context.ExperimentContext;
import ml.comet.experiment.impl.BaseExperimentAsync;
import ml.comet.experiment.impl.OnlineExperimentBuilderImpl;
import ml.comet.experiment.impl.log.StdOutLogger;
import ml.comet.experiment.impl.resources.LogMessages;
import ml.comet.experiment.model.ExperimentStatusResponse;
import ml.comet.experiment.model.GitMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OnlineExperimentImpl
extends BaseExperimentAsync
implements OnlineExperiment {
    private static final int SCHEDULED_EXECUTOR_TERMINATION_WAIT_SEC = 60;
    private static final int STD_OUT_LOGGER_FLUSH_WAIT_DELAY_MS = 2000;
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
    private Logger logger = LoggerFactory.getLogger(OnlineExperimentImpl.class);
    private StdOutLogger stdOutLogger;
    private StdOutLogger stdErrLogger;
    private boolean interceptStdout;
    private ScheduledFuture<?> heartbeatSendFuture;
    private final AtomicBoolean atShutdown = new AtomicBoolean();

    OnlineExperimentImpl(String apiKey, String projectName, String workspaceName, String experimentName, String experimentKey, Logger logger, boolean interceptStdout, String baseUrl, int maxAuthRetries, Duration cleaningTimeout) throws IllegalArgumentException {
        super(apiKey, baseUrl, maxAuthRetries, experimentKey, cleaningTimeout, projectName, workspaceName);
        this.experimentName = experimentName;
        this.interceptStdout = interceptStdout;
        if (logger != null) {
            this.logger = logger;
        }
    }

    @Override
    public void end() {
        this.atShutdown.set(true);
        if (this.heartbeatSendFuture != null) {
            if (!this.heartbeatSendFuture.cancel(true)) {
                this.logger.error("failed to stop experiment's heartbeat sender");
            } else {
                this.logger.info(LogMessages.getString("EXPERIMENT_HEARTBEAT_STOPPED_PROMPT"));
            }
            this.heartbeatSendFuture = null;
        }
        this.scheduledExecutorService.shutdownNow();
        try {
            if (!this.scheduledExecutorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.logger.warn("scheduled executor failed to terminate");
            }
        }
        catch (InterruptedException e) {
            this.logger.error("scheduled executor's wait for termination was interrupted", (Throwable)e);
        }
        if (this.interceptStdout) {
            try {
                this.stopInterceptStdout();
            }
            catch (IOException e) {
                this.logger.error("failed to stop StdOut/StdErr intercepting", (Throwable)e);
            }
        }
        super.end();
    }

    @Override
    public void close() throws Exception {
        this.end();
    }

    @Override
    public void setInterceptStdout() throws IOException {
        if (!this.interceptStdout) {
            this.interceptStdout = true;
            this.captureStdout();
        }
    }

    @Override
    public void stopInterceptStdout() throws IOException {
        if (this.stdOutLogger != null) {
            this.stopStdOutLogger(this.stdOutLogger, 2000L);
            this.stdOutLogger = null;
            this.interceptStdout = false;
        }
        if (this.stdErrLogger != null) {
            this.stopStdOutLogger(this.stdErrLogger, 0L);
            this.stdErrLogger = null;
        }
    }

    @Override
    public void nextStep() {
        this.setStep(this.getStep() + 1L);
    }

    @Override
    public long getStep() {
        if (this.baseContext.getStep() != null) {
            return this.baseContext.getStep();
        }
        return 0L;
    }

    @Override
    public void setStep(long step) {
        this.baseContext.setStep(step);
    }

    @Override
    public void nextEpoch() {
        this.setEpoch(this.getEpoch() + 1L);
    }

    @Override
    public long getEpoch() {
        if (this.baseContext.getEpoch() != null) {
            return this.baseContext.getEpoch();
        }
        return 0L;
    }

    @Override
    public void setEpoch(long epoch) {
        this.baseContext.setEpoch(epoch);
    }

    @Override
    public void setContext(String context) {
        this.baseContext.setContext(context);
    }

    @Override
    public String getContext() {
        return this.baseContext.getContext();
    }

    @Override
    public Optional<String> getExperimentLink() {
        return Optional.ofNullable(this.experimentLink);
    }

    @Override
    public void logMetric(@NonNull String metricName, @NonNull Object metricValue, @NonNull ExperimentContext context) {
        if (metricName == null) {
            throw new NullPointerException("metricName is marked non-null but is null");
        }
        if (metricValue == null) {
            throw new NullPointerException("metricValue is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.logMetric(metricName, metricValue, context, Optional.empty());
    }

    @Override
    public void logMetric(String metricName, Object metricValue, long step, long epoch) {
        this.logMetric(metricName, metricValue, new ExperimentContext(step, epoch, this.getContext()));
    }

    @Override
    public void logMetric(String metricName, Object metricValue, long step) {
        this.logMetric(metricName, metricValue, new ExperimentContext(step, this.getEpoch(), this.getContext()));
    }

    @Override
    public void logMetric(String metricName, Object metricValue) {
        this.logMetric(metricName, metricValue, this.baseContext);
    }

    @Override
    public void logParameter(@NonNull String parameterName, @NonNull Object paramValue) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName is marked non-null but is null");
        }
        if (paramValue == null) {
            throw new NullPointerException("paramValue is marked non-null but is null");
        }
        this.logParameter(parameterName, paramValue, this.baseContext);
    }

    @Override
    public void logParameter(@NonNull String parameterName, @NonNull Object paramValue, long step) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName is marked non-null but is null");
        }
        if (paramValue == null) {
            throw new NullPointerException("paramValue is marked non-null but is null");
        }
        this.logParameter(parameterName, paramValue, new ExperimentContext(step, this.getEpoch(), this.getContext()));
    }

    @Override
    public void logParameter(String parameterName, Object paramValue, @NonNull ExperimentContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.logParameter(parameterName, paramValue, context, Optional.empty());
    }

    @Override
    public void logHtml(@NonNull String html, boolean override) {
        if (html == null) {
            throw new NullPointerException("html is marked non-null but is null");
        }
        this.logHtml(html, override, Optional.empty());
    }

    @Override
    public void logOther(@NonNull String key, @NonNull Object value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.logOther(key, value, Optional.empty());
    }

    @Override
    public void addTag(@NonNull String tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        this.addTag(tag, Optional.empty());
    }

    @Override
    public void logGraph(@NonNull String graph) {
        if (graph == null) {
            throw new NullPointerException("graph is marked non-null but is null");
        }
        this.logGraph(graph, Optional.empty());
    }

    @Override
    public void logStartTime(long startTimeMillis) {
        this.logStartTime(startTimeMillis, Optional.empty());
    }

    @Override
    public void logEndTime(long endTimeMillis) {
        this.logEndTime(endTimeMillis, Optional.empty());
    }

    @Override
    public void logGitMetadata(GitMetadata gitMetadata) {
        this.logGitMetadataAsync(gitMetadata, Optional.empty());
    }

    @Override
    public void logLine(String line, long offset, boolean stderr) {
        this.logLine(line, offset, stderr, this.getContext());
    }

    @Override
    public void logLine(String line, long offset, boolean stderr, String context) {
        this.setContext(context);
        this.logLine(line, offset, stderr, context, Optional.empty());
    }

    @Override
    public void logAssetFolder(@NonNull File folder, boolean logFilePath, boolean recursive, @NonNull ExperimentContext context) {
        if (folder == null) {
            throw new NullPointerException("folder is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.logAssetFolder(folder, logFilePath, recursive, true, context, Optional.empty());
    }

    @Override
    public void logAssetFolder(@NonNull File folder, boolean logFilePath, boolean recursive) {
        if (folder == null) {
            throw new NullPointerException("folder is marked non-null but is null");
        }
        this.logAssetFolder(folder, logFilePath, recursive, this.baseContext);
    }

    @Override
    public void logAssetFolder(@NonNull File folder, boolean logFilePath) {
        if (folder == null) {
            throw new NullPointerException("folder is marked non-null but is null");
        }
        this.logAssetFolder(folder, logFilePath, false);
    }

    @Override
    public void uploadAsset(@NonNull File asset, @NonNull String fileName, boolean overwrite, @NonNull ExperimentContext context) {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.uploadAsset(asset, fileName, overwrite, context, Optional.empty());
    }

    @Override
    public void uploadAsset(@NonNull File asset, boolean overwrite, @NonNull ExperimentContext context) {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.uploadAsset(asset, asset.getName(), overwrite, context);
    }

    @Override
    public void uploadAsset(@NonNull File asset, boolean overwrite, long step, long epoch) {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        this.uploadAsset(asset, asset.getName(), overwrite, new ExperimentContext(step, epoch, this.getContext()));
    }

    @Override
    public void uploadAsset(@NonNull File asset, @NonNull String fileName, boolean overwrite, long step) {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        this.uploadAsset(asset, fileName, overwrite, new ExperimentContext(step, this.getEpoch(), this.getContext()));
    }

    @Override
    public void uploadAsset(@NonNull File asset, @NonNull String fileName, boolean overwrite) {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        this.uploadAsset(asset, fileName, overwrite, this.baseContext);
    }

    @Override
    public void uploadAsset(@NonNull File asset, boolean overwrite) {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        this.uploadAsset(asset, asset.getName(), overwrite, this.baseContext);
    }

    @Override
    public void logRemoteAsset(@NonNull URI uri, String fileName, boolean overwrite, Map<String, Object> metadata, @NonNull ExperimentContext context) {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.logRemoteAsset(uri, Optional.ofNullable(fileName), overwrite, Optional.ofNullable(metadata), context, Optional.empty());
    }

    @Override
    public void logRemoteAsset(@NonNull URI uri, String fileName, boolean overwrite, Map<String, Object> metadata) {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        this.logRemoteAsset(uri, fileName, overwrite, metadata, this.baseContext);
    }

    @Override
    public void logRemoteAsset(@NonNull URI uri, @NonNull String fileName, boolean overwrite) {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        this.logRemoteAsset(uri, fileName, overwrite, null);
    }

    @Override
    public void logRemoteAsset(@NonNull URI uri, boolean overwrite) {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        this.logRemoteAsset(uri, null, overwrite, null, this.baseContext);
    }

    @Override
    public void logCode(@NonNull String code, @NonNull String fileName, @NonNull ExperimentContext context) {
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.logCode(code, fileName, context, Optional.empty());
    }

    @Override
    public void logCode(@NonNull File file, @NonNull ExperimentContext context) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.logCode(file, context, Optional.empty());
    }

    @Override
    public void logCode(@NonNull String code, @NonNull String fileName) {
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        this.logCode(code, fileName, this.baseContext);
    }

    @Override
    public void logCode(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        this.logCode(file, this.baseContext);
    }

    @Override
    void init() {
        super.init();
        this.setupStdOutIntercept();
        this.registerExperiment();
        this.heartbeatSendFuture = this.scheduledExecutorService.scheduleAtFixedRate(new HeartbeatPing(this), 1L, 3L, TimeUnit.SECONDS);
    }

    private void setupStdOutIntercept() {
        if (this.interceptStdout) {
            try {
                this.captureStdout();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void stopStdOutLogger(@NonNull StdOutLogger stdOutLogger, long delay) throws IOException {
        if (stdOutLogger == null) {
            throw new NullPointerException("stdOutLogger is marked non-null but is null");
        }
        stdOutLogger.flush();
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            this.logger.warn("interrupted while waiting for StdLogger to flush", (Throwable)e);
        }
        stdOutLogger.close();
    }

    private void captureStdout() throws IOException {
        this.stdOutLogger = StdOutLogger.createStdoutLogger(this);
        this.stdErrLogger = StdOutLogger.createStderrLogger(this);
    }

    private void sendHeartbeat() {
        if (!this.alive || this.atShutdown.get()) {
            return;
        }
        this.logger.debug("sendHeartbeat");
        Optional<ExperimentStatusResponse> status = this.sendExperimentStatus();
        if (status.isPresent()) {
            long interval = status.get().getIsAliveBeatDurationMillis();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("received heartbeat interval {}", (Object)interval);
            }
        }
    }

    public static OnlineExperimentBuilderImpl builder() {
        return new OnlineExperimentBuilderImpl();
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    static class HeartbeatPing
    implements Runnable {
        OnlineExperimentImpl onlineExperiment;

        HeartbeatPing(OnlineExperimentImpl onlineExperiment) {
            this.onlineExperiment = onlineExperiment;
        }

        @Override
        public void run() {
            this.onlineExperiment.sendHeartbeat();
        }
    }
}

