/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.impl;

import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.disposables.Disposable;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import ml.comet.experiment.exception.CometApiException;
import ml.comet.experiment.impl.asset.Asset;
import ml.comet.experiment.impl.asset.AssetType;
import ml.comet.experiment.impl.asset.RemoteAsset;
import ml.comet.experiment.impl.constants.FormParamName;
import ml.comet.experiment.impl.constants.QueryParamName;
import ml.comet.experiment.impl.http.Connection;
import ml.comet.experiment.impl.utils.AssetUtils;
import ml.comet.experiment.impl.utils.JsonUtils;
import ml.comet.experiment.model.AddExperimentTagsRest;
import ml.comet.experiment.model.AddGraphRest;
import ml.comet.experiment.model.CreateExperimentRequest;
import ml.comet.experiment.model.CreateExperimentResponse;
import ml.comet.experiment.model.ExperimentAssetListResponse;
import ml.comet.experiment.model.ExperimentMetadataRest;
import ml.comet.experiment.model.ExperimentStatusResponse;
import ml.comet.experiment.model.ExperimentTimeRequest;
import ml.comet.experiment.model.GetExperimentsResponse;
import ml.comet.experiment.model.GetGraphResponse;
import ml.comet.experiment.model.GetHtmlResponse;
import ml.comet.experiment.model.GetOutputResponse;
import ml.comet.experiment.model.GetProjectsResponse;
import ml.comet.experiment.model.GetWorkspacesResponse;
import ml.comet.experiment.model.GitMetadata;
import ml.comet.experiment.model.GitMetadataRest;
import ml.comet.experiment.model.HtmlRest;
import ml.comet.experiment.model.LogDataResponse;
import ml.comet.experiment.model.LogOtherRest;
import ml.comet.experiment.model.MetricRest;
import ml.comet.experiment.model.MinMaxResponse;
import ml.comet.experiment.model.OutputUpdate;
import ml.comet.experiment.model.ParameterRest;
import ml.comet.experiment.model.TagsResponse;

final class RestApiClient
implements Disposable {
    private Connection connection;
    private boolean disposed;
    static final IllegalStateException ALREADY_DISPOSED = new IllegalStateException("REST API client already disposed");

    RestApiClient(Connection connection) {
        this.connection = connection;
    }

    Single<GetWorkspacesResponse> getAllWorkspaces() {
        return this.singleFromSyncGet("/api/rest/v2/workspaces", Collections.emptyMap(), GetWorkspacesResponse.class);
    }

    Single<GetProjectsResponse> getAllProjects(String workspaceName) {
        return this.singleFromSyncGet("/api/rest/v2/projects", Collections.singletonMap(QueryParamName.WORKSPACE_NAME, workspaceName), GetProjectsResponse.class);
    }

    Single<GetExperimentsResponse> getAllExperiments(String projectId) {
        return this.singleFromSyncGet("/api/rest/v2/experiments", Collections.singletonMap(QueryParamName.PROJECT_ID, projectId), GetExperimentsResponse.class);
    }

    Single<ExperimentMetadataRest> getMetadata(String experimentKey) {
        return this.singleFromSyncGet("/api/rest/v2/experiment/metadata", experimentKey, ExperimentMetadataRest.class);
    }

    Single<GitMetadataRest> getGitMetadata(String experimentKey) {
        return this.singleFromSyncGet("/api/rest/v2/experiment/git/metadata", experimentKey, GitMetadataRest.class);
    }

    Single<GetHtmlResponse> getHtml(String experimentKey) {
        return this.singleFromSyncGet("/api/rest/v2/experiment/html", experimentKey, GetHtmlResponse.class);
    }

    Single<GetOutputResponse> getOutput(String experimentKey) {
        return this.singleFromSyncGet("/api/rest/v2/experiment/output", experimentKey, GetOutputResponse.class);
    }

    Single<GetGraphResponse> getGraph(String experimentKey) {
        return this.singleFromSyncGet("/api/rest/v2/experiment/graph", experimentKey, GetGraphResponse.class);
    }

    Single<MinMaxResponse> getParameters(String experimentKey) {
        return this.singleFromSyncGet("/api/rest/v2/experiment/parameters", experimentKey, MinMaxResponse.class);
    }

    Single<MinMaxResponse> getMetrics(String experimentKey) {
        return this.singleFromSyncGet("/api/rest/v2/experiment/metrics/summary", experimentKey, MinMaxResponse.class);
    }

    Single<MinMaxResponse> getLogOther(String experimentKey) {
        return this.singleFromSyncGet("/api/rest/v2/experiment/log-other", experimentKey, MinMaxResponse.class);
    }

    Single<TagsResponse> getTags(String experimentKey) {
        return this.singleFromSyncGet("/api/rest/v2/experiment/tags", experimentKey, TagsResponse.class);
    }

    Single<ExperimentAssetListResponse> getAssetList(final String experimentKey, final AssetType type) {
        HashMap<QueryParamName, String> params = new HashMap<QueryParamName, String>(){
            {
                this.put(QueryParamName.EXPERIMENT_KEY, experimentKey);
                this.put(QueryParamName.TYPE, type.type());
            }
        };
        return this.singleFromSyncGet("/api/rest/v2/experiment/asset/list", (Map<QueryParamName, String>)params, ExperimentAssetListResponse.class);
    }

    Single<ExperimentStatusResponse> sendExperimentStatus(String experimentKey) {
        return this.singleFromSyncGet("/api/rest/v2/write/experiment/set-status", experimentKey, ExperimentStatusResponse.class);
    }

    Single<LogDataResponse> logMetric(MetricRest request, String experimentKey) {
        request.setExperimentKey(experimentKey);
        return this.singleFromAsyncPost(request, "/api/rest/v2/write/experiment/metric", LogDataResponse.class);
    }

    Single<LogDataResponse> logParameter(ParameterRest request, String experimentKey) {
        request.setExperimentKey(experimentKey);
        return this.singleFromAsyncPost(request, "/api/rest/v2/write/experiment/parameter", LogDataResponse.class);
    }

    Single<LogDataResponse> logOutputLine(OutputUpdate request, String experimentKey) {
        request.setExperimentKey(experimentKey);
        return this.singleFromAsyncPost(request, "/api/rest/v2/write/experiment/output", LogDataResponse.class);
    }

    Single<LogDataResponse> logHtml(HtmlRest request, String experimentKey) {
        request.setExperimentKey(experimentKey);
        return this.singleFromAsyncPost(request, "/api/rest/v2/write/experiment/html", LogDataResponse.class);
    }

    Single<LogDataResponse> logOther(LogOtherRest request, String experimentKey) {
        request.setExperimentKey(experimentKey);
        return this.singleFromAsyncPost(request, "/api/rest/v2/write/experiment/log-other", LogDataResponse.class);
    }

    Single<LogDataResponse> addTag(AddExperimentTagsRest request, String experimentKey) {
        request.setExperimentKey(experimentKey);
        return this.singleFromAsyncPost(request, "/api/rest/v2/write/experiment/tags", LogDataResponse.class);
    }

    Single<LogDataResponse> logGraph(AddGraphRest request, String experimentKey) {
        request.setExperimentKey(experimentKey);
        return this.singleFromAsyncPost(request, "/api/rest/v2/write/experiment/graph", LogDataResponse.class);
    }

    Single<LogDataResponse> logStartEndTime(ExperimentTimeRequest request, String experimentKey) {
        request.setExperimentKey(experimentKey);
        return this.singleFromAsyncPost(request, "/api/rest/v2/write/experiment/set-start-end-time", LogDataResponse.class);
    }

    Single<LogDataResponse> logGitMetadata(GitMetadata request, String experimentKey) {
        request.setExperimentKey(experimentKey);
        return this.singleFromAsyncPost(request, "/api/rest/v2/write/experiment/git/metadata", LogDataResponse.class);
    }

    Single<CreateExperimentResponse> registerExperiment(CreateExperimentRequest request) {
        return this.singleFromSyncPost(request, "/api/rest/v2/write/experiment/create", true, CreateExperimentResponse.class);
    }

    Single<LogDataResponse> logAsset(Asset asset, String experimentKey) {
        Map<QueryParamName, String> queryParams = AssetUtils.assetQueryParameters(asset, experimentKey);
        Map<FormParamName, Object> formParams = AssetUtils.assetFormParameters(asset);
        if (asset.getFile() != null) {
            return this.singleFromAsyncPost(asset.getFile(), "/api/rest/v2/write/experiment/upload-asset", queryParams, formParams, LogDataResponse.class);
        }
        if (asset.getFileLikeData() != null) {
            return this.singleFromAsyncPost(asset.getFileLikeData(), "/api/rest/v2/write/experiment/upload-asset", queryParams, formParams, LogDataResponse.class);
        }
        LogDataResponse response = new LogDataResponse();
        response.setMsg("asset has no data");
        response.setCode(-1);
        return Single.just((Object)response);
    }

    Single<LogDataResponse> logRemoteAsset(RemoteAsset asset, String experimentKey) {
        Map<QueryParamName, String> queryParams = AssetUtils.assetQueryParameters(asset, experimentKey);
        queryParams.put(QueryParamName.IS_REMOTE, Boolean.valueOf(true).toString());
        Map<FormParamName, Object> formParams = AssetUtils.assetFormParameters(asset);
        formParams.put(FormParamName.LINK, asset.getLink().toASCIIString());
        return this.singleFromAsyncPost("/api/rest/v2/write/experiment/upload-asset", queryParams, formParams, LogDataResponse.class);
    }

    private <T> Single<T> singleFromAsyncPost(@NonNull String endpoint, @NonNull Map<QueryParamName, String> queryParams, @NonNull Map<FormParamName, Object> formParams, @NonNull Class<T> clazz) {
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        if (queryParams == null) {
            throw new NullPointerException("queryParams is marked non-null but is null");
        }
        if (formParams == null) {
            throw new NullPointerException("formParams is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (this.isDisposed()) {
            return Single.error((Throwable)ALREADY_DISPOSED);
        }
        return Single.fromFuture(this.connection.sendPostAsync(endpoint, queryParams, formParams)).onTerminateDetach().map(response -> JsonUtils.fromJson(response.getResponseBody(), clazz));
    }

    private <T> Single<T> singleFromAsyncPost(byte[] fileLikeData, @NonNull String endpoint, @NonNull Map<QueryParamName, String> queryParams, Map<FormParamName, Object> formParams, @NonNull Class<T> clazz) {
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        if (queryParams == null) {
            throw new NullPointerException("queryParams is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (this.isDisposed()) {
            return Single.error((Throwable)ALREADY_DISPOSED);
        }
        return Single.fromFuture(this.connection.sendPostAsync(fileLikeData, endpoint, queryParams, formParams)).onTerminateDetach().map(response -> JsonUtils.fromJson(response.getResponseBody(), clazz));
    }

    private <T> Single<T> singleFromAsyncPost(@NonNull File file, @NonNull String endpoint, @NonNull Map<QueryParamName, String> queryParams, Map<FormParamName, Object> formParams, @NonNull Class<T> clazz) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        if (queryParams == null) {
            throw new NullPointerException("queryParams is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (this.isDisposed()) {
            return Single.error((Throwable)ALREADY_DISPOSED);
        }
        return Single.fromFuture(this.connection.sendPostAsync(file, endpoint, queryParams, formParams)).onTerminateDetach().map(response -> JsonUtils.fromJson(response.getResponseBody(), clazz));
    }

    private <T> Single<T> singleFromAsyncPost(@NonNull Object payload, @NonNull String endpoint, @NonNull Class<T> clazz) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (this.isDisposed()) {
            return Single.error((Throwable)ALREADY_DISPOSED);
        }
        return Single.fromFuture(this.connection.sendPostAsync(JsonUtils.toJson(payload), endpoint)).onTerminateDetach().map(response -> JsonUtils.fromJson(response.getResponseBody(), clazz));
    }

    private <T> Single<T> singleFromSyncPost(@NonNull Object payload, @NonNull String endpoint, boolean throwOnFailure, @NonNull Class<T> clazz) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (this.isDisposed()) {
            return Single.error((Throwable)ALREADY_DISPOSED);
        }
        String request = JsonUtils.toJson(payload);
        return this.connection.sendPostWithRetries(request, endpoint, throwOnFailure).map(body -> Single.just(JsonUtils.fromJson(body, clazz))).orElse(Single.error((Throwable)new CometApiException(String.format("No response was returned by endpoint: %s", endpoint))));
    }

    private <T> Single<T> singleFromSyncGet(@NonNull String endpoint, @NonNull String experimentKey, @NonNull Class<T> clazz) {
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        if (experimentKey == null) {
            throw new NullPointerException("experimentKey is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return this.singleFromSyncGet(endpoint, Collections.singletonMap(QueryParamName.EXPERIMENT_KEY, experimentKey), clazz);
    }

    private <T> Single<T> singleFromSyncGet(@NonNull String endpoint, @NonNull Map<QueryParamName, String> params, @NonNull Class<T> clazz) {
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (this.isDisposed()) {
            return Single.error((Throwable)ALREADY_DISPOSED);
        }
        return this.connection.sendGetWithRetries(endpoint, params).map(body -> Single.just(JsonUtils.fromJson(body, clazz))).orElse(Single.error((Throwable)new CometApiException(String.format("No response was returned by endpoint: %s", endpoint))));
    }

    public void dispose() {
        this.disposed = true;
        this.connection = null;
    }

    public boolean isDisposed() {
        return this.disposed;
    }
}

