/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.impl.utils;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.NonNull;
import ml.comet.experiment.impl.asset.Asset;
import ml.comet.experiment.impl.asset.RemoteAsset;
import ml.comet.experiment.impl.constants.FormParamName;
import ml.comet.experiment.impl.constants.QueryParamName;
import ml.comet.experiment.impl.utils.CometUtils;
import ml.comet.experiment.impl.utils.FileUtils;
import ml.comet.experiment.impl.utils.JsonUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public final class AssetUtils {
    public static final String REMOTE_FILE_NAME_DEFAULT = "remote";

    public static Stream<Asset> walkFolderAssets(@NonNull File folder, boolean logFilePath, boolean recursive, boolean prefixWithFolderName) throws IOException {
        if (folder == null) {
            throw new NullPointerException("folder is marked non-null but is null");
        }
        return FileUtils.listFiles(folder, recursive).map(path -> AssetUtils.mapToFileAsset(folder, path, logFilePath, prefixWithFolderName));
    }

    public static RemoteAsset createRemoteAsset(@NonNull URI uri, Optional<String> fileName, boolean overwrite, Optional<Map<String, Object>> metadata) {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        RemoteAsset asset = new RemoteAsset();
        asset.setLink(uri);
        asset.setOverwrite(overwrite);
        metadata.ifPresent(asset::setMetadata);
        asset.setFileName(fileName.orElse(AssetUtils.remoteAssetFileName(uri)));
        return asset;
    }

    public static Map<QueryParamName, String> assetQueryParameters(@NonNull Asset asset, @NonNull String experimentKey) {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        if (experimentKey == null) {
            throw new NullPointerException("experimentKey is marked non-null but is null");
        }
        HashMap<QueryParamName, String> queryParams = new HashMap<QueryParamName, String>();
        queryParams.put(QueryParamName.EXPERIMENT_KEY, experimentKey);
        queryParams.put(QueryParamName.TYPE, asset.getType().type());
        CometUtils.putNotNull(queryParams, QueryParamName.OVERWRITE, asset.getOverwrite());
        CometUtils.putNotNull(queryParams, QueryParamName.FILE_NAME, asset.getFileName());
        CometUtils.putNotNull(queryParams, QueryParamName.EXTENSION, asset.getFileExtension());
        CometUtils.putNotNull(queryParams, QueryParamName.CONTEXT, asset.getContext());
        CometUtils.putNotNull(queryParams, QueryParamName.STEP, asset.getStep());
        CometUtils.putNotNull(queryParams, QueryParamName.EPOCH, asset.getEpoch());
        return queryParams;
    }

    public static Map<FormParamName, Object> assetFormParameters(@NonNull Asset asset) {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        HashMap<FormParamName, Object> map = new HashMap<FormParamName, Object>();
        if (asset.getMetadata() != null) {
            map.put(FormParamName.METADATA, JsonUtils.toJson(asset.getMetadata()));
        }
        return map;
    }

    static String remoteAssetFileName(URI uri) {
        String fileName = uri.getPath();
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return REMOTE_FILE_NAME_DEFAULT;
        }
        int lastSlashIndex = fileName.lastIndexOf("/");
        if (lastSlashIndex >= 0) {
            return fileName.substring(lastSlashIndex + 1);
        }
        return fileName;
    }

    static Asset mapToFileAsset(@NonNull File folder, @NonNull Path assetPath, boolean logFilePath, boolean prefixWithFolderName) {
        if (folder == null) {
            throw new NullPointerException("folder is marked non-null but is null");
        }
        if (assetPath == null) {
            throw new NullPointerException("assetPath is marked non-null but is null");
        }
        Asset asset = new Asset();
        asset.setFile(assetPath.toFile());
        String fileName = FileUtils.resolveAssetFileName(folder, assetPath, logFilePath, prefixWithFolderName);
        asset.setFileName(fileName);
        asset.setFileExtension(FilenameUtils.getExtension((String)fileName));
        return asset;
    }

    private AssetUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

