/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.impl.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.stream.Stream;

public final class FileUtils {
    public static Stream<Path> listFiles(File folder, boolean recursive) throws IOException {
        ArrayList res;
        if (recursive) {
            try (Stream<Path> files = Files.walk(folder.toPath(), new FileVisitOption[0]);){
                res = files.collect(ArrayList::new, (paths, path) -> {
                    if (!path.toFile().isDirectory()) {
                        paths.add(path);
                    }
                }, ArrayList::addAll);
            }
        }
        res = new ArrayList();
        try (DirectoryStream<Path> files = Files.newDirectoryStream(folder.toPath());){
            files.forEach(path -> {
                if (!path.toFile().isDirectory()) {
                    res.add(path);
                }
            });
        }
        return res.stream().sorted(Comparator.naturalOrder());
    }

    static String resolveAssetFileName(File folder, Path path, boolean logFilePath, boolean prefixWithFolderName) {
        if (logFilePath) {
            Path filePath = folder.toPath().relativize(path);
            if (prefixWithFolderName) {
                filePath = folder.toPath().getFileName().resolve(filePath);
            }
            return filePath.toString();
        }
        return path.getFileName().toString();
    }

    private FileUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

