/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.artifact;

import lombok.NonNull;

public final class GetArtifactOptions {
    private String workspace;
    private String project;
    private String artifactName;
    private String artifactId;
    private String versionId;
    private String version;
    private String alias;
    private String versionOrAlias;
    private String consumerExperimentKey;

    GetArtifactOptions() {
    }

    public static GetArtifactOptionsBuilder Op() {
        return new GetArtifactOptionsBuilder();
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public String getProject() {
        return this.project;
    }

    public String getArtifactName() {
        return this.artifactName;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getVersionOrAlias() {
        return this.versionOrAlias;
    }

    public String getConsumerExperimentKey() {
        return this.consumerExperimentKey;
    }

    public String toString() {
        return "GetArtifactOptions(workspace=" + this.getWorkspace() + ", project=" + this.getProject() + ", artifactName=" + this.getArtifactName() + ", artifactId=" + this.getArtifactId() + ", versionId=" + this.getVersionId() + ", version=" + this.getVersion() + ", alias=" + this.getAlias() + ", versionOrAlias=" + this.getVersionOrAlias() + ", consumerExperimentKey=" + this.getConsumerExperimentKey() + ")";
    }

    public static final class GetArtifactOptionsBuilder {
        final GetArtifactOptions options = new GetArtifactOptions();

        GetArtifactOptionsBuilder() {
        }

        public GetArtifactOptionsBuilder workspaceName(@NonNull String workspace) {
            if (workspace == null) {
                throw new NullPointerException("workspace is marked non-null but is null");
            }
            this.options.workspace = workspace;
            return this;
        }

        public GetArtifactOptionsBuilder projectName(@NonNull String project) {
            if (project == null) {
                throw new NullPointerException("project is marked non-null but is null");
            }
            this.options.project = project;
            return this;
        }

        public GetArtifactOptionsBuilder name(@NonNull String artifactName) {
            if (artifactName == null) {
                throw new NullPointerException("artifactName is marked non-null but is null");
            }
            this.parseArtifactName(artifactName);
            return this;
        }

        public GetArtifactOptionsBuilder fullName(@NonNull String fullArtifactName) {
            if (fullArtifactName == null) {
                throw new NullPointerException("fullArtifactName is marked non-null but is null");
            }
            this.parseArtifactName(fullArtifactName);
            return this;
        }

        public GetArtifactOptionsBuilder artifactId(@NonNull String artifactId) {
            if (artifactId == null) {
                throw new NullPointerException("artifactId is marked non-null but is null");
            }
            this.options.artifactId = artifactId;
            return this;
        }

        public GetArtifactOptionsBuilder version(@NonNull String version) {
            if (version == null) {
                throw new NullPointerException("version is marked non-null but is null");
            }
            this.options.version = version;
            return this;
        }

        public GetArtifactOptionsBuilder versionId(@NonNull String versionId) {
            if (versionId == null) {
                throw new NullPointerException("versionId is marked non-null but is null");
            }
            this.options.versionId = versionId;
            return this;
        }

        public GetArtifactOptionsBuilder alias(@NonNull String alias) {
            if (alias == null) {
                throw new NullPointerException("alias is marked non-null but is null");
            }
            this.options.alias = alias;
            return this;
        }

        public GetArtifactOptionsBuilder versionOrAlias(@NonNull String versionOrAlias) {
            if (versionOrAlias == null) {
                throw new NullPointerException("versionOrAlias is marked non-null but is null");
            }
            this.options.versionOrAlias = versionOrAlias;
            return this;
        }

        public GetArtifactOptionsBuilder consumerExperimentKey(@NonNull String consumerExperimentKey) {
            if (consumerExperimentKey == null) {
                throw new NullPointerException("consumerExperimentKey is marked non-null but is null");
            }
            this.options.consumerExperimentKey = consumerExperimentKey;
            return this;
        }

        public GetArtifactOptions build() {
            return this.options;
        }

        void parseArtifactName(String name) {
            String nameAndVersion;
            String[] parts = name.split("/");
            if (parts.length == 1) {
                nameAndVersion = parts[0];
            } else {
                this.options.workspace = parts[0];
                nameAndVersion = parts[1];
            }
            parts = nameAndVersion.split(":");
            this.options.artifactName = parts[0];
            if (parts.length > 1) {
                this.options.versionOrAlias = parts[1];
            }
        }
    }
}

