/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.exception;

import ml.comet.experiment.exception.CometGeneralException;

public class CometApiException
extends CometGeneralException {
    private int sdkErrorCode;
    private int statusCode;
    private String statusMessage;

    public CometApiException(String message) {
        super(message);
    }

    public CometApiException(int statusCode, String statusMessage, int sdkErrorCode) {
        super(String.format("Remote endpoint returned error status code: %d, message: %s, sdk error code: %d", statusCode, statusMessage, sdkErrorCode));
        this.sdkErrorCode = sdkErrorCode;
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
    }

    public CometApiException(String message, Throwable cause) {
        super(message, cause);
    }

    public CometApiException(String format, Object ... args) {
        super(String.format(format, args));
    }

    public boolean hasErrorCode() {
        return this.sdkErrorCode > 0;
    }

    public int getSdkErrorCode() {
        return this.sdkErrorCode;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }
}

