/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.impl;

import com.vdurmont.semver4j.Semver;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import lombok.NonNull;
import ml.comet.experiment.artifact.ArtifactAsset;
import ml.comet.experiment.artifact.ConflictingArtifactAssetNameException;
import ml.comet.experiment.artifact.DownloadedArtifact;
import ml.comet.experiment.artifact.LoggedArtifactAsset;
import ml.comet.experiment.impl.ArtifactImpl;
import ml.comet.experiment.impl.LoggedArtifactAssetImpl;
import ml.comet.experiment.impl.LoggedArtifactImpl;
import ml.comet.experiment.impl.asset.ArtifactAssetImpl;
import ml.comet.experiment.impl.resources.LogMessages;
import ml.comet.experiment.impl.utils.ArtifactUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DownloadedArtifactImpl
extends ArtifactImpl
implements DownloadedArtifact {
    private final Logger logger = LoggerFactory.getLogger(DownloadedArtifact.class);
    private String artifactId;
    private String workspace;
    private final Set<String> downloadedAssetsIdentifiers = new HashSet<String>();

    DownloadedArtifactImpl(String name, String type, String version) {
        super(name, type);
        this.semanticVersion = new Semver(version);
    }

    DownloadedArtifactImpl(LoggedArtifactImpl loggedArtifact) {
        this(loggedArtifact.getName(), loggedArtifact.getType(), loggedArtifact.getVersion());
        this.setMetadata(loggedArtifact.getMetadata());
        this.artifactId = loggedArtifact.getArtifactId();
        this.aliases = loggedArtifact.getAliases();
        this.versionTags = loggedArtifact.getVersionTags();
        this.workspace = loggedArtifact.getWorkspace();
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public String getName() {
        return super.getName();
    }

    @Override
    public String getFullName() {
        return ArtifactUtils.artifactFullName(this.workspace, this.getName(), this.getVersion());
    }

    @Override
    public String getArtifactType() {
        return super.getType();
    }

    @Override
    public String getWorkspace() {
        return this.workspace;
    }

    @Override
    public String getVersion() {
        return this.semanticVersion.getValue();
    }

    @Override
    public boolean setVersion(String version) {
        Semver newVersion = new Semver(version);
        boolean valid = newVersion.isGreaterThan(this.semanticVersion);
        if (!valid) {
            this.logger.warn(LogMessages.getString("FAILED_TO_SET_ARTIFACT_VERSION_LEQ_THAN_CURRENT", version, this.semanticVersion.getValue()));
        }
        this.semanticVersion = newVersion;
        return valid;
    }

    @Override
    public String incrementMinorVersion() {
        this.semanticVersion = this.semanticVersion.nextMinor();
        return this.getVersion();
    }

    @Override
    public String incrementMajorVersion() {
        this.semanticVersion = this.semanticVersion.nextMajor();
        return this.getVersion();
    }

    @Override
    public String incrementPatchVersion() {
        this.semanticVersion = this.semanticVersion.nextPatch();
        return this.getVersion();
    }

    void addLoggedAssets(@NonNull Collection<LoggedArtifactAsset> assets) {
        if (assets == null) {
            throw new NullPointerException("assets is marked non-null but is null");
        }
        assets.forEach(this::appendAsset);
    }

    private void appendAsset(@NonNull LoggedArtifactAsset asset) {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        ArtifactAssetImpl artifactAsset = new ArtifactAssetImpl((LoggedArtifactAssetImpl)asset);
        this.appendAsset(artifactAsset);
        this.downloadedAssetsIdentifiers.add(asset.getLogicalPath());
    }

    @Override
    <T extends ArtifactAsset> void appendAsset(@NonNull T asset) throws ConflictingArtifactAssetNameException {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        String key = asset.getLogicalPath();
        ArtifactAsset a = (ArtifactAsset)this.assetsMap.get(key);
        if (a != null && !this.downloadedAssetsIdentifiers.contains(key)) {
            throw new ConflictingArtifactAssetNameException(LogMessages.getString("CONFLICTING_ARTIFACT_ASSET_NAME", asset, key, a));
        }
        this.assetsMap.put(key, asset);
    }

    void updateAsset(@NonNull ArtifactAsset asset) {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        String key = asset.getLogicalPath();
        this.assetsMap.put(key, asset);
    }

    @Override
    Logger getLogger() {
        return this.logger;
    }
}

