/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.impl;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import lombok.NonNull;
import ml.comet.experiment.artifact.ArtifactAssetNotFoundException;
import ml.comet.experiment.artifact.ArtifactDownloadException;
import ml.comet.experiment.artifact.ArtifactException;
import ml.comet.experiment.artifact.AssetOverwriteStrategy;
import ml.comet.experiment.artifact.DownloadedArtifact;
import ml.comet.experiment.artifact.LoggedArtifact;
import ml.comet.experiment.artifact.LoggedArtifactAsset;
import ml.comet.experiment.impl.BaseArtifactImpl;
import ml.comet.experiment.impl.BaseExperiment;
import ml.comet.experiment.impl.DownloadedArtifactImpl;
import ml.comet.experiment.impl.LoggedArtifactAssetImpl;
import ml.comet.experiment.impl.asset.ArtifactAssetImpl;
import ml.comet.experiment.impl.resources.LogMessages;
import ml.comet.experiment.impl.utils.ArtifactUtils;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoggedArtifactImpl
extends BaseArtifactImpl
implements LoggedArtifact {
    private final Logger logger = LoggerFactory.getLogger(LoggedArtifact.class);
    Set<String> artifactTags;
    long sizeInBytes;
    String experimentKey;
    String workspace;
    String artifactVersionId;
    String artifactId;
    final BaseExperiment baseExperiment;

    LoggedArtifactImpl(String name, String type, BaseExperiment baseExperiment) {
        super(name, type);
        this.baseExperiment = baseExperiment;
    }

    @Override
    public Set<String> getArtifactTags() {
        if (this.artifactTags == null) {
            return new HashSet<String>();
        }
        return this.artifactTags;
    }

    @Override
    public String getArtifactType() {
        return this.getType();
    }

    @Override
    public long getSize() {
        return this.sizeInBytes;
    }

    @Override
    public String getSourceExperimentKey() {
        return this.experimentKey;
    }

    @Override
    public String getVersion() {
        if (this.semanticVersion != null) {
            return this.semanticVersion.getValue();
        }
        return "";
    }

    @Override
    public String getWorkspace() {
        return this.workspace;
    }

    @Override
    public String getVersionId() {
        return this.artifactVersionId;
    }

    @Override
    public String getFullName() {
        return ArtifactUtils.artifactFullName(this.getWorkspace(), this.getName(), this.getVersion());
    }

    @Override
    public Collection<LoggedArtifactAsset> getRemoteAssets() throws ArtifactException {
        return this.baseExperiment.readArtifactAssets(this).stream().filter(LoggedArtifactAsset::isRemote).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
    }

    @Override
    public Collection<LoggedArtifactAsset> getAssets() throws ArtifactException {
        return this.baseExperiment.readArtifactAssets(this);
    }

    @Override
    public LoggedArtifactAsset getAsset(String assetLogicalPath) throws ArtifactException {
        Collection<LoggedArtifactAsset> assets = this.baseExperiment.readArtifactAssets(this);
        for (LoggedArtifactAsset asset : assets) {
            if (!Objects.equals(assetLogicalPath, asset.getLogicalPath())) continue;
            return asset;
        }
        throw new ArtifactAssetNotFoundException(LogMessages.getString("FAILED_TO_FIND_ASSET_IN_ARTIFACT", assetLogicalPath, this.getFullName()));
    }

    @Override
    public DownloadedArtifact download(Path folder) {
        return this.download(folder, AssetOverwriteStrategy.FAIL_IF_DIFFERENT);
    }

    @Override
    public DownloadedArtifact download(@NonNull Path folder, @NonNull AssetOverwriteStrategy overwriteStrategy) throws ArtifactException {
        if (folder == null) {
            throw new NullPointerException("folder is marked non-null but is null");
        }
        if (overwriteStrategy == null) {
            throw new NullPointerException("overwriteStrategy is marked non-null but is null");
        }
        DownloadedArtifactImpl artifact = new DownloadedArtifactImpl(this);
        Collection<LoggedArtifactAsset> assets = this.getAssets();
        artifact.addLoggedAssets(assets);
        int assetsToDownload = assets.stream().filter(loggedArtifactAsset -> !loggedArtifactAsset.isRemote()).mapToInt(value -> 1).sum();
        if (assetsToDownload == 0) {
            this.logger.warn(LogMessages.getString("ARTIFACT_HAS_NO_ASSETS_TO_DOWNLOAD", this.getFullName()));
            return artifact;
        }
        this.logger.info(LogMessages.getString("START_DOWNLOAD_ARTIFACT_ASSETS", assetsToDownload));
        Observable observable = Observable.fromStream(assets.stream()).filter(loggedArtifactAsset -> !loggedArtifactAsset.isRemote()).flatMap(loggedArtifactAsset -> Observable.just((Object)loggedArtifactAsset).subscribeOn(Schedulers.io()).map(asset -> asset.download(folder, overwriteStrategy)), true);
        CompletableFuture result = new CompletableFuture();
        observable.doOnNext(artifact::updateAsset).ignoreElements().blockingSubscribe(() -> {
            this.logger.info(LogMessages.getString("ARTIFACT_ASSETS_DOWNLOAD_COMPLETED", this.getFullName(), assetsToDownload, folder));
            result.complete(null);
        }, throwable -> {
            this.logger.error(LogMessages.getString("FAILED_TO_DOWNLOAD_ARTIFACT_ASSETS", this.getFullName(), folder), throwable);
            result.completeExceptionally((Throwable)throwable);
        });
        try {
            result.get();
        }
        catch (ExecutionException ex) {
            throw new ArtifactException(LogMessages.getString("FAILED_TO_DOWNLOAD_ARTIFACT_ASSETS", this.getFullName(), folder), ex.getCause());
        }
        catch (InterruptedException ex) {
            throw new ArtifactException(LogMessages.getString("FAILED_TO_DOWNLOAD_ARTIFACT_ASSETS", this.getFullName(), folder), ex);
        }
        return artifact;
    }

    ArtifactAssetImpl downloadAsset(@NonNull LoggedArtifactAssetImpl asset, @NonNull Path dir, @NonNull Path file, @NonNull AssetOverwriteStrategy overwriteStrategy) throws ArtifactException {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        if (dir == null) {
            throw new NullPointerException("dir is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (overwriteStrategy == null) {
            throw new NullPointerException("overwriteStrategy is marked non-null but is null");
        }
        return this.baseExperiment.downloadArtifactAsset(asset, dir, file, overwriteStrategy);
    }

    void writeAssetTo(@NonNull LoggedArtifactAssetImpl asset, @NonNull OutputStream out) throws ArtifactException {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        if (out == null) {
            throw new NullPointerException("out is marked non-null but is null");
        }
        Path tmpDir = null;
        try {
            tmpDir = Files.createTempDirectory(null, new FileAttribute[0]);
            Path file = FileSystems.getDefault().getPath(asset.getLogicalPath(), new String[0]);
            ArtifactAssetImpl downloaded = this.downloadAsset(asset, tmpDir, file, AssetOverwriteStrategy.OVERWRITE);
            Files.copy(downloaded.getRawFile().toPath(), out);
            out.flush();
        }
        catch (IOException e) {
            this.logger.error("Failed to create temporary file to store content of the asset {}.", (Object)asset, (Object)e);
            throw new ArtifactDownloadException("Failed to create temporary file to store asset's content.", e);
        }
        finally {
            if (tmpDir != null) {
                try {
                    FileUtils.deleteDirectory((File)tmpDir.toFile());
                }
                catch (IOException e) {
                    this.logger.warn("Failed to clean the temporary directory while loading asset's content.", (Throwable)e);
                }
            }
        }
    }

    InputStream openAssetStream(@NonNull LoggedArtifactAssetImpl asset) throws ArtifactException {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        try {
            Path tmpDir = Files.createTempDirectory(null, new FileAttribute[0]);
            Path file = FileSystems.getDefault().getPath(asset.getLogicalPath(), new String[0]);
            file.toFile().deleteOnExit();
            ArtifactAssetImpl downloaded = this.downloadAsset(asset, tmpDir, file, AssetOverwriteStrategy.OVERWRITE);
            return Files.newInputStream(downloaded.getRawFile().toPath(), StandardOpenOption.READ);
        }
        catch (IOException e) {
            this.logger.error("Failed to create temporary file to store content of the asset {}.", (Object)asset, (Object)e);
            throw new ArtifactDownloadException("Failed to create temporary file to store asset's content.", e);
        }
    }

    public String toString() {
        return "LoggedArtifactImpl(experimentKey=" + this.experimentKey + ", workspace=" + this.getWorkspace() + ", artifactVersionId=" + this.artifactVersionId + ", artifactId=" + this.getArtifactId() + ")";
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    public void setArtifactTags(Set<String> artifactTags) {
        this.artifactTags = artifactTags;
    }

    public void setSizeInBytes(long sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
    }

    public void setExperimentKey(String experimentKey) {
        this.experimentKey = experimentKey;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public void setArtifactVersionId(String artifactVersionId) {
        this.artifactVersionId = artifactVersionId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }
}

