/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.impl.asset;

import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import ml.comet.experiment.artifact.ArtifactAsset;
import ml.comet.experiment.impl.LoggedArtifactAssetImpl;
import ml.comet.experiment.impl.asset.AssetImpl;
import ml.comet.experiment.impl.asset.RemoteAssetImpl;

public final class ArtifactAssetImpl
extends RemoteAssetImpl
implements ArtifactAsset {
    String artifactVersionId;
    Long fileSize;

    public ArtifactAssetImpl(String name, Path filePath, long size, Map<String, Object> metadata, String assetType) {
        this.setLogicalPath(name);
        this.setRawFile(filePath.toFile());
        this.fileSize = size;
        this.metadata = metadata;
        this.setType(assetType);
    }

    public ArtifactAssetImpl(AssetImpl asset) {
        this.setRawFile(asset.getRawFile());
        this.setRawFileLikeData(asset.getRawFileLikeData());
        this.setFileExtension(asset.getFileExtension());
        this.logicalPath = asset.getLogicalPath();
        this.type = asset.getType();
        this.overwrite = asset.getOverwrite();
        this.metadata = asset.getMetadata();
    }

    public ArtifactAssetImpl(RemoteAssetImpl asset) {
        this.setUri(asset.getUri());
        this.logicalPath = asset.getLogicalPath();
        this.type = asset.getType();
        this.overwrite = asset.getOverwrite();
        this.metadata = asset.getMetadata();
    }

    public ArtifactAssetImpl(LoggedArtifactAssetImpl asset) {
        if (asset.getLink().isPresent()) {
            this.setUri(asset.getLink().get());
        }
        if (asset.getSize().isPresent()) {
            this.fileSize = asset.getSize().get();
        }
        this.logicalPath = asset.getLogicalPath();
        this.type = asset.getAssetType();
        this.metadata = asset.getMetadata();
        this.artifactVersionId = asset.getArtifactVersionId();
    }

    @Override
    public Optional<Long> getSize() {
        return Optional.ofNullable(this.fileSize);
    }

    @Override
    public boolean isRemote() {
        return this.getLink().isPresent();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArtifactAssetImpl)) {
            return false;
        }
        ArtifactAssetImpl other = (ArtifactAssetImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$fileSize = this.fileSize;
        Long other$fileSize = other.fileSize;
        if (this$fileSize == null ? other$fileSize != null : !((Object)this$fileSize).equals(other$fileSize)) {
            return false;
        }
        String this$artifactVersionId = this.getArtifactVersionId();
        String other$artifactVersionId = other.getArtifactVersionId();
        return !(this$artifactVersionId == null ? other$artifactVersionId != null : !this$artifactVersionId.equals(other$artifactVersionId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ArtifactAssetImpl;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $fileSize = this.fileSize;
        result = result * 59 + ($fileSize == null ? 43 : ((Object)$fileSize).hashCode());
        String $artifactVersionId = this.getArtifactVersionId();
        result = result * 59 + ($artifactVersionId == null ? 43 : $artifactVersionId.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ArtifactAssetImpl(super=" + super.toString() + ", artifactVersionId=" + this.getArtifactVersionId() + ", fileSize=" + this.fileSize + ")";
    }

    public String getArtifactVersionId() {
        return this.artifactVersionId;
    }

    public void setArtifactVersionId(String artifactVersionId) {
        this.artifactVersionId = artifactVersionId;
    }
}

