/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.impl;

import io.reactivex.rxjava3.core.Observable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.zip.ZipInputStream;
import lombok.NonNull;
import ml.comet.experiment.CometApi;
import ml.comet.experiment.builder.BaseCometBuilder;
import ml.comet.experiment.builder.CometApiBuilder;
import ml.comet.experiment.exception.CometApiException;
import ml.comet.experiment.impl.RegistryModelImpl;
import ml.comet.experiment.impl.RestApiClient;
import ml.comet.experiment.impl.config.CometConfig;
import ml.comet.experiment.impl.http.Connection;
import ml.comet.experiment.impl.http.ConnectionInitializer;
import ml.comet.experiment.impl.resources.LogMessages;
import ml.comet.experiment.impl.rest.ExperimentModelListResponse;
import ml.comet.experiment.impl.rest.ExperimentModelResponse;
import ml.comet.experiment.impl.rest.GetExperimentsResponse;
import ml.comet.experiment.impl.rest.GetProjectsResponse;
import ml.comet.experiment.impl.rest.GetWorkspacesResponse;
import ml.comet.experiment.impl.rest.RegistryModelCreateRequest;
import ml.comet.experiment.impl.rest.RegistryModelCreateResponse;
import ml.comet.experiment.impl.rest.RegistryModelItemCreateRequest;
import ml.comet.experiment.impl.rest.RegistryModelItemCreateResponse;
import ml.comet.experiment.impl.rest.RegistryModelOverviewListResponse;
import ml.comet.experiment.impl.rest.RestApiResponse;
import ml.comet.experiment.impl.utils.CometUtils;
import ml.comet.experiment.impl.utils.ModelUtils;
import ml.comet.experiment.impl.utils.RestApiUtils;
import ml.comet.experiment.impl.utils.ZipUtils;
import ml.comet.experiment.model.ExperimentMetadata;
import ml.comet.experiment.model.Project;
import ml.comet.experiment.registrymodel.DownloadModelOptions;
import ml.comet.experiment.registrymodel.Model;
import ml.comet.experiment.registrymodel.ModelDownloadInfo;
import ml.comet.experiment.registrymodel.ModelNotFoundException;
import ml.comet.experiment.registrymodel.ModelRegistryRecord;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CometApiImpl
implements CometApi {
    private Logger logger = LoggerFactory.getLogger(CometApiImpl.class);
    private final String apiKey;
    private final String baseUrl;
    private final int maxAuthRetries;
    private RestApiClient restApiClient;
    private Connection connection;

    CometApiImpl(@NonNull String apiKey, @NonNull String baseUrl, int maxAuthRetries, Logger logger) {
        if (apiKey == null) {
            throw new NullPointerException("apiKey is marked non-null but is null");
        }
        if (baseUrl == null) {
            throw new NullPointerException("baseUrl is marked non-null but is null");
        }
        this.apiKey = apiKey;
        this.baseUrl = baseUrl;
        this.maxAuthRetries = maxAuthRetries;
        if (logger != null) {
            this.logger = logger;
        }
    }

    @Override
    public List<String> getAllWorkspaces() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getAllWorkspaces invoked");
        }
        return ((GetWorkspacesResponse)this.restApiClient.getAllWorkspaces().doOnError(ex -> this.logger.error("Failed to read workspaces for the current user", ex)).blockingGet()).getWorkspaceNames();
    }

    @Override
    public List<Project> getAllProjects(@NonNull String workspaceName) {
        if (workspaceName == null) {
            throw new NullPointerException("workspaceName is marked non-null but is null");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getAllProjects invoked");
        }
        return ((GetProjectsResponse)this.restApiClient.getAllProjects(workspaceName).doOnError(ex -> this.logger.error("Failed to read projects in the workspace {}", (Object)workspaceName, ex)).blockingGet()).getProjects().stream().collect(ArrayList::new, (projects, restProject) -> projects.add(restProject.toProject()), ArrayList::addAll);
    }

    @Override
    public List<ExperimentMetadata> getAllExperiments(@NonNull String projectId) {
        if (projectId == null) {
            throw new NullPointerException("projectId is marked non-null but is null");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getAllExperiments invoked");
        }
        return ((GetExperimentsResponse)this.restApiClient.getAllExperiments(projectId).doOnError(ex -> this.logger.error("Failed to read experiments found in the project {}", (Object)projectId, ex)).blockingGet()).getExperiments().stream().collect(ArrayList::new, (metadataList, metadataRest) -> metadataList.add(metadataRest.toExperimentMetadata()), ArrayList::addAll);
    }

    @Override
    public ModelRegistryRecord registerModel(@NonNull Model model, @NonNull String experimentKey) {
        ModelRegistryRecord registry;
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (experimentKey == null) {
            throw new NullPointerException("experimentKey is marked non-null but is null");
        }
        List experimentModels = (List)this.restApiClient.getExperimentModels(experimentKey).map(ExperimentModelListResponse::getModels).blockingGet();
        if (experimentModels == null || experimentModels.size() == 0) {
            throw new ModelNotFoundException(LogMessages.getString("EXPERIMENT_HAS_NO_MODELS", experimentKey));
        }
        Optional<ExperimentModelResponse> details = experimentModels.stream().filter(modelResponse -> Objects.equals(modelResponse.getModelName(), model.getName())).findFirst();
        if (!details.isPresent()) {
            String names = experimentModels.stream().map(ExperimentModelResponse::getModelName).collect(Collectors.joining(", "));
            throw new ModelNotFoundException(LogMessages.getString("FAILED_TO_FIND_EXPERIMENT_MODEL_BY_NAME", model.getName(), names));
        }
        RegistryModelImpl modelImpl = (RegistryModelImpl)model;
        modelImpl.setExperimentModelId(details.get().getExperimentModelId());
        Boolean modelInRegistry = (Boolean)this.restApiClient.getMetadata(experimentKey).concatMap(experimentMetadataRest -> {
            modelImpl.setWorkspace(experimentMetadataRest.getWorkspaceName());
            return this.restApiClient.getRegistryModelsForWorkspace(experimentMetadataRest.getWorkspaceName());
        }).map(RegistryModelOverviewListResponse::getRegistryModels).flatMapObservable(Observable::fromIterable).any(registryModel -> Objects.equals(registryModel.getModelName(), model.getRegistryName())).blockingGet();
        if (modelInRegistry.booleanValue()) {
            if (StringUtils.isNotBlank((CharSequence)modelImpl.getDescription())) {
                this.logger.warn(LogMessages.getString("UPDATE_REGISTRY_MODEL_DESCRIPTION_IGNORED"));
            }
            if (modelImpl.getIsPublic() != null) {
                this.logger.warn(LogMessages.getString("UPDATE_REGISTRY_MODEL_IS_PUBLIC_IGNORED"));
            }
            RegistryModelItemCreateRequest request = RestApiUtils.createRegistryModelItemCreateRequest(modelImpl);
            registry = ((RegistryModelItemCreateResponse)this.restApiClient.createRegistryModelItem(request).blockingGet()).toModelRegistry();
            this.logger.info(LogMessages.getString("MODEL_VERSION_CREATED_IN_WORKSPACE", model.getVersion(), model.getRegistryName(), model.getWorkspace()));
        } else {
            RegistryModelCreateRequest request = RestApiUtils.createRegistryModelCreateRequest(modelImpl);
            registry = ((RegistryModelCreateResponse)this.restApiClient.createRegistryModel(request).blockingGet()).toModelRegistry();
            this.logger.info(LogMessages.getString("MODEL_REGISTERED_IN_WORKSPACE", model.getRegistryName(), model.getVersion(), model.getWorkspace()));
        }
        registry.setRegistryName(model.getRegistryName());
        return registry;
    }

    @Override
    public ModelDownloadInfo downloadRegistryModel(@NonNull Path outputPath, @NonNull String registryName, @NonNull String workspace, @NonNull DownloadModelOptions options) throws IOException {
        ModelDownloadInfo info;
        RestApiResponse response;
        if (outputPath == null) {
            throw new NullPointerException("outputPath is marked non-null but is null");
        }
        if (registryName == null) {
            throw new NullPointerException("registryName is marked non-null but is null");
        }
        if (workspace == null) {
            throw new NullPointerException("workspace is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        this.logger.info(LogMessages.getString("DOWNLOADING_REGISTRY_MODEL_PROMPT", registryName, options.getVersion(), options.getStage(), workspace));
        if (!options.isExpand()) {
            String fileName = ModelUtils.registryModelZipFileName(registryName, options);
            Path filePath = outputPath.resolve(fileName);
            this.logger.info(LogMessages.getString("DOWNLOADING_REGISTRY_MODEL_TO_FILE", filePath));
            response = this.downloadRegistryModelToFile(filePath, workspace, registryName, options);
            info = new ModelDownloadInfo(filePath, options);
        } else {
            this.logger.info(LogMessages.getString("DOWNLOADING_REGISTRY_MODEL_TO_DIR", outputPath));
            response = this.downloadRegistryModelToDir(outputPath, workspace, registryName, options);
            info = new ModelDownloadInfo(outputPath, options);
        }
        if (response.hasFailed()) {
            this.logger.info(LogMessages.getString("FAILED_TO_DOWNLOAD_REGISTRY_MODEL", response.getMsg(), response.getSdkErrorCode()));
            throw new CometApiException(LogMessages.getString("FAILED_TO_DOWNLOAD_REGISTRY_MODEL", response.getMsg(), response.getSdkErrorCode()));
        }
        return info;
    }

    @Override
    public ModelDownloadInfo downloadRegistryModel(@NonNull Path outputPath, @NonNull String registryName, @NonNull String workspace) throws IOException {
        if (outputPath == null) {
            throw new NullPointerException("outputPath is marked non-null but is null");
        }
        if (registryName == null) {
            throw new NullPointerException("registryName is marked non-null but is null");
        }
        if (workspace == null) {
            throw new NullPointerException("workspace is marked non-null but is null");
        }
        return this.downloadRegistryModel(outputPath, registryName, workspace, DownloadModelOptions.Op().build());
    }

    @Override
    public void close() throws IOException {
        if (Objects.nonNull(this.restApiClient)) {
            this.restApiClient.dispose();
        }
        if (Objects.nonNull(this.connection)) {
            this.connection.close();
        }
    }

    void init() {
        CometUtils.printCometSdkVersion();
        this.connection = ConnectionInitializer.initConnection(this.apiKey, this.baseUrl, this.maxAuthRetries, this.logger);
        this.restApiClient = new RestApiClient(this.connection);
    }

    RestApiClient getRestApiClient() {
        return this.restApiClient;
    }

    RestApiResponse downloadRegistryModelToFile(@NonNull Path filePath, @NonNull String workspace, @NonNull String registryName, @NonNull DownloadModelOptions options) throws IOException {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        if (workspace == null) {
            throw new NullPointerException("workspace is marked non-null but is null");
        }
        if (registryName == null) {
            throw new NullPointerException("registryName is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        try (OutputStream out = Files.newOutputStream(filePath, StandardOpenOption.CREATE_NEW);){
            RestApiResponse restApiResponse = (RestApiResponse)this.restApiClient.downloadRegistryModel(out, workspace, registryName, options).blockingGet();
            return restApiResponse;
        }
    }

    /*
     * Exception decompiling
     */
    RestApiResponse downloadRegistryModelToDir(@NonNull Path dirPath, @NonNull String workspace, @NonNull String registryName, @NonNull DownloadModelOptions options) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static CometApiBuilder builder() {
        return new CometApiBuilderImpl();
    }

    private /* synthetic */ RestApiResponse lambda$downloadRegistryModelToDir$9(Path dirPath, Integer numFiles, RestApiResponse apiResponse) throws Throwable {
        this.logger.info(LogMessages.getString("EXTRACTED_N_REGISTRY_MODEL_FILES", numFiles, dirPath));
        return apiResponse;
    }

    private static /* synthetic */ Integer lambda$downloadRegistryModelToDir$8(PipedInputStream pin, Path dirPath) throws Exception {
        try (ZipInputStream zis = new ZipInputStream(pin);){
            Integer n = ZipUtils.unzipToFolder(zis, dirPath);
            return n;
        }
    }

    static final class CometApiBuilderImpl
    implements CometApiBuilder {
        private String apiKey;
        private Logger logger;

        CometApiBuilderImpl() {
        }

        public CometApiBuilder withConfigOverride(@NonNull File overrideConfig) {
            if (overrideConfig == null) {
                throw new NullPointerException("overrideConfig is marked non-null but is null");
            }
            CometConfig.applyConfigOverride(overrideConfig);
            return this;
        }

        @Override
        public BaseCometBuilder<CometApi> withLogger(@NonNull Logger logger) {
            if (logger == null) {
                throw new NullPointerException("logger is marked non-null but is null");
            }
            this.logger = logger;
            return this;
        }

        public CometApiBuilder withApiKey(@NonNull String apiKey) {
            if (apiKey == null) {
                throw new NullPointerException("apiKey is marked non-null but is null");
            }
            this.apiKey = apiKey;
            return this;
        }

        @Override
        public CometApi build() {
            if (StringUtils.isBlank((CharSequence)this.apiKey)) {
                this.apiKey = CometConfig.COMET_API_KEY.getString();
            }
            CometApiImpl api = new CometApiImpl(this.apiKey, CometConfig.COMET_BASE_URL.getString(), CometConfig.COMET_MAX_AUTH_RETRIES.getInt(), this.logger);
            try {
                api.init();
            }
            catch (Throwable throwable) {
                api.close();
                throw throwable;
            }
            return api;
        }
    }
}

