/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.impl;

import java.io.File;
import java.time.Duration;
import lombok.NonNull;
import ml.comet.experiment.builder.OnlineExperimentBuilder;
import ml.comet.experiment.impl.OnlineExperimentImpl;
import ml.comet.experiment.impl.config.CometConfig;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

final class OnlineExperimentBuilderImpl
implements OnlineExperimentBuilder {
    private String projectName;
    private String workspace;
    private String apiKey;
    private String baseUrl;
    private int maxAuthRetries = -1;
    private String experimentName;
    private String experimentKey;
    private Logger logger;
    private boolean interceptStdout = false;

    OnlineExperimentBuilderImpl() {
    }

    @Override
    public OnlineExperimentBuilderImpl withProjectName(@NonNull String projectName) {
        if (projectName == null) {
            throw new NullPointerException("projectName is marked non-null but is null");
        }
        this.projectName = projectName;
        return this;
    }

    @Override
    public OnlineExperimentBuilderImpl withWorkspace(@NonNull String workspace) {
        if (workspace == null) {
            throw new NullPointerException("workspace is marked non-null but is null");
        }
        this.workspace = workspace;
        return this;
    }

    public OnlineExperimentBuilderImpl withApiKey(@NonNull String apiKey) {
        if (apiKey == null) {
            throw new NullPointerException("apiKey is marked non-null but is null");
        }
        this.apiKey = apiKey;
        return this;
    }

    @Override
    public OnlineExperimentBuilderImpl withMaxAuthRetries(int maxAuthRetries) {
        this.maxAuthRetries = maxAuthRetries;
        return this;
    }

    @Override
    public OnlineExperimentBuilderImpl withUrlOverride(@NonNull String urlOverride) {
        if (urlOverride == null) {
            throw new NullPointerException("urlOverride is marked non-null but is null");
        }
        this.baseUrl = urlOverride;
        return this;
    }

    @Override
    public OnlineExperimentBuilderImpl withExperimentName(@NonNull String experimentName) {
        if (experimentName == null) {
            throw new NullPointerException("experimentName is marked non-null but is null");
        }
        this.experimentName = experimentName;
        return this;
    }

    @Override
    public OnlineExperimentBuilderImpl withExistingExperimentKey(@NonNull String experimentKey) {
        if (experimentKey == null) {
            throw new NullPointerException("experimentKey is marked non-null but is null");
        }
        this.experimentKey = experimentKey;
        return this;
    }

    public OnlineExperimentBuilderImpl withLogger(@NonNull Logger logger) {
        if (logger == null) {
            throw new NullPointerException("logger is marked non-null but is null");
        }
        this.logger = logger;
        return this;
    }

    public OnlineExperimentBuilderImpl withConfigOverride(@NonNull File overrideConfig) {
        if (overrideConfig == null) {
            throw new NullPointerException("overrideConfig is marked non-null but is null");
        }
        CometConfig.applyConfigOverride(overrideConfig);
        return this;
    }

    @Override
    public OnlineExperimentBuilderImpl interceptStdout() {
        this.interceptStdout = true;
        return this;
    }

    @Override
    public OnlineExperimentImpl build() {
        if (StringUtils.isBlank((CharSequence)this.apiKey)) {
            this.apiKey = CometConfig.COMET_API_KEY.getString();
        }
        if (StringUtils.isBlank((CharSequence)this.projectName)) {
            this.projectName = CometConfig.COMET_PROJECT_NAME.getOptionalString().orElse(null);
        }
        if (StringUtils.isBlank((CharSequence)this.workspace)) {
            this.workspace = CometConfig.COMET_WORKSPACE_NAME.getOptionalString().orElse(null);
        }
        if (StringUtils.isBlank((CharSequence)this.baseUrl)) {
            this.baseUrl = CometConfig.COMET_BASE_URL.getString();
        }
        if (this.maxAuthRetries == -1) {
            this.maxAuthRetries = CometConfig.COMET_MAX_AUTH_RETRIES.getInt();
        }
        Duration cleaningTimeout = CometConfig.COMET_TIMEOUT_CLEANING_SECONDS.getDuration();
        OnlineExperimentImpl experiment = new OnlineExperimentImpl(this.apiKey, this.projectName, this.workspace, this.experimentName, this.experimentKey, this.logger, this.interceptStdout, this.baseUrl, this.maxAuthRetries, cleaningTimeout);
        try {
            experiment.init();
        }
        catch (Throwable ex) {
            experiment.end();
            throw ex;
        }
        return experiment;
    }
}

