/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.impl.http;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.NonNull;
import ml.comet.experiment.exception.CometApiException;
import ml.comet.experiment.exception.CometGeneralException;
import ml.comet.experiment.impl.constants.FormParamName;
import ml.comet.experiment.impl.constants.QueryParamName;
import ml.comet.experiment.impl.http.ConnectionUtils;
import ml.comet.experiment.impl.http.DownloadListener;
import ml.comet.experiment.impl.http.UploadListener;
import ml.comet.experiment.impl.rest.CometWebJavaSdkException;
import org.asynchttpclient.AsyncCompletionHandlerBase;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Request;
import org.asynchttpclient.Response;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.slf4j.Logger;

public final class Connection
implements Closeable {
    public static final int READ_TIMEOUT_MS = 600000;
    public static final int REQUEST_TIMEOUT_MS = 60000;
    public static final int CONNECTION_SHUTDOWN_TIMEOUT_MS = 5000;
    public static final String COMET_SDK_API_HEADER = "Comet-Sdk-Api";
    private static final String RESPONSE_NO_BODY = "NO BODY";
    private final AsyncHttpClient asyncHttpClient;
    private final String cometBaseUrl;
    private final String apiKey;
    private final Logger logger;
    private final int maxAuthRetries;
    private final AtomicInteger requestsInventory;

    public Connection(@NonNull String cometBaseUrl, @NonNull String apiKey, int maxAuthRetries, @NonNull Logger logger) {
        if (cometBaseUrl == null) {
            throw new NullPointerException("cometBaseUrl is marked non-null but is null");
        }
        if (apiKey == null) {
            throw new NullPointerException("apiKey is marked non-null but is null");
        }
        if (logger == null) {
            throw new NullPointerException("logger is marked non-null but is null");
        }
        this.cometBaseUrl = cometBaseUrl;
        this.apiKey = apiKey;
        this.logger = logger;
        this.maxAuthRetries = maxAuthRetries;
        this.requestsInventory = new AtomicInteger();
        DefaultAsyncHttpClientConfig conf = new DefaultAsyncHttpClientConfig.Builder().setReadTimeout(600000).setRequestTimeout(60000).setShutdownTimeout(5000).build();
        this.asyncHttpClient = Dsl.asyncHttpClient((AsyncHttpClientConfig)conf);
    }

    public Optional<String> sendGetWithRetries(@NonNull String endpoint, @NonNull Map<QueryParamName, String> params) {
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        return this.sendGetWithRetries(endpoint, params, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<String> sendGetWithRetries(@NonNull String endpoint, @NonNull Map<QueryParamName, String> params, boolean throwOnFailure) throws CometApiException {
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        try {
            this.requestsInventory.incrementAndGet();
            Optional<String> optional = this.executeRequestSyncWithRetries(ConnectionUtils.createGetRequest(this.buildCometUrl(endpoint), params), throwOnFailure);
            return optional;
        }
        finally {
            this.requestsInventory.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<String> sendPostWithRetries(@NonNull String json, @NonNull String endpoint, boolean throwOnFailure) throws CometApiException {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        String url = this.buildCometUrl(endpoint);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("sending JSON {} to {}", (Object)json, (Object)url);
        }
        try {
            this.requestsInventory.incrementAndGet();
            Optional<String> optional = this.executeRequestSyncWithRetries(ConnectionUtils.createPostJsonRequest(json, url), throwOnFailure);
            return optional;
        }
        finally {
            this.requestsInventory.decrementAndGet();
        }
    }

    public ListenableFuture<Response> sendPostAsync(@NonNull String json, @NonNull String endpoint) {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        return this.executeRequestAsync(ConnectionUtils.createPostJsonRequest(json, this.buildCometUrl(endpoint)));
    }

    public ListenableFuture<Response> sendPostAsync(@NonNull File file, @NonNull String endpoint, @NonNull Map<QueryParamName, String> queryParams, Map<FormParamName, Object> formParams) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        if (queryParams == null) {
            throw new NullPointerException("queryParams is marked non-null but is null");
        }
        return this.executeRequestAsync(ConnectionUtils.createPostFileRequest(file, this.buildCometUrl(endpoint), queryParams, formParams));
    }

    public ListenableFuture<Response> sendPostAsync(byte[] bytes, @NonNull String endpoint, @NonNull Map<QueryParamName, String> params, Map<FormParamName, Object> formParams) {
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        String url = this.buildCometUrl(endpoint);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("sending POST bytearray with length {} to {}", (Object)bytes.length, (Object)url);
        }
        return this.executeRequestAsync(ConnectionUtils.createPostByteArrayRequest(bytes, url, params, formParams));
    }

    public ListenableFuture<Response> sendPostAsync(@NonNull String endpoint, @NonNull Map<QueryParamName, String> params, @NonNull Map<FormParamName, Object> formParams) {
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        if (formParams == null) {
            throw new NullPointerException("formParams is marked non-null but is null");
        }
        String url = this.buildCometUrl(endpoint);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("sending POST form to {}", (Object)url);
        }
        return this.executeRequestAsync(ConnectionUtils.createPostFormRequest(url, params, formParams));
    }

    public ListenableFuture<Response> downloadAsync(@NonNull File file, @NonNull String endpoint, @NonNull Map<QueryParamName, String> params) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        Request request = ConnectionUtils.createGetRequest(this.buildCometUrl(endpoint), params);
        AsyncFileDownloadHandler handler = new AsyncFileDownloadHandler(file, this.logger);
        try {
            handler.open();
        }
        catch (Throwable e) {
            this.logger.error("Failed to start download to the file {}", (Object)file.getPath(), (Object)e);
            handler.close();
            return new ListenableFuture.CompletedFailure(e);
        }
        return this.executeDownloadAsync(request, handler);
    }

    public ListenableFuture<Response> downloadAsync(@NonNull OutputStream outputStream, @NonNull String endpoint, @NonNull Map<QueryParamName, String> params) {
        if (outputStream == null) {
            throw new NullPointerException("outputStream is marked non-null but is null");
        }
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        Request request = ConnectionUtils.createGetRequest(this.buildCometUrl(endpoint), params);
        return this.executeDownloadAsync(request, new AsyncOutputStreamDownloadHandler(outputStream, request.getUrl(), this.logger));
    }

    @Override
    public void close() throws IOException {
        this.asyncHttpClient.close();
    }

    public void waitAndClose(@NonNull Duration timeout) throws IOException {
        if (timeout == null) {
            throw new NullPointerException("timeout is marked non-null but is null");
        }
        try {
            Awaitility.await().atMost(timeout).pollInterval(100L, TimeUnit.MILLISECONDS).untilAtomic(this.requestsInventory, Matchers.is((Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(0))));
        }
        catch (ConditionTimeoutException e) {
            this.getLogger().error(String.format("Timeout exceeded while waiting for remaining requests to complete, remaining requests: %d", this.requestsInventory.get()), (Throwable)e);
        }
        finally {
            this.close();
        }
    }

    ListenableFuture<Response> executeDownloadAsync(@NonNull Request request, @NonNull DownloadListener listener) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        return this.executeRequestAsync(request, listener);
    }

    ListenableFuture<Response> executeRequestAsync(@NonNull Request request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        return this.executeRequestAsync(request, null);
    }

    ListenableFuture<Response> executeRequestAsync(@NonNull Request request, DownloadListener downloadListener) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (this.asyncHttpClient.isClosed()) {
            String msg = String.format("failed to execute request %s connection to the server already closed", request);
            return new ListenableFuture.CompletedFailure("asyncHttpClient already closed", (Throwable)new CometGeneralException(msg));
        }
        this.requestsInventory.incrementAndGet();
        request.getHeaders().add(COMET_SDK_API_HEADER, (Object)this.apiKey);
        String endpoint = request.getUrl();
        return this.asyncHttpClient.executeRequest(request, (AsyncHandler)new AsyncCompletionInventoryHandler(this.requestsInventory, this.logger, endpoint, downloadListener));
    }

    Optional<String> executeRequestSyncWithRetries(@NonNull Request request, boolean throwOnFailure) throws CometApiException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        request.getHeaders().add(COMET_SDK_API_HEADER, (Object)this.apiKey);
        String endpoint = request.getUrl();
        Response response = null;
        for (int i = 1; i < this.maxAuthRetries; ++i) {
            if (this.asyncHttpClient.isClosed()) {
                this.logger.warn("failed to execute request {}, the connection already closed.", (Object)request);
                if (throwOnFailure) {
                    throw new CometApiException("failed to execute request, the connection already closed.");
                }
                return Optional.empty();
            }
            int statusCode = 0;
            try {
                response = (Response)this.asyncHttpClient.executeRequest(request).get();
                statusCode = response.getStatusCode();
                ConnectionUtils.checkResponseStatus(response);
                if (!this.logger.isDebugEnabled()) break;
                this.logger.debug("for endpoint {} got response {}", (Object)endpoint, (Object)response.getResponseBody());
                break;
            }
            catch (CometApiException apiException) {
                String body;
                String string = body = response != null ? response.getStatusText() : RESPONSE_NO_BODY;
                if (i < this.maxAuthRetries - 1) {
                    this.logger.debug("for endpoint {} got response {}, retrying", (Object)endpoint, (Object)body);
                    try {
                        Thread.sleep((long)(2 ^ i) * 1000L);
                    }
                    catch (InterruptedException ex) {
                        this.logger.error("Interrupted while sleeping before next attempt of executing request to {}", (Object)endpoint, (Object)ex);
                    }
                    continue;
                }
                this.logger.error("For endpoint {} got the response '{}', the last retry failed from {} attempts", new Object[]{endpoint, body, this.maxAuthRetries});
                if (throwOnFailure) {
                    throw apiException;
                }
                return Optional.empty();
            }
            catch (CometWebJavaSdkException ex) {
                this.logger.error("Failed to execute request: {}, remote endpoint raised error", (Object)request, (Object)ex);
                if (throwOnFailure) {
                    throw new CometApiException(statusCode, ex.getMessage(), ex.getSdkErrorCode());
                }
                return Optional.empty();
            }
            catch (Throwable e) {
                this.logger.error("Failed to execute request: {}, unexpected error", (Object)request, (Object)e);
                if (throwOnFailure) {
                    throw new CometApiException("failed to execute request, unexpected error", e);
                }
                return Optional.empty();
            }
        }
        if (response == null) {
            return Optional.empty();
        }
        return Optional.of(response.getResponseBody());
    }

    private String buildCometUrl(String endpoint) {
        return this.cometBaseUrl + endpoint;
    }

    public AsyncHttpClient getAsyncHttpClient() {
        return this.asyncHttpClient;
    }

    public String getCometBaseUrl() {
        return this.cometBaseUrl;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public int getMaxAuthRetries() {
        return this.maxAuthRetries;
    }

    public AtomicInteger getRequestsInventory() {
        return this.requestsInventory;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Connection)) {
            return false;
        }
        Connection other = (Connection)o;
        if (this.getMaxAuthRetries() != other.getMaxAuthRetries()) {
            return false;
        }
        AsyncHttpClient this$asyncHttpClient = this.getAsyncHttpClient();
        AsyncHttpClient other$asyncHttpClient = other.getAsyncHttpClient();
        if (this$asyncHttpClient == null ? other$asyncHttpClient != null : !this$asyncHttpClient.equals(other$asyncHttpClient)) {
            return false;
        }
        String this$cometBaseUrl = this.getCometBaseUrl();
        String other$cometBaseUrl = other.getCometBaseUrl();
        if (this$cometBaseUrl == null ? other$cometBaseUrl != null : !this$cometBaseUrl.equals(other$cometBaseUrl)) {
            return false;
        }
        String this$apiKey = this.getApiKey();
        String other$apiKey = other.getApiKey();
        if (this$apiKey == null ? other$apiKey != null : !this$apiKey.equals(other$apiKey)) {
            return false;
        }
        Logger this$logger = this.getLogger();
        Logger other$logger = other.getLogger();
        if (this$logger == null ? other$logger != null : !this$logger.equals(other$logger)) {
            return false;
        }
        AtomicInteger this$requestsInventory = this.getRequestsInventory();
        AtomicInteger other$requestsInventory = other.getRequestsInventory();
        return !(this$requestsInventory == null ? other$requestsInventory != null : !this$requestsInventory.equals(other$requestsInventory));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxAuthRetries();
        AsyncHttpClient $asyncHttpClient = this.getAsyncHttpClient();
        result = result * 59 + ($asyncHttpClient == null ? 43 : $asyncHttpClient.hashCode());
        String $cometBaseUrl = this.getCometBaseUrl();
        result = result * 59 + ($cometBaseUrl == null ? 43 : $cometBaseUrl.hashCode());
        String $apiKey = this.getApiKey();
        result = result * 59 + ($apiKey == null ? 43 : $apiKey.hashCode());
        Logger $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        AtomicInteger $requestsInventory = this.getRequestsInventory();
        result = result * 59 + ($requestsInventory == null ? 43 : $requestsInventory.hashCode());
        return result;
    }

    public String toString() {
        return "Connection(asyncHttpClient=" + this.getAsyncHttpClient() + ", cometBaseUrl=" + this.getCometBaseUrl() + ", apiKey=" + this.getApiKey() + ", logger=" + this.getLogger() + ", maxAuthRetries=" + this.getMaxAuthRetries() + ", requestsInventory=" + this.getRequestsInventory() + ")";
    }

    static final class AsyncOutputStreamDownloadHandler
    implements DownloadListener {
        final OutputStream output;
        final Logger logger;
        final String requestUri;

        AsyncOutputStreamDownloadHandler(OutputStream outputStream, String requestUri, Logger logger) {
            this.output = outputStream;
            this.logger = logger;
            this.requestUri = requestUri;
        }

        @Override
        public void onBytesReceived(byte[] bytes) throws IOException {
            this.output.write(bytes);
        }

        @Override
        public void onRequestResponseCompleted() {
            try {
                this.closeOut();
            }
            catch (IOException e) {
                this.logger.warn("Failed to close output stream after fully receiving response for the request {}", (Object)this.requestUri, (Object)e);
            }
        }

        @Override
        public void onThrowable(Throwable t) {
            this.logger.error("Failed downloading to the output stream for the request {}", (Object)this.requestUri, (Object)t);
            try {
                this.closeOut();
            }
            catch (IOException e) {
                this.logger.warn("Failed to close output stream", (Throwable)e);
            }
        }

        void closeOut() throws IOException {
            try {
                this.output.flush();
            }
            finally {
                this.output.close();
            }
        }
    }

    static final class AsyncFileDownloadHandler
    implements DownloadListener {
        final File outFile;
        final Logger logger;
        RandomAccessFile file;

        AsyncFileDownloadHandler(File file, Logger logger) {
            this.outFile = file;
            this.logger = logger;
        }

        void open() throws IOException {
            this.file = new RandomAccessFile(this.outFile, "rw");
            if (Files.exists(this.outFile.toPath(), new LinkOption[0])) {
                this.file.setLength(0L);
            }
        }

        @Override
        public void onBytesReceived(byte[] bytes) throws IOException {
            try {
                this.file.seek(this.file.length());
                this.file.write(bytes);
            }
            catch (IOException e) {
                this.logger.error("Failed to write received bytes to the file {}", (Object)this.outFile.getPath(), (Object)e);
                throw e;
            }
        }

        @Override
        public void onRequestResponseCompleted() {
            this.close();
        }

        @Override
        public void onThrowable(Throwable t) {
            this.logger.error("Failed to download to the file {}", (Object)this.outFile.getPath(), (Object)t);
            this.close();
        }

        void close() {
            try {
                if (this.file != null) {
                    this.file.close();
                }
            }
            catch (IOException e) {
                this.logger.error("Failed to close the download file {}", (Object)this.outFile.getPath(), (Object)e);
            }
        }
    }

    static final class AsyncCompletionInventoryHandler
    extends AsyncCompletionHandlerBase {
        final AtomicInteger requestInventory;
        final Logger logger;
        final String endpoint;
        DownloadListener downloadListener;
        UploadListener uploadListener;
        HttpResponseStatus status;

        AsyncCompletionInventoryHandler(AtomicInteger inventory, Logger logger, String endpoint) {
            this.requestInventory = inventory;
            this.logger = logger;
            this.endpoint = endpoint;
        }

        AsyncCompletionInventoryHandler(AtomicInteger inventory, Logger logger, String endpoint, DownloadListener downloadListener) {
            this(inventory, logger, endpoint);
            this.downloadListener = downloadListener;
        }

        AsyncCompletionInventoryHandler(AtomicInteger inventory, Logger logger, String endpoint, UploadListener uploadListener) {
            this(inventory, logger, endpoint);
            this.uploadListener = uploadListener;
        }

        public AsyncHandler.State onStatusReceived(HttpResponseStatus status) throws Exception {
            this.status = status;
            return super.onStatusReceived(status);
        }

        public Response onCompleted(Response response) {
            try {
                ConnectionUtils.checkResponseStatus(response);
                this.decreaseInventory();
            }
            catch (CometWebJavaSdkException ex) {
                throw new CometApiException(response.getStatusCode(), ex.getMessage(), ex.getSdkErrorCode());
            }
            finally {
                this.fireOnEnd();
            }
            return response;
        }

        public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
            if (this.downloadListener != null && this.status.getStatusCode() == 200) {
                try {
                    this.downloadListener.onBytesReceived(content.getBodyPartBytes());
                }
                catch (Throwable t) {
                    this.downloadListener.onThrowable(t);
                    throw t;
                }
            }
            return super.onBodyPartReceived(content);
        }

        public AsyncHandler.State onContentWriteProgress(long amount, long current, long total) {
            if (this.uploadListener != null) {
                try {
                    this.uploadListener.onBytesSent(amount, current, total);
                }
                catch (Throwable t) {
                    this.uploadListener.onThrowable(t);
                }
            }
            return super.onContentWriteProgress(amount, current, total);
        }

        public void onThrowable(Throwable t) {
            this.decreaseInventory();
            this.logger.error("failed to execute request to the endpoint {}", (Object)this.endpoint, (Object)t);
            this.fireOnThrowable(t);
        }

        private void decreaseInventory() {
            this.requestInventory.decrementAndGet();
        }

        private void fireOnEnd() {
            if (this.downloadListener != null) {
                try {
                    this.downloadListener.onRequestResponseCompleted();
                }
                catch (Throwable t) {
                    this.downloadListener.onThrowable(t);
                }
            }
            if (this.uploadListener != null) {
                try {
                    this.uploadListener.onRequestResponseCompleted();
                }
                catch (Throwable t) {
                    this.uploadListener.onThrowable(t);
                }
            }
        }

        private void fireOnThrowable(Throwable t) {
            if (this.downloadListener != null) {
                try {
                    this.downloadListener.onThrowable(t);
                }
                catch (Throwable t2) {
                    this.logger.warn("downloadListener.onThrowable", t2);
                }
            }
            if (this.uploadListener != null) {
                try {
                    this.uploadListener.onThrowable(t);
                }
                catch (Throwable t2) {
                    this.logger.warn("uploadListener.onThrowable", t2);
                }
            }
        }
    }
}

