/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.impl.utils;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.NonNull;
import ml.comet.experiment.impl.asset.AssetImpl;
import ml.comet.experiment.impl.asset.AssetType;
import ml.comet.experiment.impl.asset.RemoteAssetImpl;
import ml.comet.experiment.impl.utils.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public final class AssetUtils {
    public static final String REMOTE_FILE_NAME_DEFAULT = "remote";

    public static Stream<AssetImpl> walkFolderAssets(@NonNull File folder, boolean logFilePath, boolean recursive, boolean prefixWithFolderName, @NonNull Optional<Map<String, Object>> metadata, @NonNull Optional<String> type, @NonNull Optional<String> groupingName) throws IOException {
        if (folder == null) {
            throw new NullPointerException("folder is marked non-null but is null");
        }
        if (metadata == null) {
            throw new NullPointerException("metadata is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (groupingName == null) {
            throw new NullPointerException("groupingName is marked non-null but is null");
        }
        return FileUtils.listFiles(folder, recursive).map(path -> AssetUtils.mapToFileAsset(folder, path, logFilePath, prefixWithFolderName, metadata, type, groupingName));
    }

    public static RemoteAssetImpl createRemoteAsset(@NonNull URI uri, Optional<String> logicalPath, boolean overwrite, Optional<Map<String, Object>> metadata, Optional<String> type) {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        RemoteAssetImpl asset = new RemoteAssetImpl();
        asset.setUri(uri);
        asset.setLogicalPath(logicalPath.orElse(AssetUtils.remoteAssetFileName(uri)));
        return (RemoteAssetImpl)AssetUtils.updateAsset(asset, overwrite, metadata, type);
    }

    public static AssetImpl createAssetFromFile(@NonNull File file, Optional<String> logicalPath, boolean overwrite, @NonNull Optional<Map<String, Object>> metadata, @NonNull Optional<String> type) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (metadata == null) {
            throw new NullPointerException("metadata is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        String logicalFileName = logicalPath.orElse(file.getName());
        AssetImpl asset = new AssetImpl();
        asset.setRawFile(file);
        asset.setLogicalPath(logicalFileName);
        asset.setFileExtension(FilenameUtils.getExtension((String)logicalFileName));
        return AssetUtils.updateAsset(asset, overwrite, metadata, type);
    }

    public static AssetImpl createAssetFromData(byte[] data, @NonNull String logicalPath, boolean overwrite, @NonNull Optional<Map<String, Object>> metadata, @NonNull Optional<String> type) {
        if (logicalPath == null) {
            throw new NullPointerException("logicalPath is marked non-null but is null");
        }
        if (metadata == null) {
            throw new NullPointerException("metadata is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        AssetImpl asset = new AssetImpl();
        asset.setRawFileLikeData(data);
        asset.setLogicalPath(logicalPath);
        asset.setFileExtension(FilenameUtils.getExtension((String)logicalPath));
        return AssetUtils.updateAsset(asset, overwrite, metadata, type);
    }

    public static AssetImpl updateAsset(AssetImpl asset, boolean overwrite, Optional<Map<String, Object>> metadata, Optional<String> type) {
        asset.setOverwrite(overwrite);
        metadata.ifPresent(asset::setMetadata);
        asset.setType(type.orElse(AssetType.ASSET.type()));
        return asset;
    }

    public static AssetType toAssetType(@NonNull String typeName) {
        if (typeName == null) {
            throw new NullPointerException("typeName is marked non-null but is null");
        }
        if (typeName.equals(AssetType.POINTS_3D.type())) {
            return AssetType.POINTS_3D;
        }
        typeName = typeName.toUpperCase(Locale.ROOT);
        typeName = typeName.replace("-", "_");
        try {
            return Enum.valueOf(AssetType.class, typeName);
        }
        catch (IllegalArgumentException e) {
            return AssetType.UNKNOWN;
        }
    }

    static String remoteAssetFileName(URI uri) {
        String fileName = uri.getPath();
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return REMOTE_FILE_NAME_DEFAULT;
        }
        int lastSlashIndex = fileName.lastIndexOf("/");
        if (lastSlashIndex >= 0) {
            return fileName.substring(lastSlashIndex + 1);
        }
        return fileName;
    }

    static AssetImpl mapToFileAsset(@NonNull File folder, @NonNull Path assetPath, boolean logFilePath, boolean prefixWithFolderName, @NonNull Optional<Map<String, Object>> metadata, @NonNull Optional<String> type, @NonNull Optional<String> groupingName) {
        if (folder == null) {
            throw new NullPointerException("folder is marked non-null but is null");
        }
        if (assetPath == null) {
            throw new NullPointerException("assetPath is marked non-null but is null");
        }
        if (metadata == null) {
            throw new NullPointerException("metadata is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (groupingName == null) {
            throw new NullPointerException("groupingName is marked non-null but is null");
        }
        AssetImpl asset = new AssetImpl();
        asset.setRawFile(assetPath.toFile());
        String fileName = FileUtils.resolveAssetFileName(folder, assetPath, logFilePath, prefixWithFolderName);
        asset.setLogicalPath(fileName);
        asset.setFileExtension(FilenameUtils.getExtension((String)fileName));
        metadata.ifPresent(asset::setMetadata);
        if (type.isPresent()) {
            asset.setType(type.get());
        } else {
            asset.setType(AssetType.ASSET.type());
        }
        groupingName.ifPresent(asset::setGroupingName);
        return asset;
    }

    private AssetUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

