/*
 * Decompiled with CFR 0.152.
 */
package ml.comet.experiment.impl.utils;

import ml.comet.experiment.registrymodel.DownloadModelOptions;
import org.apache.commons.lang3.StringUtils;

public class ModelUtils {
    static final String DEFAULT_MODEL_NAME_SUFFIX = "latest";

    public static String createRegistryModelName(String modelName) {
        modelName = StringUtils.lowerCase((String)modelName);
        StringBuilder builder = new StringBuilder();
        int sz = modelName.length();
        for (int i = 0; i < sz; ++i) {
            char c = modelName.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                builder.append(c);
                continue;
            }
            builder.append("-");
        }
        modelName = builder.toString();
        if ((modelName = modelName.replaceAll("--*", "-")).startsWith("-")) {
            modelName = modelName.substring(1);
        }
        if (modelName.endsWith("-")) {
            modelName = modelName.substring(0, modelName.length() - 1);
        }
        return modelName;
    }

    public static String registryModelZipFileName(String registryName, DownloadModelOptions options) {
        String suffix = StringUtils.isNotBlank((CharSequence)options.getVersion()) ? options.getVersion() : (StringUtils.isNotBlank((CharSequence)options.getStage()) ? options.getStage() : DEFAULT_MODEL_NAME_SUFFIX);
        return String.format("%s_%s.zip", registryName, suffix);
    }
}

