/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.basic.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import net.accelbyte.sdk.core.Model;

@JsonIgnoreProperties(ignoreUnknown=true)
public class NamespaceContext
extends Model {
    @JsonProperty(value="namespace")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String namespace;
    @JsonProperty(value="publisherNamespace")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String publisherNamespace;
    @JsonProperty(value="studioNamespace")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String studioNamespace;
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String type;

    @JsonIgnore
    public String getType() {
        return this.type;
    }

    @JsonIgnore
    public Type getTypeAsEnum() {
        return Type.valueOf(this.type);
    }

    @JsonIgnore
    public void setType(String type) {
        this.type = type;
    }

    @JsonIgnore
    public void setTypeFromEnum(Type type) {
        this.type = type.toString();
    }

    @JsonIgnore
    public NamespaceContext createFromJson(String json) throws JsonProcessingException {
        return (NamespaceContext)((Object)new ObjectMapper().readValue(json, ((Object)((Object)this)).getClass()));
    }

    @JsonIgnore
    public List<NamespaceContext> createFromJsonList(String json) throws JsonProcessingException {
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<NamespaceContext>>(){});
    }

    public static NamespaceContextBuilder builder() {
        return new NamespaceContextBuilder();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPublisherNamespace() {
        return this.publisherNamespace;
    }

    public String getStudioNamespace() {
        return this.studioNamespace;
    }

    @JsonProperty(value="namespace")
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @JsonProperty(value="publisherNamespace")
    public void setPublisherNamespace(String publisherNamespace) {
        this.publisherNamespace = publisherNamespace;
    }

    @JsonProperty(value="studioNamespace")
    public void setStudioNamespace(String studioNamespace) {
        this.studioNamespace = studioNamespace;
    }

    @Deprecated
    public NamespaceContext(String namespace, String publisherNamespace, String studioNamespace, String type) {
        this.namespace = namespace;
        this.publisherNamespace = publisherNamespace;
        this.studioNamespace = studioNamespace;
        this.type = type;
    }

    public NamespaceContext() {
    }

    public static class NamespaceContextBuilder {
        private String namespace;
        private String publisherNamespace;
        private String studioNamespace;
        private String type;

        public NamespaceContextBuilder type(String type) {
            this.type = type;
            return this;
        }

        public NamespaceContextBuilder typeFromEnum(Type type) {
            this.type = type.toString();
            return this;
        }

        NamespaceContextBuilder() {
        }

        @JsonProperty(value="namespace")
        public NamespaceContextBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @JsonProperty(value="publisherNamespace")
        public NamespaceContextBuilder publisherNamespace(String publisherNamespace) {
            this.publisherNamespace = publisherNamespace;
            return this;
        }

        @JsonProperty(value="studioNamespace")
        public NamespaceContextBuilder studioNamespace(String studioNamespace) {
            this.studioNamespace = studioNamespace;
            return this;
        }

        public NamespaceContext build() {
            return new NamespaceContext(this.namespace, this.publisherNamespace, this.studioNamespace, this.type);
        }

        public String toString() {
            return "NamespaceContext.NamespaceContextBuilder(namespace=" + this.namespace + ", publisherNamespace=" + this.publisherNamespace + ", studioNamespace=" + this.studioNamespace + ", type=" + this.type + ")";
        }
    }

    public static enum Type {
        Game("Game"),
        Publisher("Publisher"),
        Studio("Studio");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

