/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.basic.operations.file_upload;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.basic.models.FileUploadUrlInfo;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicGeneratedUploadUrl
extends Operation {
    private String path = "/basic/v1/public/namespaces/{namespace}/folders/{folder}/files";
    private String method = "POST";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String folder;
    private String namespace;
    private String fileType;

    @Deprecated
    public PublicGeneratedUploadUrl(String folder, String namespace, String fileType) {
        this.folder = folder;
        this.namespace = namespace;
        this.fileType = fileType;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.folder != null) {
            pathParams.put("folder", this.folder);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("fileType", this.fileType == null ? null : Arrays.asList(this.fileType));
        return queryParams;
    }

    public boolean isValid() {
        if (this.folder == null) {
            return false;
        }
        if (this.namespace == null) {
            return false;
        }
        return this.fileType != null;
    }

    public FileUploadUrlInfo parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new FileUploadUrlInfo().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("fileType", "None");
        return result;
    }

    public static PublicGeneratedUploadUrlBuilder builder() {
        return new PublicGeneratedUploadUrlBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public static class PublicGeneratedUploadUrlBuilder {
        private String folder;
        private String namespace;
        private String fileType;

        PublicGeneratedUploadUrlBuilder() {
        }

        public PublicGeneratedUploadUrlBuilder folder(String folder) {
            this.folder = folder;
            return this;
        }

        public PublicGeneratedUploadUrlBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PublicGeneratedUploadUrlBuilder fileType(String fileType) {
            this.fileType = fileType;
            return this;
        }

        public PublicGeneratedUploadUrl build() {
            return new PublicGeneratedUploadUrl(this.folder, this.namespace, this.fileType);
        }

        public String toString() {
            return "PublicGeneratedUploadUrl.PublicGeneratedUploadUrlBuilder(folder=" + this.folder + ", namespace=" + this.namespace + ", fileType=" + this.fileType + ")";
        }
    }
}

