/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.basic.operations.misc;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.basic.models.RetrieveCountryGroupResponse;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class GetCountryGroups
extends Operation {
    private String path = "/basic/v1/admin/namespaces/{namespace}/misc/countrygroups";
    private String method = "GET";
    private List<String> consumes = Arrays.asList(new String[0]);
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String groupCode;

    @Deprecated
    public GetCountryGroups(String namespace, String groupCode) {
        this.namespace = namespace;
        this.groupCode = groupCode;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("groupCode", this.groupCode == null ? null : Arrays.asList(this.groupCode));
        return queryParams;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public List<RetrieveCountryGroupResponse> parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<RetrieveCountryGroupResponse>>(){});
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("groupCode", "None");
        return result;
    }

    public static GetCountryGroupsBuilder builder() {
        return new GetCountryGroupsBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getGroupCode() {
        return this.groupCode;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setGroupCode(String groupCode) {
        this.groupCode = groupCode;
    }

    public static class GetCountryGroupsBuilder {
        private String namespace;
        private String groupCode;

        GetCountryGroupsBuilder() {
        }

        public GetCountryGroupsBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public GetCountryGroupsBuilder groupCode(String groupCode) {
            this.groupCode = groupCode;
            return this;
        }

        public GetCountryGroups build() {
            return new GetCountryGroups(this.namespace, this.groupCode);
        }

        public String toString() {
            return "GetCountryGroups.GetCountryGroupsBuilder(namespace=" + this.namespace + ", groupCode=" + this.groupCode + ")";
        }
    }
}

