/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.basic.operations.user_profile;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.basic.models.UserProfilePrivateInfo;
import net.accelbyte.sdk.api.basic.models.UserProfileStatusUpdate;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class UpdateUserProfileStatus
extends Operation {
    private String path = "/basic/v1/admin/namespaces/{namespace}/users/{userId}/profiles/status";
    private String method = "PATCH";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String userId;
    private UserProfileStatusUpdate body;

    @Deprecated
    public UpdateUserProfileStatus(String namespace, String userId, UserProfileStatusUpdate body) {
        this.namespace = namespace;
        this.userId = userId;
        this.body = body;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public UserProfileStatusUpdate getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.userId != null;
    }

    public UserProfilePrivateInfo parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new UserProfilePrivateInfo().createFromJson(json);
    }

    public static UpdateUserProfileStatusBuilder builder() {
        return new UpdateUserProfileStatusBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUserId() {
        return this.userId;
    }

    public UserProfileStatusUpdate getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setBody(UserProfileStatusUpdate body) {
        this.body = body;
    }

    public static class UpdateUserProfileStatusBuilder {
        private String namespace;
        private String userId;
        private UserProfileStatusUpdate body;

        UpdateUserProfileStatusBuilder() {
        }

        public UpdateUserProfileStatusBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public UpdateUserProfileStatusBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public UpdateUserProfileStatusBuilder body(UserProfileStatusUpdate body) {
            this.body = body;
            return this;
        }

        public UpdateUserProfileStatus build() {
            return new UpdateUserProfileStatus(this.namespace, this.userId, this.body);
        }

        public String toString() {
            return "UpdateUserProfileStatus.UpdateUserProfileStatusBuilder(namespace=" + this.namespace + ", userId=" + this.userId + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

