/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.basic.operations.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class DeleteConfig
extends Operation {
    private String path = "/basic/v1/admin/namespaces/{namespace}/configs/{configKey}";
    private String method = "DELETE";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String configKey;
    private String namespace;

    @Deprecated
    public DeleteConfig(String customBasePath, String configKey, String namespace) {
        this.configKey = configKey;
        this.namespace = namespace;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.configKey != null) {
            pathParams.put("configKey", this.configKey);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public boolean isValid() {
        if (this.configKey == null) {
            return false;
        }
        return this.namespace != null;
    }

    public void handleEmptyResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 204) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
    }

    public static DeleteConfigBuilder builder() {
        return new DeleteConfigBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getConfigKey() {
        return this.configKey;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setConfigKey(String configKey) {
        this.configKey = configKey;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public static class DeleteConfigBuilder {
        private String customBasePath;
        private String configKey;
        private String namespace;

        DeleteConfigBuilder() {
        }

        public DeleteConfigBuilder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public DeleteConfigBuilder configKey(String configKey) {
            this.configKey = configKey;
            return this;
        }

        public DeleteConfigBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public DeleteConfig build() {
            return new DeleteConfig(this.customBasePath, this.configKey, this.namespace);
        }

        public String toString() {
            return "DeleteConfig.DeleteConfigBuilder(customBasePath=" + this.customBasePath + ", configKey=" + this.configKey + ", namespace=" + this.namespace + ")";
        }
    }
}

